/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class PanningHandler
implements ToolHandler {
    private final Point lastMousePosition = new Point();
    private final DocumentViewController documentViewController;
    private final DocumentViewModel documentViewModel;
    private final AbstractDocumentView parentComponent;

    public PanningHandler(DocumentViewController documentViewController, DocumentViewModel documentViewModel, AbstractDocumentView abstractDocumentView) {
        this.documentViewController = documentViewController;
        this.documentViewModel = documentViewModel;
        this.parentComponent = abstractDocumentView;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            JScrollBar jScrollBar = this.documentViewModel.getDocumentViewScrollPane().getVerticalScrollBar();
            JScrollBar jScrollBar2 = this.documentViewModel.getDocumentViewScrollPane().getHorizontalScrollBar();
            if (jScrollBar != null && jScrollBar2 != null) {
                Point point = new Point((int)mouseEvent.getPoint().getX() - jScrollBar2.getValue(), (int)mouseEvent.getPoint().getY() - jScrollBar.getValue());
                int n = (int)((double)jScrollBar2.getValue() - (point.getX() - this.lastMousePosition.getX()));
                int n2 = (int)((double)jScrollBar.getValue() - (point.getY() - this.lastMousePosition.getY()));
                jScrollBar2.setValue(n);
                jScrollBar.setValue(n2);
                this.lastMousePosition.setLocation(point);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            JScrollBar jScrollBar = this.documentViewModel.getDocumentViewScrollPane().getVerticalScrollBar();
            JScrollBar jScrollBar2 = this.documentViewModel.getDocumentViewScrollPane().getHorizontalScrollBar();
            this.lastMousePosition.setLocation(mouseEvent.getPoint().getX() - (double)jScrollBar2.getValue(), mouseEvent.getPoint().getY() - (double)jScrollBar.getValue());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.documentViewController.clearSelectedAnnotations();
        if (this.parentComponent != null) {
            this.parentComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().isViewToolModeSelected(1)) {
            this.documentViewController.setViewCursor(2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().getViewToolMode() == 1) {
            this.documentViewController.setViewCursor(1);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

