/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.edit.content.TextContentEditor;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.tools.HighLightAnnotationHandler;
import org.icepdf.ri.common.tools.TextSelection;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;

public class EditTextHandler
extends TextSelection
implements ToolHandler {
    private final SwingController controller;

    public EditTextHandler(SwingController swingController, AbstractPageViewComponent abstractPageViewComponent) {
        super(swingController.getDocumentViewController(), abstractPageViewComponent);
        this.controller = swingController;
    }

    public void editWord(Point point) {
        try {
            Page page = this.pageViewComponent.getPage();
            this.wordSelectHandler(page, point);
            this.updateSelectedText();
            this.pageViewComponent.reinitialize();
            this.pageViewComponent.repaint();
        }
        catch (IOException | InterruptedException exception) {
            logger.severe("Error editing word: " + String.valueOf(exception));
        }
    }

    public void editLine(Point point) {
        try {
            Page page = this.pageViewComponent.getPage();
            this.lineSelectHandler(page, point);
            this.updateSelectedText();
            this.pageViewComponent.reinitialize();
            this.pageViewComponent.repaint();
        }
        catch (IOException | InterruptedException exception) {
            logger.severe("Error editing line: " + String.valueOf(exception));
        }
    }

    private void updateSelectedText() throws IOException, InterruptedException {
        ArrayList<Shape> arrayList = HighLightAnnotationHandler.getSelectedTextBounds(this.pageViewComponent, this.getPageTransform());
        if (arrayList != null && !arrayList.isEmpty()) {
            GeneralPath generalPath = EditTextHandler.convertTextShapesToBounds(arrayList);
            Rectangle rectangle = this.convertToPageSpace(arrayList, generalPath);
            Page page = this.pageViewComponent.getPage();
            String string = page.getViewText().getSelected().toString().trim();
            TextEditDialog textEditDialog = new TextEditDialog(this.controller, this.controller.getMessageBundle(), string, this.isEditingSupported(page));
            textEditDialog.setVisible(true);
            if (!textEditDialog.isCancelled()) {
                String string2 = textEditDialog.getText();
                TextContentEditor.updateText((Page)this.pageViewComponent.getPage(), (String)string, (Rectangle)rectangle, (String)string2);
            }
        }
    }

    private boolean isEditingSupported(Page page) throws InterruptedException {
        ArrayList arrayList = page.getViewText().getSelectedWordText();
        if (arrayList != null && !arrayList.isEmpty() && ((WordText)arrayList.get(0)).getGlyphs() != null && !((WordText)arrayList.get(0)).getGlyphs().isEmpty()) {
            Name name = ((GlyphText)((WordText)arrayList.get(0)).getGlyphs().get(0)).getFontName();
            Font font = page.getResources().getFont(name);
            int n = font.getCharacterCount();
            return font.hasUnicodeCMap() || n > 94;
        }
        return false;
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static class TextEditDialog
    extends EscapeJDialog {
        private GridBagConstraints constraints;
        private boolean cancelled;
        private boolean showEditWarning;
        private JTextField editTextField;
        protected ResourceBundle messageBundle;

        public TextEditDialog(Controller controller, ResourceBundle resourceBundle, String string, boolean bl) {
            super(controller.getViewerFrame(), true);
            this.messageBundle = resourceBundle;
            this.showEditWarning = !bl;
            this.buildUI(string);
        }

        private void buildUI(String string) {
            JComponent jComponent;
            this.setTitle(this.messageBundle.getString("viewer.dialog.textEdit.title"));
            this.setDefaultCloseOperation(2);
            this.setLayout(new GridBagLayout());
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 2;
            this.constraints.weightx = 1.0;
            this.constraints.anchor = 17;
            this.constraints.insets = new Insets(5, 10, 10, 10);
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.editTextField = new JTextField(50);
            this.editTextField.setText(string);
            this.addGB(jPanel, this.editTextField, 0, 0, 1, 2);
            if (this.showEditWarning) {
                jComponent = new JLabel(this.messageBundle.getString("viewer.dialog.textEdit.warning.label"));
                this.addGB(jPanel, jComponent, 0, 1, 1, 2);
            }
            jComponent = new JButton(this.messageBundle.getString("viewer.dialog.textEdit.cancel.label"));
            ((AbstractButton)jComponent).addActionListener(actionEvent -> {
                this.cancelled = true;
                this.setVisible(false);
                this.dispose();
            });
            this.addGB(jPanel, jComponent, 0, 2, 1, 1);
            JButton jButton = new JButton(this.messageBundle.getString("viewer.dialog.textEdit.save.label"));
            jButton.addActionListener(actionEvent -> {
                this.setVisible(false);
                this.dispose();
            });
            this.addGB(jPanel, jButton, 1, 2, 1, 1);
            this.setContentPane(jPanel);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
            this.constraints.gridx = n;
            this.constraints.gridy = n2;
            this.constraints.gridwidth = n4;
            this.constraints.gridheight = n3;
            jPanel.add(component, this.constraints);
        }

        public String getText() {
            return this.editTextField.getText();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

