/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.icepdf.core.pobjects.Page;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.util.ViewerPropertiesManager;

public abstract class CommonToolHandler {
    private static final Logger logger = Logger.getLogger(CommonToolHandler.class.toString());
    protected final AbstractPageViewComponent pageViewComponent;
    protected DocumentViewController documentViewController;
    protected final Preferences preferences;

    public CommonToolHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        this.pageViewComponent = abstractPageViewComponent;
        this.documentViewController = documentViewController;
        ViewerPropertiesManager viewerPropertiesManager = ViewerPropertiesManager.getInstance();
        this.preferences = viewerPropertiesManager.getPreferences();
    }

    protected abstract void checkAndApplyPreferences();

    protected AffineTransform getToPageSpaceTransform() {
        return this.getToPageSpaceTransform(this.pageViewComponent);
    }

    protected AffineTransform getToPageSpaceTransform(AbstractPageViewComponent abstractPageViewComponent) {
        Page page = abstractPageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.getToPageSpaceTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected AffineTransform getPageTransform() {
        return this.getPageTransform(this.pageViewComponent);
    }

    protected AffineTransform getPageTransform(AbstractPageViewComponent abstractPageViewComponent) {
        Page page = abstractPageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected Rectangle convertToPageSpace(Rectangle rectangle) {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.convertToPageSpace(rectangle, documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected Point2D.Float convertToPageSpace(Point point) {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.convertToPageSpace(point, documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected Shape convertToPageSpace(Shape shape) {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        return page.convertToPageSpace(shape, documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
    }

    protected Point2D[] convertToPageSpace(Point ... pointArray) {
        if (pointArray != null) {
            Page page = this.pageViewComponent.getPage();
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            AffineTransform affineTransform = page.getToPageSpaceTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            Point2D[] point2DArray = new Point2D[pointArray.length];
            int n = pointArray.length;
            for (int i = 0; i < n; ++i) {
                point2DArray[i] = Page.convertTo((Point)pointArray[i], (AffineTransform)affineTransform);
            }
            return point2DArray;
        }
        return null;
    }
}

