/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.SquareAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class CircleAnnotationHandler
extends SquareAnnotationHandler {
    private static final Logger logger;
    protected static final float DEFAULT_STROKE_WIDTH = 3.0f;
    private static final BasicStroke stroke;
    private static Color lineColor;
    private static Color internalColor;
    private static final boolean useInternalColor;
    private static int defaultOpacity;

    public CircleAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.checkAndApplyPreferences();
    }

    @Override
    public void paintTool(Graphics graphics) {
        if (this.rectangle != null) {
            Ellipse2D.Double double_ = new Ellipse2D.Double(this.rectangle.getMinX(), this.rectangle.getMinY(), this.rectangle.getWidth(), this.rectangle.getHeight());
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(CircleAnnotationHandler.stroke);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)defaultOpacity / 255.0f));
            if (useInternalColor) {
                graphics2D.setColor(internalColor);
                graphics2D.fill(double_);
            }
            graphics2D.setColor(lineColor);
            graphics2D.draw(double_);
            graphics.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        this.rectangle = this.convertToPageSpace(this.rectangle);
        this.rectToDraw.setRect(this.rectToDraw.getX() - 3.0, this.rectToDraw.getY() - 3.0, this.rectToDraw.getWidth() + 6.0, this.rectToDraw.getHeight() + 6.0);
        Rectangle rectangle = this.convertToPageSpace(this.rectToDraw);
        CircleAnnotation circleAnnotation = (CircleAnnotation)AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_CIRCLE, (Rectangle)rectangle);
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        circleAnnotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        circleAnnotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
        circleAnnotation.setTitleText(SystemProperties.USER_NAME);
        circleAnnotation.setColor(lineColor);
        circleAnnotation.setOpacity(defaultOpacity);
        if (circleAnnotation.isFillColor() || useInternalColor) {
            circleAnnotation.setFillColor(internalColor);
            if (!circleAnnotation.isFillColor()) {
                circleAnnotation.setFillColor(true);
            }
        }
        circleAnnotation.setRectangle(this.rectangle);
        circleAnnotation.setBorderStyle(this.borderStyle);
        AffineTransform affineTransform = this.getToPageSpaceTransform();
        AffineTransform affineTransform2 = this.getPageTransform();
        circleAnnotation.setBBox(new Rectangle(0, 0, rectangle.width, rectangle.height));
        circleAnnotation.resetAppearanceStream(affineTransform);
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)circleAnnotation, this.documentViewController, this.pageViewComponent);
        Rectangle rectangle2 = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        markupAnnotationComponent.setBounds(rectangle2);
        markupAnnotationComponent.refreshAnnotationRect();
        this.documentViewController.addNewAnnotation(markupAnnotationComponent);
        PopupAnnotationComponent popupAnnotationComponent = markupAnnotationComponent.getPopupAnnotationComponent();
        popupAnnotationComponent.setBoundsRelativeToParent(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2, affineTransform2);
        popupAnnotationComponent.setVisible(false);
        ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(false);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.circle.selection.type", 0));
        this.rectangle = null;
        this.clearRectangle(this.pageViewComponent);
    }

    @Override
    protected void checkAndApplyPreferences() {
        defaultOpacity = this.preferences.getInt("application.viewer.preference.annotation.circle.fill.opacity", defaultOpacity);
        lineColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.circle.color", lineColor.getRGB()));
        internalColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.circle.fill.color", internalColor.getRGB()));
    }

    static {
        block5: {
            int n;
            String string;
            block4: {
                logger = Logger.getLogger(CircleAnnotationHandler.class.toString());
                try {
                    string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.circle.stroke.color", (String)"#00ff00");
                    n = ColorUtil.convertColor((String)string);
                    lineColor = new Color(n >= 0 ? n : Integer.parseInt("00ff00", 16));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading circle Annotation stroke colour");
                }
            }
            useInternalColor = Defs.booleanProperty((String)"org.icepdf.core.views.page.annotation.circle.fill.enabled", (boolean)false);
            try {
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.circle.fill.color", (String)"#ffffff");
                n = ColorUtil.convertColor((String)string);
                internalColor = new Color(n >= 0 ? n : Integer.parseInt("ffffff", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading circle Annotation fill colour");
            }
        }
        defaultOpacity = Defs.intProperty((String)"org.icepdf.core.views.page.annotation.squareCircle.fill.opacity", (int)255);
        float f = (float)Defs.doubleProperty((String)"org.icepdf.core.views.page.annotation.circle.stroke.width", (double)3.0);
        stroke = new BasicStroke(f, 0, 0, 1.0f);
    }
}

