/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.search;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.search.SearchTerm;

public class DocumentSearchModelImpl {
    private final Map<Integer, WeakReference<PageText>> searchResultCache = new ConcurrentHashMap<Integer, WeakReference<PageText>>(256);
    private final ArrayList<SearchTerm> searchTerms = new ArrayList();
    private int searchPageCursor = -1;
    private int searchLineCursor = -1;
    private int searchWordCursor = -1;

    public ArrayList<SearchTerm> getSearchTerms() {
        return this.searchTerms;
    }

    public void addSearchTerm(SearchTerm searchTerm) {
        if (!this.searchTerms.contains(searchTerm)) {
            this.searchTerms.add(searchTerm);
        }
    }

    public void removeSearchTerm(SearchTerm searchTerm) {
        this.searchTerms.remove(searchTerm);
    }

    public void addPageSearchHit(int n, PageText pageText, int n2) {
        if (this.searchPageCursor == -1) {
            this.searchPageCursor = n;
            this.searchLineCursor = 0;
            this.searchWordCursor = -1;
        }
        this.searchResultCache.put(n, new WeakReference<PageText>(pageText));
    }

    public Set<Integer> getPageSearchHits() {
        return this.searchResultCache.keySet();
    }

    public int getPageSearchHitsSize() {
        return this.searchResultCache.keySet().size();
    }

    public boolean isPageSearchHit(int n) {
        return this.searchResultCache.get(n) != null;
    }

    public PageText getPageTextHit(int n) {
        WeakReference<PageText> weakReference = this.searchResultCache.get(n);
        if (weakReference != null && weakReference.get() != null) {
            return (PageText)weakReference.get();
        }
        return null;
    }

    public boolean isPageTextMatch(int n, PageText pageText) {
        WeakReference<PageText> weakReference = this.searchResultCache.get(n);
        if (weakReference == null) {
            return false;
        }
        PageText pageText2 = (PageText)weakReference.get();
        return pageText2 == null || !pageText2.equals(pageText);
    }

    public void clearSearchResults(int n) {
        PageText pageText;
        WeakReference<PageText> weakReference = this.searchResultCache.get(n);
        if (weakReference != null && (pageText = (PageText)weakReference.get()) != null) {
            pageText.clearHighlighted();
        }
        this.searchResultCache.remove(n);
    }

    public void clearSearchResults() {
        this.searchPageCursor = -1;
        this.searchLineCursor = -1;
        this.searchWordCursor = -1;
        Collection<WeakReference<PageText>> collection = this.searchResultCache.values();
        for (WeakReference<PageText> weakReference : collection) {
            PageText pageText = (PageText)weakReference.get();
            if (pageText == null) continue;
            pageText.clearHighlighted();
        }
        this.searchResultCache.clear();
        this.searchTerms.clear();
    }

    public int getSearchPageCursor() {
        return this.searchPageCursor;
    }

    public void setSearchPageCursor(int n) {
        this.searchPageCursor = n;
    }

    public int getSearchWordCursor() {
        return this.searchWordCursor;
    }

    public void setSearchWordCursor(int n) {
        this.searchWordCursor = n;
    }

    public int getSearchLineCursor() {
        return this.searchLineCursor;
    }

    public void setSearchLineCursor(int n) {
        this.searchLineCursor = n;
    }
}

