/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.properties.FontPanel;

public class FontDialog
extends EscapeJDialog
implements ActionListener,
WindowListener {
    private static final int TIMER_REFRESH = 20;
    private final SwingController controller;
    private final ResourceBundle messageBundle;
    private FontPanel fontPropertiesPanel;
    private JButton okButton;
    private GridBagConstraints constraints;

    public FontDialog(Frame frame, SwingController swingController, Document document, ResourceBundle resourceBundle) {
        super(frame, true);
        this.setFocusable(true);
        this.controller = swingController;
        this.messageBundle = resourceBundle;
        this.setGui();
    }

    private void setGui() {
        this.setTitle(this.messageBundle.getString("viewer.dialog.fonts.title"));
        this.setResizable(true);
        this.addWindowListener(this);
        this.fontPropertiesPanel = new FontPanel(this.controller);
        this.okButton = new JButton(this.messageBundle.getString("viewer.button.ok.label"));
        this.okButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.addGB(jPanel, this.fontPropertiesPanel, 0, 0, 1, 1);
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.addGB(jPanel, this.okButton, 0, 1, 1, 1);
        this.setLayout(new BorderLayout(15, 15));
        this.add((Component)jPanel, "Center");
        this.setSize(640, 480);
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fontPropertiesPanel.closeWindowOperations();
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.fontPropertiesPanel.closeWindowOperations();
            this.setVisible(false);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.fontPropertiesPanel.closeWindowOperations();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.fontPropertiesPanel.closeWindowOperations();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

