/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PInfo;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;
import org.icepdf.ri.common.properties.PropertiesDialog;

public class CustomPropertiesPanel
extends JPanel {
    private final GridBagConstraints constraints;
    private final Map<JTextField, JTextField> rows;
    private final PropertiesDialog dialog;
    private final Set<JTextField> invalids;
    private final ResourceBundle messageBundle;

    public CustomPropertiesPanel(Document document, ResourceBundle resourceBundle, PropertiesDialog propertiesDialog) {
        this.dialog = propertiesDialog;
        this.messageBundle = resourceBundle;
        PInfo pInfo = document.getInfo();
        this.constraints = new GridBagConstraints();
        this.rows = new HashMap<JTextField, JTextField>();
        this.invalids = new HashSet<JTextField>();
        if (pInfo != null) {
            this.setLayout(new GridBagLayout());
            this.setAlignmentY(0.0f);
            this.constraints.fill = 0;
            this.constraints.weightx = 1.0;
            this.constraints.weighty = 1.0;
            this.constraints.anchor = 12;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.documentInformation.description.label"), 1, 0));
            boolean bl = document.getSecurityManager() == null || document.getSecurityManager().getPermissions().getPermissions(2);
            Map map = pInfo.getAllCustomExtensions();
            Map<String, String> map2 = map.entrySet().stream().collect(Collectors.toMap(entry -> CustomPropertiesPanel.objToString(entry.getKey(), document), entry -> CustomPropertiesPanel.objToString(entry.getValue(), document)));
            List list = map2.keySet().stream().sorted().collect(Collectors.toList());
            for (int i = 0; i < list.size(); ++i) {
                this.addRow(jPanel, (String)list.get(i), map2.get(list.get(i)), bl, i);
            }
            if (bl) {
                this.constraints.fill = 0;
                this.constraints.anchor = 10;
                JButton jButton = new JButton(resourceBundle.getString("viewer.dialog.documentProperties.tab.custom.button.add"));
                jButton.addActionListener(actionEvent -> {
                    jPanel.remove(jButton);
                    int n = jPanel.getComponentCount() / 3;
                    this.addRow(jPanel, "", "", true, n);
                    this.constraints.fill = 0;
                    this.constraints.anchor = 10;
                    this.addGB(jPanel, jButton, 1, n + 1, 1, 1);
                    jPanel.revalidate();
                });
                this.addGB(jPanel, jButton, 1, list.size(), 1, 1);
            }
            this.constraints.anchor = 11;
            this.constraints.fill = 2;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            this.addGB(this, jPanel, 0, 0, 1, 1);
        } else {
            this.add(new JLabel("No info"));
        }
    }

    Map<String, String> getProperties() {
        return this.rows.entrySet().stream().filter(entry -> ((JTextField)entry.getKey()).getText() != null && !((JTextField)entry.getKey()).getText().isEmpty()).collect(Collectors.toMap(entry -> ((JTextField)entry.getKey()).getText().trim(), entry -> ((JTextField)entry.getValue()).getText()));
    }

    private void addRow(JPanel jPanel, JTextField jTextField, JTextField jTextField2, JButton jButton, int n) {
        this.constraints.fill = 2;
        this.constraints.weightx = 0.5;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 12;
        this.constraints.insets = new Insets(0, 5, 5, 5);
        this.addGB(jPanel, jTextField, 0, n, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 18;
        this.addGB(jPanel, jTextField2, 1, n, 1, 1);
        if (jButton != null) {
            this.constraints.weightx = 0.25;
            this.constraints.anchor = 12;
            this.addGB(jPanel, jButton, 2, n, 1, 1);
        }
        this.rows.put(jTextField, jTextField2);
    }

    private void addRow(JPanel jPanel, String string, String string2, boolean bl, int n) {
        final JTextField jTextField = CustomPropertiesPanel.createTextField(string, bl);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.verifyInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.verifyInput();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.verifyInput();
            }

            private void verifyInput() {
                String string = jTextField.getText().trim();
                Set set = PInfo.ALL_COMMON_KEYS.stream().map(Name::getName).collect(Collectors.toSet());
                set.addAll(CustomPropertiesPanel.this.rows.keySet().stream().filter(jTextField2 -> jTextField2 != jTextField).map(JTextComponent::getText).collect(Collectors.toList()));
                boolean bl = string.isEmpty() || !set.contains(string);
                jTextField.setForeground(bl ? Color.BLACK : Color.RED);
                if (bl) {
                    CustomPropertiesPanel.this.invalids.remove(jTextField);
                } else {
                    CustomPropertiesPanel.this.invalids.add(jTextField);
                }
                CustomPropertiesPanel.this.dialog.setOkEnabled(CustomPropertiesPanel.this.invalids.isEmpty());
            }
        });
        this.addRow(jPanel, jTextField, CustomPropertiesPanel.createTextField(string2, bl), bl ? this.createDeleteButton(jPanel, n) : null, n);
    }

    private JButton createDeleteButton(JPanel jPanel, int n) {
        JButton jButton = new JButton(this.messageBundle.getString("viewer.dialog.documentProperties.tab.custom.button.delete"));
        jButton.addActionListener(actionEvent -> {
            Component[] componentArray = jPanel.getComponents();
            int n2 = n * 3;
            int n3 = n2 + 3;
            for (int i = n2; i < n3; ++i) {
                jPanel.remove(componentArray[i]);
            }
            JTextField jTextField = (JTextField)componentArray[n2];
            this.rows.remove(jTextField);
            this.invalids.remove(jTextField);
            List<Component> list = Arrays.asList(Arrays.copyOfRange(componentArray, n3, componentArray.length));
            list.forEach(jPanel::remove);
            for (int i = 0; i < list.size() - 1; i += 3) {
                this.addRow(jPanel, (JTextField)list.get(i), (JTextField)list.get(i + 1), this.createDeleteButton(jPanel, n + i / 3), n + i / 3);
            }
            this.constraints.fill = 0;
            this.constraints.anchor = 10;
            this.addGB(jPanel, list.get(list.size() - 1), 1, n + list.size() / 3 + 1, 1, 1);
            jPanel.revalidate();
        });
        return jButton;
    }

    private static String objToString(Object object, Document document) {
        if (object instanceof Name) {
            return ((Name)object).getName();
        }
        if (object instanceof StringObject) {
            return Utils.convertStringObject((Library)document.getCatalog().getLibrary(), (StringObject)((StringObject)object));
        }
        return object.toString();
    }

    private static JTextField createTextField(String string, boolean bl) {
        JTextField jTextField = new JTextField(string);
        jTextField.setEnabled(bl);
        return jTextField;
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

