/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.print;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.CancelablePrintJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.ri.common.print.PrintHelper;
import org.icepdf.ri.common.print.PrintJobWatcher;

public class PrintHelperImpl
extends PrintHelper {
    private static final Logger logger = Logger.getLogger(PrintHelperImpl.class.toString());
    private final PageTree pageTree;
    private final Container container;
    private final float userRotation;

    public PrintHelperImpl(Container container, PageTree pageTree, float f, MediaSizeName mediaSizeName, PrintQuality printQuality) {
        this(container, pageTree, f, PrintHelperImpl.createDocAttributeSet(mediaSizeName), PrintHelperImpl.createPrintRequestAttributeSet(printQuality, mediaSizeName));
    }

    public PrintHelperImpl(Container container, PageTree pageTree, float f, DocAttributeSet docAttributeSet, PrintRequestAttributeSet printRequestAttributeSet) {
        super(docAttributeSet, printRequestAttributeSet);
        this.container = container;
        this.pageTree = pageTree;
        this.userRotation = f;
        this.setupPrintService(0, this.pageTree.getNumberOfPages(), 1, true, false);
    }

    @Override
    public void showPrintSetupDialog() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintService(this.getPrintServiceOrDefault());
            printerJob.pageDialog(this.getPrintRequestAttributeSet());
        }
        catch (HeadlessException headlessException) {
            logger.log(Level.WARNING, "Headless environment detected, cannot show print dialog", headlessException);
        }
        catch (PrinterException printerException) {
            logger.log(Level.WARNING, "Printer does not support print service and or Java2d", printerException);
        }
    }

    public float getUserRotation() {
        return this.userRotation;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.getCurrentPage() != n) {
            this.setCurrentPage(n + 1);
        }
        if (n < 0 || n >= this.pageTree.getNumberOfPages()) {
            return 1;
        }
        try {
            Page page = this.pageTree.getPage(n);
            page.init();
            PDimension pDimension = page.getSize(this.userRotation);
            float f = (float)pDimension.getWidth();
            float f2 = (float)pDimension.getHeight();
            float f3 = 1.0f;
            Point point = new Point();
            float f4 = this.userRotation;
            boolean bl = true;
            if (f > f2 && pageFormat.getOrientation() == 1) {
                bl = false;
                f4 -= 90.0f;
            }
            Rectangle rectangle = null;
            if (this.isPrintFitToMargin()) {
                Dimension dimension = pDimension.toDimension();
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
                List list = page.getAnnotations();
                if (list != null) {
                    for (Annotation annotation : list) {
                        Rectangle2D.union(float_, annotation.calculatePageSpaceRectangle(page, 1, f4, f3), float_);
                    }
                }
                Dimension dimension2 = bl ? new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()) : new Dimension((int)pageFormat.getImageableHeight(), (int)pageFormat.getImageableWidth());
                float f5 = (float)dimension2.width / float_.width;
                float f6 = (float)dimension2.height / float_.height;
                f3 = Math.min(f5, f6);
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.setToScale(f3, f3);
                rectangle = affineTransform.createTransformedShape(float_).getBounds();
                point.x = (int)pageFormat.getImageableX() - rectangle.x;
                point.y = (int)pageFormat.getImageableY() - rectangle.y;
            }
            graphics.translate(point.x, point.y);
            graphics.setClip(rectangle);
            page.paint(graphics, 2, 1, f4, f3, this.isPaintAnnotation(), this.isPaintSearchHighlight());
            if (CLIPPING_FIX_ENABLED) {
                graphics.setColor(Color.WHITE);
                graphics.drawRect(-9, -9, 10, 10);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.log(Level.FINEST, "Printing: Page initialization and painting was interrupted: " + n);
        }
        return 0;
    }

    @Override
    public void print() throws PrintException {
        if (this.getPrintServiceOrDefault() != null) {
            this.calculateTotalPagesToPrint();
            this.getPrintServiceOrDefault().createPrintJob().print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), this.getPrintRequestAttributeSet());
        } else {
            logger.fine("No print could be found to print to.");
        }
    }

    @Override
    public CancelablePrintJob cancelablePrint() throws PrintException {
        if (this.getPrintServiceOrDefault() != null) {
            this.calculateTotalPagesToPrint();
            DocPrintJob docPrintJob = this.getPrintServiceOrDefault().createPrintJob();
            if (docPrintJob instanceof CancelablePrintJob) {
                CancelablePrintJob cancelablePrintJob = (CancelablePrintJob)docPrintJob;
                cancelablePrintJob.print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), this.getPrintRequestAttributeSet());
                return cancelablePrintJob;
            }
        }
        return null;
    }

    private void calculateTotalPagesToPrint() {
        PageRanges pageRanges = (PageRanges)this.getPrintRequestAttributeSet().get(PageRanges.class);
        this.setNumberOfPages(0);
        for (int[] nArray : pageRanges.getMembers()) {
            int n = nArray[0];
            int n2 = nArray[1];
            if (n < 1) {
                n = 1;
            }
            if (n2 > this.pageTree.getNumberOfPages()) {
                n2 = this.pageTree.getNumberOfPages();
            }
            this.setNumberOfPages(this.getNumberOfPages() + n2 - n + 1);
        }
    }

    @Override
    public void print(PrintJobWatcher printJobWatcher) throws PrintException {
        if (this.getPrintServiceOrDefault() != null) {
            this.calculateTotalPagesToPrint();
            DocPrintJob docPrintJob = this.getPrintServiceOrDefault().createPrintJob();
            printJobWatcher.setPrintJob(docPrintJob);
            docPrintJob.print(new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), this.getPrintRequestAttributeSet());
            printJobWatcher.waitForDone();
        } else {
            logger.fine("No print could be found to print to.");
        }
    }

    @Override
    protected PrintService getSetupDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.container);
        GraphicsConfiguration graphicsConfiguration = window == null ? null : window.getGraphicsConfiguration();
        int n = window != null ? window.getX() : this.container.getX();
        int n2 = window != null ? window.getY() : this.container.getY();
        return ServiceUI.printDialog(graphicsConfiguration, n + 50, n2 + 50, PrintHelperImpl.getServices(), this.getPrintServiceOrDefault(), DocFlavor.SERVICE_FORMATTED.PRINTABLE, this.getPrintRequestAttributeSet());
    }
}

