/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class ExImportPreferencesPanel
extends JPanel {
    private final GridBagConstraints constraints;

    public ExImportPreferencesPanel(Controller controller, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle, Dialog dialog) {
        super(new GridBagLayout());
        this.setAlignmentY(0.0f);
        JButton jButton = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport.export.button.label"));
        JButton jButton2 = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport.import.button.label"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport.border.label"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 10;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        jButton.addActionListener(actionEvent -> {
            FileDialog fileDialog = new FileDialog(dialog);
            fileDialog.setMultipleMode(false);
            fileDialog.setMode(1);
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            if (string != null && string2 != null) {
                if (ViewerPropertiesManager.exportProperties(new File(string + string2))) {
                    this.showSuccess(resourceBundle, "export");
                } else {
                    this.showFailure(resourceBundle, "export");
                }
            }
        });
        jButton2.addActionListener(actionEvent -> {
            FileDialog fileDialog = new FileDialog(dialog);
            fileDialog.setMultipleMode(false);
            fileDialog.setMode(0);
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            if (string != null && string2 != null) {
                if (ViewerPropertiesManager.importProperties(new File(string + string2))) {
                    this.showSuccess(resourceBundle, "import");
                } else {
                    this.showFailure(resourceBundle, "import");
                }
            }
        });
        this.addGB(jPanel, jButton, 0, 0, 1, 1);
        this.addGB(jPanel, jButton2, 1, 0, 1, 1);
        this.constraints.anchor = 18;
        this.constraints.fill = 1;
        this.addGB(this, jPanel, 0, 0, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new JLabel(" "), 0, 1, 1, 1);
    }

    private void showSuccess(ResourceBundle resourceBundle, String string) {
        JOptionPane.showMessageDialog(this, resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport." + string + ".success.label"), resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport." + string + ".success.title"), 1);
    }

    private void showFailure(ResourceBundle resourceBundle, String string) {
        JOptionPane.showMessageDialog(this, resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport." + string + ".fail.label"), resourceBundle.getString("viewer.dialog.viewerPreferences.section.eximport." + string + ".fail.title"), 0);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

