/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.widgets.ColorChooserButton;
import org.icepdf.ri.common.widgets.DragDropColorList;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationPreferencesPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private final GridBagConstraints constraints;
    private DragDropColorList dragDropColorList;
    private JButton addNamedColorButton;
    private JButton removeNamedColorButton;
    private JButton updateNamedColorButton;
    private ColorChooserButton colorButton;
    private JTextField colorLabelTextField;
    private final SwingController swingController;
    private final Preferences preferences;

    public AnnotationPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        this.swingController = swingController;
        this.preferences = viewerPropertiesManager.getPreferences();
        this.setLayout(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.named.border.label"), 1, 0));
        this.buildNamedColors(jPanel, resourceBundle);
        this.addPropertyChangeListener("annotationPropertyPanelChange", swingController);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.recent.border.label"), 1, 0));
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.recent.colors.label")), 0, 0, 1, 1);
        JButton jButton = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.recent.colors.button"));
        jButton.addActionListener(actionEvent -> {
            this.preferences.put("application.viewer.preference.annotation.color.recent", "");
            this.firePropertyChange("annotationPropertyPanelChange", null, (Object)true);
        });
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 1.0;
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.recent.colors.label")), 0, 0, 1, 1);
        this.addGB(jPanel2, jButton, 1, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.misc.border.label"), 1, 0));
        ToolItem[] toolItemArray = new ToolItem[]{new ToolItem(0, resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.misc.autoselect.none")), new ToolItem(6, resourceBundle.getString("viewer.toolbar.tool.select.tooltip")), new ToolItem(5, resourceBundle.getString("viewer.toolbar.tool.text.tooltip")), new ToolItem(1, resourceBundle.getString("viewer.toolbar.tool.pan.tooltip"))};
        JComboBox<ToolItem> jComboBox = new JComboBox<ToolItem>(toolItemArray);
        JLabel jLabel = new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.misc.autoselect.label"));
        int n = ViewerPropertiesManager.getInstance().getPreferences().getInt("application.annotation.ink.selection.type", 0);
        jComboBox.setSelectedItem(Arrays.stream(toolItemArray).filter(toolItem -> toolItem.toolIdx == n).findAny().orElse(toolItemArray[0]));
        jComboBox.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            ToolItem toolItem = (ToolItem)jComboBox.getItemAt(jComboBox.getSelectedIndex());
            ViewerPropertiesManager.ALL_SELECTION_PROPERTIES.forEach(string -> ViewerPropertiesManager.getInstance().getPreferences().putInt((String)string, toolItem.toolIdx));
        });
        this.addGB(jPanel3, jLabel, 0, 0, 1, 1);
        this.addGB(jPanel3, jComboBox, 1, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 11;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this, jPanel, 0, 0, 1, 1);
        this.addGB(this, jPanel2, 0, 1, 1, 1);
        this.addGB(this, jPanel3, 0, 2, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 3, 1, 1);
    }

    private void buildNamedColors(JPanel jPanel, ResourceBundle resourceBundle) {
        this.dragDropColorList = new DragDropColorList(this.swingController, this.preferences);
        JScrollPane jScrollPane = new JScrollPane(this.dragDropColorList);
        this.addGB(jPanel, jScrollPane, 0, 0, 5, 1);
        this.dragDropColorList.addListSelectionListener(this);
        this.addNamedColorButton = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.named.add.label"));
        this.addNamedColorButton.addActionListener(this);
        this.addNamedColorButton.setEnabled(true);
        this.removeNamedColorButton = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.named.remove.label"));
        this.removeNamedColorButton.addActionListener(this);
        this.removeNamedColorButton.setEnabled(false);
        this.updateNamedColorButton = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.annotations.named.edit.label"));
        this.updateNamedColorButton.addActionListener(this);
        this.updateNamedColorButton.setEnabled(false);
        this.colorButton = new ColorChooserButton(Color.DARK_GRAY);
        this.colorButton.setEnabled(true);
        this.colorLabelTextField = new JTextField("");
        this.colorLabelTextField.setEnabled(true);
        this.constraints.insets = new Insets(5, 5, 5, 1);
        this.constraints.fill = 0;
        this.constraints.weightx = 0.01;
        this.constraints.weighty = 1.0;
        this.addGB(jPanel, this.colorButton, 0, 1, 1, 1);
        this.constraints.insets = new Insets(5, 1, 5, 1);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 1;
        this.addGB(jPanel, this.colorLabelTextField, 1, 1, 1, 1);
        this.constraints.weightx = 0.01;
        this.constraints.fill = 0;
        this.addGB(jPanel, this.addNamedColorButton, 2, 1, 1, 1);
        this.addGB(jPanel, this.updateNamedColorButton, 3, 1, 1, 1);
        this.constraints.insets = new Insets(5, 0, 5, 5);
        this.addGB(jPanel, this.removeNamedColorButton, 4, 1, 1, 1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        DragDropColorList dragDropColorList = (DragDropColorList)listSelectionEvent.getSource();
        if (dragDropColorList.isSelectionEmpty()) {
            this.updateNamedColorButton.setEnabled(false);
            this.removeNamedColorButton.setEnabled(false);
            this.addNamedColorButton.setEnabled(true);
            this.colorButton.setEnabled(true);
            ColorChooserButton.setButtonBackgroundColor(Color.DARK_GRAY, this.colorButton);
            this.colorLabelTextField.setEnabled(true);
            this.colorLabelTextField.setText("");
        } else {
            this.addNamedColorButton.setEnabled(false);
            this.updateNamedColorButton.setEnabled(true);
            this.removeNamedColorButton.setEnabled(true);
            this.colorLabelTextField.setEnabled(true);
            this.colorButton.setEnabled(true);
            int n = dragDropColorList.getSelectedIndex();
            DragDropColorList.ColorLabel colorLabel = (DragDropColorList.ColorLabel)dragDropColorList.getModel().getElementAt(n);
            this.colorLabelTextField.setText(colorLabel.getLabel());
            ColorChooserButton.setButtonBackgroundColor(colorLabel.getColor(), this.colorButton);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addNamedColorButton) {
            this.dragDropColorList.addNamedColor(this.colorButton.getBackground(), this.colorLabelTextField.getText());
            this.colorLabelTextField.setText("");
        } else if (object == this.updateNamedColorButton) {
            this.dragDropColorList.updateNamedColor(this.colorButton.getBackground(), this.colorLabelTextField.getText());
            this.dragDropColorList.clearSelection();
        } else if (object == this.removeNamedColorButton) {
            this.dragDropColorList.removeSelectedNamedColor();
        }
        this.firePropertyChange("annotationPropertyPanelChange", null, (Object)true);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    private static class ToolItem {
        private final int toolIdx;
        private final String toolName;

        private ToolItem(int n, String string) {
            this.toolIdx = n;
            this.toolName = string;
        }

        public String toString() {
            return this.toolName;
        }
    }
}

