/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.EscapeJDialog;

public class MyGUISecurityCallback
implements SecurityCallback {
    private final Frame parentFrame;
    private final ResourceBundle messageBundle;

    public MyGUISecurityCallback(Frame frame, ResourceBundle resourceBundle) {
        this.parentFrame = frame;
        this.messageBundle = resourceBundle;
    }

    public String requestPassword(Document document) {
        PasswordDialog passwordDialog = new PasswordDialog(this.parentFrame);
        passwordDialog.setVisible(true);
        if (passwordDialog.isCanceled) {
            return null;
        }
        return passwordDialog.getPassword();
    }

    class PasswordDialog
    extends EscapeJDialog
    implements WindowListener {
        private final GridBagConstraints constraints;
        private final JPasswordField passwordField;
        private boolean isCanceled;

        public PasswordDialog(Frame frame) {
            super(frame, true);
            this.isCanceled = false;
            this.setTitle(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.title"));
            JButton jButton = new JButton(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.okButton.label"));
            jButton.setMnemonic(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.okButton.mnemonic").charAt(0));
            jButton.addActionListener(actionEvent -> {
                if (actionEvent.getSource() == jButton) {
                    this.setVisible(false);
                    this.dispose();
                }
            });
            JButton jButton2 = new JButton(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.cancelButton.label"));
            jButton2.setMnemonic(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.cancelButton.mnemonic").charAt(0));
            jButton2.addActionListener(actionEvent -> {
                if (actionEvent.getSource() == jButton2) {
                    this.setVisible(false);
                    this.isCanceled = true;
                    this.dispose();
                }
            });
            this.passwordField = new JPasswordField(30);
            this.passwordField.addActionListener(actionEvent -> {
                if (actionEvent.getSource() == this.passwordField) {
                    this.setVisible(false);
                    this.dispose();
                }
            });
            JLabel jLabel = new JLabel(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.msg"));
            JLabel jLabel2 = new JLabel(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.password.label"));
            JPanel jPanel = new JPanel();
            jPanel.setAlignmentY(0.0f);
            jPanel.setAlignmentX(0.5f);
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            this.getContentPane().add(jPanel);
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 0;
            this.constraints.weightx = 1.0;
            this.constraints.anchor = 17;
            this.constraints.insets = new Insets(1, 10, 1, 1);
            this.addGB(jPanel, jLabel, 0, 0, 3, 1);
            this.addGB(jPanel, jLabel2, 0, 1, 1, 1);
            this.constraints.fill = 2;
            this.constraints.insets = new Insets(1, 10, 1, 10);
            this.addGB(jPanel, this.passwordField, 1, 1, 2, 1);
            this.constraints.insets = new Insets(10, 1, 1, 1);
            this.constraints.fill = 0;
            this.addGB(jPanel, jButton, 1, 2, 1, 1);
            this.addGB(jPanel, jButton2, 2, 2, 1, 1);
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setResizable(false);
            this.setSize(306, 150);
            this.addWindowListener(this);
        }

        public String getPassword() {
            return new String(this.passwordField.getPassword());
        }

        public boolean isCancelled() {
            return this.isCanceled;
        }

        private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
            this.constraints.gridx = n;
            this.constraints.gridy = n2;
            this.constraints.gridwidth = n3;
            this.constraints.gridheight = n4;
            jPanel.add(component, this.constraints);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.setVisible(false);
            this.isCanceled = true;
            this.dispose();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

