/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.tools.DynamicZoomHandler;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.Controller;

public class MouseWheelListenerPageChanger
implements MouseWheelListener {
    private final Controller controller;
    private final JScrollPane scrollpane;
    private final AbstractDocumentView documentView;
    private boolean changingPage;

    public static Object install(Controller controller, JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView) {
        MouseWheelListenerPageChanger mouseWheelListenerPageChanger = null;
        if (controller != null && jScrollPane != null) {
            mouseWheelListenerPageChanger = new MouseWheelListenerPageChanger(controller, jScrollPane, abstractDocumentView);
            jScrollPane.addMouseWheelListener(mouseWheelListenerPageChanger);
        }
        return mouseWheelListenerPageChanger;
    }

    protected MouseWheelListenerPageChanger(Controller controller, JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView) {
        this.controller = controller;
        this.scrollpane = jScrollPane;
        this.documentView = abstractDocumentView;
        this.changingPage = false;
    }

    public static void uninstall(JScrollPane jScrollPane, Object object) {
        if (jScrollPane != null && object instanceof MouseWheelListenerPageChanger) {
            jScrollPane.removeMouseWheelListener((MouseWheelListenerPageChanger)object);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        JScrollBar jScrollBar;
        if (this.changingPage) {
            return;
        }
        int n2 = 0;
        JScrollBar jScrollBar2 = jScrollBar = this.scrollpane.getVerticalScrollBar() != null && this.scrollpane.getVerticalScrollBar().isVisible() ? this.scrollpane.getVerticalScrollBar() : null;
        if ((mouseWheelEvent.getModifiersEx() & 0x80) != 128 && !(this.documentView.getCurrentToolHandler() instanceof DynamicZoomHandler)) {
            n = mouseWheelEvent.getScrollAmount();
            int n3 = mouseWheelEvent.getWheelRotation();
            if (n > 0 && n3 > 0) {
                if (jScrollBar != null) {
                    int n4;
                    int n5;
                    int n6 = jScrollBar.getModel().getValue();
                    if (n6 + (n5 = jScrollBar.getModel().getExtent()) >= (n4 = jScrollBar.getModel().getMaximum())) {
                        n2 = this.documentView.getPreviousPageIncrement();
                    }
                } else {
                    n2 = this.documentView.getPreviousPageIncrement();
                }
            } else if (n > 0 && n3 < 0) {
                if (jScrollBar != null) {
                    int n7 = jScrollBar.getModel().getValue();
                    if (n7 <= 0) {
                        n2 = -this.documentView.getPreviousPageIncrement();
                    }
                } else {
                    n2 = -this.documentView.getPreviousPageIncrement();
                }
            }
        }
        if (n2 == 0) {
            return;
        }
        if (this.controller.getDocument() == null) {
            return;
        }
        this.changingPage = true;
        n = n2;
        SwingUtilities.invokeLater(() -> {
            this.changingPage = false;
            this.controller.goToDeltaPage(n);
        });
    }
}

