/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.Controller;

public class KeyListenerPageChanger
extends KeyAdapter {
    private final Controller controller;
    private final JScrollPane scroll;
    private final AbstractDocumentView documentView;
    private boolean changingPage;

    public static KeyListenerPageChanger install(Controller controller, JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView) {
        KeyListenerPageChanger keyListenerPageChanger = null;
        if (controller != null && jScrollPane != null) {
            keyListenerPageChanger = new KeyListenerPageChanger(controller, jScrollPane, abstractDocumentView);
            jScrollPane.addKeyListener(keyListenerPageChanger);
            abstractDocumentView.addKeyListener(keyListenerPageChanger);
        }
        return keyListenerPageChanger;
    }

    public void uninstall() {
        if (this.documentView != null) {
            this.documentView.removeKeyListener(this);
        }
        if (this.scroll != null) {
            this.scroll.removeKeyListener(this);
        }
    }

    protected KeyListenerPageChanger(Controller controller, JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView) {
        this.controller = controller;
        this.scroll = jScrollPane;
        this.documentView = abstractDocumentView;
        this.changingPage = false;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2;
        if (this.changingPage) {
            return;
        }
        int n3 = 0;
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar() != null && this.scroll.getVerticalScrollBar().isVisible() ? this.scroll.getVerticalScrollBar() : null;
        int n4 = keyEvent.getKeyCode();
        if (n4 == 34 || n4 == 40 || n4 == 32 || n4 == 10) {
            if (jScrollBar != null) {
                int n5;
                n2 = jScrollBar.getModel().getValue();
                if (n2 + (n = jScrollBar.getModel().getExtent()) >= (n5 = jScrollBar.getModel().getMaximum())) {
                    n3 = this.documentView.getNextPageIncrement();
                }
            } else {
                n3 = this.documentView.getNextPageIncrement();
            }
        } else if (n4 == 33 || n4 == 38) {
            if (jScrollBar != null) {
                n2 = jScrollBar.getModel().getValue();
                if (n2 <= 0) {
                    n3 = -this.documentView.getPreviousPageIncrement();
                }
            } else {
                n3 = -this.documentView.getPreviousPageIncrement();
            }
        } else if (n4 == 36) {
            n3 = -this.controller.getCurrentPageNumber();
        } else if (n4 == 35) {
            n3 = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (n3 == 0) {
            return;
        }
        n2 = this.controller.getCurrentPageNumber() + n3;
        if (this.controller.getDocument() == null) {
            return;
        }
        if (n2 < 0) {
            n3 = -this.controller.getCurrentPageNumber();
        }
        if (n2 >= this.controller.getDocument().getNumberOfPages()) {
            n3 = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (n3 == 0) {
            return;
        }
        this.changingPage = true;
        n = n3;
        SwingUtilities.invokeLater(() -> {
            this.changingPage = false;
            this.controller.goToDeltaPage(n);
        });
    }
}

