/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.awt.Toolkit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.WordText;

public class TextExtractionTask
extends SwingWorker<Void, StringBuilder> {
    private static final Logger logger = Logger.getLogger(TextExtractionTask.class.toString());
    private final int lengthOfTask;
    private int current;
    private final MessageFormat messageDialogFormat;
    private final MessageFormat messageTextFormat;
    private String dialogMessage;
    private final ResourceBundle messageBundle;
    private final Document document;
    private final File file;
    private final ProgressMonitor progressMonitor;
    private static final double[] fileLimits = new double[]{0.0, 1.0, 2.0};

    public TextExtractionTask(Document document, File file, ProgressMonitor progressMonitor, ResourceBundle resourceBundle) {
        this.document = document;
        this.file = file;
        this.lengthOfTask = document.getNumberOfPages();
        this.progressMonitor = progressMonitor;
        this.messageBundle = resourceBundle;
        this.messageDialogFormat = new MessageFormat(resourceBundle.getString("viewer.exportText.fileStamp.progress.msg"));
        String[] stringArray = new String[]{resourceBundle.getString("viewer.exportText.fileStamp.progress.moreFile.msg"), resourceBundle.getString("viewer.exportText.fileStamp.progress.oneFile.msg"), resourceBundle.getString("viewer.exportText.fileStamp.progress.moreFile.msg")};
        ChoiceFormat choiceFormat = new ChoiceFormat(fileLimits, stringArray);
        Format[] formatArray = new Format[]{null, choiceFormat, null};
        this.messageDialogFormat.setFormats(formatArray);
        this.messageTextFormat = new MessageFormat(resourceBundle.getString("viewer.exportText.pageStamp.msg"));
    }

    @Override
    protected void done() {
        this.progressMonitor.close();
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    protected void process(List<StringBuilder> list) {
        this.progressMonitor.setProgress(this.current);
        if (this.dialogMessage != null) {
            this.progressMonitor.setNote(this.dialogMessage);
        }
    }

    @Override
    protected Void doInBackground() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8));
            String string = this.messageBundle.getString("viewer.exportText.fileStamp.msg");
            bufferedWriter.write(string);
            bufferedWriter.write(10);
            for (int i = 0; i < this.document.getNumberOfPages() && !this.isCancelled(); ++i) {
                this.current = i;
                Object[] objectArray = new Object[]{String.valueOf(this.current + 1), this.lengthOfTask, this.lengthOfTask};
                this.dialogMessage = this.messageDialogFormat.format(objectArray);
                objectArray = new Object[]{String.valueOf(this.current + 1)};
                string = this.messageTextFormat.format(objectArray);
                bufferedWriter.write(string);
                bufferedWriter.write(10);
                Page page = this.document.getPageTree().getPage(i);
                ArrayList arrayList = page.isInitiated() ? this.document.getPageViewText(i).getPageLines() : this.document.getPageText(i).getPageLines();
                StringBuilder stringBuilder = null;
                for (LineText lineText : arrayList) {
                    stringBuilder = new StringBuilder();
                    for (WordText wordText : lineText.getWords()) {
                        stringBuilder.append(wordText.getText());
                    }
                    stringBuilder.append('\n');
                    bufferedWriter.write(stringBuilder.toString());
                }
                this.publish(stringBuilder);
            }
            this.current = 0;
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error extraction page text to file ", exception);
        }
        return null;
    }
}

