/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.images;

import java.net.URL;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.icepdf.ri.images.DefaultIconPack;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class Images {
    private static final Logger LOGGER = Logger.getLogger(Images.class.getName());
    private static final IconPack ICON_PACK;
    private static final IconPack.VariantPool AVAILABLE_VARIANTS;
    public static final String SIZE_LARGE = "_32";
    public static final String SIZE_SMALL = "_24";

    public static URL get(String string) {
        return Images.class.getResource(string);
    }

    public static IconSize getDefaultIconSizeOr(ViewerPropertiesManager viewerPropertiesManager, IconSize iconSize) {
        return Images.getDefaultIconSizeOr(viewerPropertiesManager.getPreferences(), iconSize);
    }

    public static IconSize getDefaultIconSizeOr(Preferences preferences, IconSize iconSize) {
        IconSize iconSize2;
        String string = preferences.get("application.icon.default.size", SIZE_LARGE);
        if (string == null || !string.equals(SIZE_SMALL) && !string.equals(SIZE_LARGE)) {
            try {
                iconSize2 = IconSize.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iconSize2 = iconSize;
            }
        } else {
            iconSize2 = string.equals(SIZE_SMALL) ? IconSize.SMALL : IconSize.LARGE;
        }
        return iconSize2;
    }

    public static void applyIcons(AbstractButton abstractButton, String string, IconSize iconSize) {
        Images.applyIcon(abstractButton::setIcon, string, IconPack.Variant.NORMAL, iconSize);
        if (AVAILABLE_VARIANTS.pressedProvided()) {
            Images.applyIcon(abstractButton::setPressedIcon, string, IconPack.Variant.PRESSED, iconSize);
        }
        if (AVAILABLE_VARIANTS.rolloverProvided()) {
            Images.applyIcon(abstractButton::setRolloverIcon, string, IconPack.Variant.ROLLOVER, iconSize);
        }
        if (AVAILABLE_VARIANTS.disabledProvided()) {
            Images.applyIcon(abstractButton::setDisabledIcon, string, IconPack.Variant.DISABLED, iconSize);
        }
    }

    public static void applyIcon(AbstractButton abstractButton, String string, IconPack.Variant variant, IconSize iconSize) {
        Images.applyIcon(abstractButton::setIcon, string, variant, iconSize);
    }

    public static Icon getSingleIcon(String string, IconPack.Variant variant, IconSize iconSize) throws RuntimeException {
        return ICON_PACK.getIcon(string, variant, iconSize);
    }

    private static void applyIcon(Consumer<Icon> consumer, String string, IconPack.Variant variant, IconSize iconSize) {
        try {
            consumer.accept(ICON_PACK.getIcon(string, variant, iconSize));
        }
        catch (RuntimeException runtimeException) {
            LOGGER.log(Level.WARNING, "Couldn't get icon " + string + ", size " + String.valueOf((Object)iconSize) + ", variant " + String.valueOf((Object)variant) + " from icon pack", runtimeException);
        }
    }

    static {
        Object object = UIManager.get("org.icepdf.ri.iconpack");
        if (!(object instanceof IconPack)) {
            LOGGER.fine("No user-defined icon pack was registered or registered one was invalid; using default icon pack");
            ICON_PACK = new DefaultIconPack();
        } else {
            ICON_PACK = (IconPack)object;
        }
        AVAILABLE_VARIANTS = ICON_PACK.getProvidedVariants();
    }

    public static enum IconSize {
        HUGE,
        LARGE,
        SMALL,
        MINI,
        TINY;

    }
}

