/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.AbstractColorButton;
import org.icepdf.ri.common.widgets.ColorChooserButton;
import org.icepdf.ri.common.widgets.ColorIcon;
import org.icepdf.ri.common.widgets.DragDropColorList;
import org.icepdf.ri.common.widgets.RgbColorChooser;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationColorPropertyPanel
extends JPanel
implements ActionListener {
    private final GridBagConstraints constraints;
    protected final Controller controller;
    protected final ResourceBundle messageBundle;
    private final JPanel recentColorsPanel;
    private final JPanel labeledColorPanel;
    protected final JButton colourPickerButton;
    protected final JButton preferencesButton;
    protected Color lastColor = Color.RED;
    protected AbstractColorButton annotationColorButton;

    public AnnotationColorPropertyPanel(Controller controller, ResourceBundle resourceBundle) {
        super(new GridBagLayout());
        this.controller = controller;
        this.messageBundle = resourceBundle;
        this.setAlignmentY(0.0f);
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.colourPickerButton = new JButton(resourceBundle.getString("viewer.popup.annotation.color.morecolors.label"));
        this.colourPickerButton.addActionListener(this);
        this.preferencesButton = new JButton(resourceBundle.getString("viewer.popup.annotation.color.preferences.label"));
        this.preferencesButton.addActionListener(this);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 2, 5, 5);
        this.constraints.anchor = 17;
        this.labeledColorPanel = new JPanel(new GridBagLayout());
        this.buildLabeledColour();
        this.addGB(this, this.labeledColorPanel, 0, 0, 10, 1);
        this.addGB(this, new JLabel(resourceBundle.getString("viewer.popup.annotation.color.standard.label")), 0, 1, 10, 1);
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.weightx = 0.0;
        this.constraints.fill = 0;
        this.addGB(this, new ColorButton(192, 0, 0), 0, 2, 1, 1);
        this.addGB(this, new ColorButton(255, 0, 0), 1, 2, 1, 1);
        this.addGB(this, new ColorButton(255, 192, 0), 2, 2, 1, 1);
        this.addGB(this, new ColorButton(255, 255, 0), 3, 2, 1, 1);
        this.addGB(this, new ColorButton(146, 208, 80), 4, 2, 1, 1);
        this.addGB(this, new ColorButton(0, 176, 80), 5, 2, 1, 1);
        this.addGB(this, new ColorButton(0, 176, 240), 6, 2, 1, 1);
        this.addGB(this, new ColorButton(0, 112, 192), 7, 2, 1, 1);
        this.addGB(this, new ColorButton(32, 76, 112), 8, 2, 1, 1);
        this.addGB(this, new ColorButton(112, 48, 160), 9, 2, 1, 1);
        this.recentColorsPanel = new JPanel(new GridBagLayout());
        this.buildRecentColours(null);
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.addGB(this, this.recentColorsPanel, 0, 3, 10, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.insets = new Insets(5, 2, 2, 2);
        this.addGB(this, this.colourPickerButton, 0, 4, 10, 1);
        this.constraints.insets = new Insets(0, 2, 2, 2);
        this.addGB(this, this.preferencesButton, 0, 5, 10, 1);
    }

    public void setCallback(AbstractColorButton abstractColorButton) {
        this.annotationColorButton = abstractColorButton;
    }

    public void refreshColorPanel() {
        this.buildLabeledColour();
        this.buildRecentColours(null);
    }

    public void buildRecentColours(Color color) {
        this.recentColorsPanel.removeAll();
        this.addGB(this.recentColorsPanel, new JLabel(this.messageBundle.getString("viewer.popup.annotation.color.lastused.label")), 0, 0, 10, 1);
        Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
        String string = preferences.get("application.viewer.preference.annotation.color.recent", null);
        ArrayList<Color> arrayList = new ArrayList<Color>(10);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(0, new Color(Integer.parseInt(stringTokenizer.nextToken())));
                }
            }
            catch (NumberFormatException numberFormatException) {
                preferences.put("application.viewer.preference.annotation.color.recent", "");
            }
        }
        if (color != null) {
            arrayList.remove(color);
        }
        if (color != null) {
            arrayList.add(0, color);
        }
        while (arrayList.size() > 10) {
            arrayList.remove(arrayList.size() - 1);
        }
        arrayList.trimToSize();
        if (arrayList.size() == 0) {
            this.recentColorsPanel.setVisible(false);
        } else {
            this.constraints.insets = new Insets(2, 2, 2, 2);
            this.constraints.weightx = 0.0;
            this.constraints.fill = 0;
            int n = 0;
            for (Color color2 : arrayList) {
                this.addGB(this.recentColorsPanel, new ColorButton(color2.getRGB()), n++, 1, 1, 1);
            }
            this.recentColorsPanel.setVisible(true);
        }
    }

    private void buildLabeledColour() {
        this.labeledColorPanel.removeAll();
        ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        if (arrayList.size() == 0) {
            this.labeledColorPanel.setVisible(false);
            return;
        }
        this.labeledColorPanel.setVisible(true);
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 1;
        this.addGB(this.labeledColorPanel, new JLabel(this.messageBundle.getString("viewer.popup.annotation.color.labels.label")), 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        int n = 1;
        for (DragDropColorList.ColorLabel colorLabel : arrayList) {
            Color color = colorLabel.getColor();
            this.constraints.weightx = 1.0;
            this.addGB(this.labeledColorPanel, new ColorMenuItem(colorLabel.getLabel(), color.getRed(), color.getGreen(), color.getBlue()), 0, n, 1, 1);
            ++n;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        Object object = actionEvent.getSource();
        if (object.equals(this.preferencesButton)) {
            this.controller.showViewerPreferences("application.preferences.show.annotations");
        } else if (object.equals(this.colourPickerButton) && (color = RgbColorChooser.showDialog(this, this.messageBundle.getString("viewer.popup.annotation.color.morecolors.label"), this.lastColor)) != null) {
            this.annotationColorButton.setColor(color, false);
            this.buildRecentColours(color);
            Preferences preferences = ViewerPropertiesManager.getInstance().getPreferences();
            Object object2 = preferences.get("application.viewer.preference.annotation.color.recent", null);
            object2 = object2 != null ? color.getRGB() + "|" + (String)object2 : String.valueOf(color.getRGB());
            preferences.put("application.viewer.preference.annotation.color.recent", (String)object2);
        }
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    private class ColorMenuItem
    extends JMenuItem {
        ColorMenuItem(String string, int n, int n2, int n3) {
            Color color = new Color(n, n2, n3);
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            abstractAction.putValue("SmallIcon", new ColorIcon(color));
            abstractAction.putValue("Name", string);
            this.setAction(abstractAction);
            this.addActionListener(actionEvent -> AnnotationColorPropertyPanel.this.annotationColorButton.setColor(this.getColorRGB(), true));
        }

        Color getColorRGB() {
            Object object = this.getAction().getValue("SmallIcon");
            if (object != null) {
                return ((ColorIcon)object).getColor();
            }
            return null;
        }
    }

    private class ColorButton
    extends JButton {
        ColorButton(int n, int n2, int n3) {
            ColorChooserButton.setButtonBackgroundColor(new Color(n, n2, n3), this);
            this.setPreferredSize(new Dimension(15, 15));
            this.setSize(15, 15);
            this.addActionListener(actionEvent -> AnnotationColorPropertyPanel.this.annotationColorButton.setColor(this.getBackground(), true));
        }

        ColorButton(int n) {
            ColorChooserButton.setButtonBackgroundColor(new Color(n), this);
            this.setPreferredSize(new Dimension(15, 15));
            this.setSize(15, 15);
            this.addActionListener(actionEvent -> {
                AnnotationColorPropertyPanel.this.buildRecentColours(this.getBackground());
                AnnotationColorPropertyPanel.this.annotationColorButton.setColor(this.getBackground(), true);
                AnnotationColorPropertyPanel.this.lastColor = this.getBackground();
            });
        }
    }
}

