/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.summary;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.summary.AnnotationSummaryPanel;
import org.icepdf.ri.images.Images;

public class AnnotationSummaryFrame
extends JFrame
implements MutableDocument {
    protected final Controller controller;
    protected final ResourceBundle messageBundle;
    protected AnnotationSummaryPanel annotationSummaryPanel;

    public AnnotationSummaryFrame(Controller controller) {
        this.controller = controller;
        this.messageBundle = controller.getMessageBundle();
        this.setIconImage(new ImageIcon(Images.get("icepdf-app-icon-64x64.png")).getImage());
        this.setTitle(this.messageBundle.getString("viewer.window.annotationSummary.title.default"));
    }

    @Override
    public void refreshDocumentInstance() {
        Document document = this.controller.getDocument();
        if (document != null) {
            String string = null;
            if (document.getInfo() != null) {
                string = document.getInfo().getTitle();
            }
            Object[] objectArray = new Object[]{string != null ? string : (this.controller.getViewerFrame() != null ? this.controller.getViewerFrame().getTitle() : "")};
            MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.window.annotationSummary.title.open.default"));
            this.setTitle(messageFormat.format(objectArray));
            this.annotationSummaryPanel = new AnnotationSummaryPanel(this, this.controller);
            this.getContentPane().add(this.annotationSummaryPanel);
            this.annotationSummaryPanel.refreshDocumentInstance();
        }
    }

    public AnnotationSummaryPanel getAnnotationSummaryPanel() {
        return this.annotationSummaryPanel;
    }

    @Override
    public void disposeDocument() {
        this.getContentPane().removeAll();
        this.invalidate();
        this.revalidate();
        this.repaint();
    }
}

