/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signing;

import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.icepdf.core.pobjects.acroform.signature.handlers.SignerHandler;
import org.icepdf.core.pobjects.acroform.signature.utils.SignatureUtilities;

public class CertificateTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private String[][] data = new String[0][];
    private ArrayList<X509Certificate> certs;
    private ArrayList<String> aliases;
    private static SimpleDateFormat validityDateFormat = new SimpleDateFormat("dd/MM/yyyy");

    public CertificateTableModel(SignerHandler signerHandler, Enumeration<String> enumeration, ResourceBundle resourceBundle) throws KeyStoreException {
        this.columnNames = new String[]{resourceBundle.getString("viewer.annotation.signature.creation.dialog.certificate.table.name.label"), resourceBundle.getString("viewer.annotation.signature.creation.dialog.certificate.table.author.label"), resourceBundle.getString("viewer.annotation.signature.creation.dialog.certificate.table.validity.label"), resourceBundle.getString("viewer.annotation.signature.creation.dialog.certificate.table.description.label")};
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.certs = new ArrayList();
        this.aliases = Collections.list(enumeration);
        for (String string : this.aliases) {
            X509Certificate x509Certificate = signerHandler.getCertificate(string);
            this.certs.add(x509Certificate);
            arrayList.add(CertificateTableModel.createCertSummaryData(x509Certificate));
        }
        this.data = new String[arrayList.size()][this.columnNames.length];
        arrayList.toArray((T[])this.data);
    }

    private static String[] createCertSummaryData(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Name x500Name = new X500Name(x500Principal.getName());
        if (x500Name.getRDNs() != null) {
            String string = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.CN);
            String string2 = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.EmailAddress);
            String string3 = validityDateFormat.format(x509Certificate.getNotAfter());
            String string4 = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.DESCRIPTION);
            return new String[]{string, string2, string3, string4};
        }
        throw new IllegalStateException("Certificate has no DRNs data");
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public String getAliasAt(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        return this.aliases.get(n);
    }

    public X509Certificate getCertificateAt(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        return this.certs.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

