/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signing;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.DictionaryEntries;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureAppearanceCallback;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureType;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.utils.ContentWriterUtils;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.PostScriptEncoder;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.pobjects.graphics.images.ImageStream;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SignatureManager;
import org.icepdf.ri.common.views.annotations.signing.SignatureAppearanceModelImpl;

public class BasicSignatureAppearanceCallback
implements SignatureAppearanceCallback<SignatureAppearanceModelImpl> {
    protected static final Logger logger = Logger.getLogger(BasicSignatureAppearanceCallback.class.toString());
    protected SignatureAppearanceModelImpl signatureAppearanceModel;

    public void setSignatureAppearanceModel(SignatureAppearanceModelImpl signatureAppearanceModelImpl) {
        this.signatureAppearanceModel = signatureAppearanceModelImpl;
    }

    public void removeAppearanceStream(SignatureWidgetAnnotation signatureWidgetAnnotation, AffineTransform affineTransform, boolean bl) {
        if (this.signatureAppearanceModel == null) {
            throw new IllegalStateException("SignatureAppearanceModel must be set before calling this method.");
        }
        Library library = signatureWidgetAnnotation.getLibrary();
        SignatureManager signatureManager = library.getSignatureDictionaries();
        signatureWidgetAnnotation.setSignatureDictionary(new SignatureDictionary(library, new DictionaryEntries()));
        signatureManager.clearSignatures();
        StateManager stateManager = library.getStateManager();
        stateManager.removeChange(new PObject(null, this.signatureAppearanceModel.getImageXObjectReference()));
        Name name = signatureWidgetAnnotation.getCurrentAppearance();
        HashMap hashMap = signatureWidgetAnnotation.getAppearances();
        Appearance appearance = (Appearance)hashMap.get(name);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Shapes shapes = ContentWriterUtils.createAppearanceShapes((AppearanceState)appearanceState, (int)0, (int)0);
        byte[] byArray = PostScriptEncoder.generatePostScript((ArrayList)shapes.getShapes());
        Rectangle2D rectangle2D = appearanceState.getBbox();
        AffineTransform affineTransform2 = appearanceState.getMatrix();
        Form form = signatureWidgetAnnotation.updateAppearanceStream(shapes, rectangle2D, affineTransform2, byArray, bl);
        form.getEntries().remove((Object)Form.RESOURCES_KEY);
    }

    public void createAppearanceStream(SignatureWidgetAnnotation signatureWidgetAnnotation, AffineTransform affineTransform, boolean bl) {
        String[] stringArray;
        if (this.signatureAppearanceModel == null) {
            throw new IllegalStateException("SignatureAppearanceModel must be set before calling this method.");
        }
        SignatureDictionary signatureDictionary = signatureWidgetAnnotation.getSignatureDictionary();
        Name name = signatureWidgetAnnotation.getCurrentAppearance();
        HashMap hashMap = signatureWidgetAnnotation.getAppearances();
        Appearance appearance = (Appearance)hashMap.get(name);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Shapes shapes = ContentWriterUtils.createAppearanceShapes((AppearanceState)appearanceState, (int)0, (int)0);
        if (!this.signatureAppearanceModel.isSignatureVisible() || !this.signatureAppearanceModel.isSelectedCertificate()) {
            return;
        }
        FontFile fontFile = ContentWriterUtils.createFont((String)this.signatureAppearanceModel.getFontName());
        fontFile = fontFile.deriveFont((float)this.signatureAppearanceModel.getFontSize());
        ResourceBundle resourceBundle = this.signatureAppearanceModel.getMessageBundle();
        Library library = signatureDictionary.getLibrary();
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.annotation.signature.handler.properties.reason.label"));
        String string = this.signatureAppearanceModel.getSignatureType() == SignatureType.CERTIFIER ? resourceBundle.getString("viewer.annotation.signature.handler.properties.reason.certification.label") : resourceBundle.getString("viewer.annotation.signature.handler.properties.reason.approval.label");
        String string2 = messageFormat.format(new Object[]{string});
        MessageFormat messageFormat2 = new MessageFormat(resourceBundle.getString("viewer.annotation.signature.handler.properties.contact.label"));
        String string3 = messageFormat2.format(new Object[]{this.signatureAppearanceModel.getContact()});
        MessageFormat messageFormat3 = new MessageFormat(resourceBundle.getString("viewer.annotation.signature.handler.properties.signer.label"));
        String string4 = messageFormat3.format(new Object[]{this.signatureAppearanceModel.getName()});
        MessageFormat messageFormat4 = new MessageFormat(resourceBundle.getString("viewer.annotation.signature.handler.properties.location.label"));
        String string5 = messageFormat4.format(new Object[]{this.signatureAppearanceModel.getLocation()});
        Rectangle2D rectangle2D = appearanceState.getBbox();
        BufferedImage bufferedImage = this.signatureAppearanceModel.getSignatureImage();
        Name name2 = this.signatureAppearanceModel.getImageXObjectName();
        Reference reference = this.signatureAppearanceModel.getImageXObjectReference();
        ImageStream imageStream = null;
        if (this.signatureAppearanceModel.isSignatureImageVisible() && bufferedImage != null) {
            imageStream = ContentWriterUtils.addImageToShapes((Library)library, (Name)name2, (Reference)reference, (BufferedImage)bufferedImage, (Shapes)shapes, (Rectangle2D)rectangle2D, (float)this.signatureAppearanceModel.getImageScale());
            this.signatureAppearanceModel.setImageXObjectReference(imageStream.getPObjectReference());
        }
        if (this.signatureAppearanceModel.isSignatureTextVisible()) {
            float f = 0.0f;
            int n = this.signatureAppearanceModel.getFontSize();
            int n2 = this.signatureAppearanceModel.getFontSize();
            stringArray = new String[]{string2, string3, string4, string5};
            int n3 = this.calculateLeftMargin(rectangle2D, stringArray);
            int n4 = 3;
            float f2 = this.calculateTextSpacing(rectangle2D, stringArray, n2, n4);
            AffineTransform affineTransform2 = this.calculatePaddingTransform(n3, n4);
            float f3 = (float)rectangle2D.getMinY() + f;
            shapes.add((DrawCmd)new TransformDrawCmd(affineTransform2));
            for (String string6 : stringArray) {
                Point2D.Float float_ = ContentWriterUtils.addTextSpritesToShapes((FontFile)fontFile, (float)0.0f, (float)f3, (Shapes)shapes, (int)n2, (float)n, (Color)this.signatureAppearanceModel.getFontColor(), (String)string6);
                f3 = float_.y + f2;
            }
        }
        StateManager stateManager = library.getStateManager();
        AffineTransform affineTransform3 = appearanceState.getMatrix();
        byte[] byArray = PostScriptEncoder.generatePostScript((ArrayList)shapes.getShapes());
        stringArray = signatureWidgetAnnotation.updateAppearanceStream(shapes, rectangle2D, affineTransform3, byArray, bl);
        stringArray.addFontResource(ContentWriterUtils.createDefaultFontDictionary((String)this.signatureAppearanceModel.getFontName()));
        if (this.signatureAppearanceModel.isSignatureImageVisible() && imageStream != null) {
            stringArray.addImageResource(name2, imageStream);
        }
        try {
            stringArray.init();
            appearanceState.setShapes(stringArray.getShapes());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        ContentWriterUtils.setAppearance((Annotation)signatureWidgetAnnotation, (Form)stringArray, (AppearanceState)appearanceState, (StateManager)stateManager, (boolean)bl);
    }

    private float calculateTextSpacing(Rectangle2D rectangle2D, String[] stringArray, int n, int n2) {
        float f = stringArray.length * n;
        float f2 = (float)rectangle2D.getHeight() - (float)(n2 * 2);
        if (f > f2) {
            return 0.0f;
        }
        return (f2 - f) / (float)(stringArray.length - 1);
    }

    private AffineTransform calculatePaddingTransform(int n, int n2) {
        return new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2);
    }

    private int calculateLeftMargin(Rectangle2D rectangle2D, String[] stringArray) {
        Font font = new Font(this.signatureAppearanceModel.getFontName(), 0, this.signatureAppearanceModel.getFontSize());
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        int n = 0;
        for (String string : stringArray) {
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            Rectangle2D rectangle2D2 = glyphVector.getOutline().getBounds2D();
            if (!(rectangle2D2.getWidth() > (double)n)) continue;
            n = (int)rectangle2D2.getWidth();
        }
        return (int)rectangle2D.getWidth() - n;
    }
}

