/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Names;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.search.DestinationResult;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.NameTreeNode;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationCellRender;
import org.icepdf.ri.common.utility.annotation.AnnotationTreeNode;
import org.icepdf.ri.common.utility.outline.OutlineItemTreeNode;
import org.icepdf.ri.common.utility.search.BaseRedactModel;
import org.icepdf.ri.common.utility.search.BaseSearchModel;
import org.icepdf.ri.common.utility.search.RedactSearchTask;
import org.icepdf.ri.common.utility.search.SearchFilterButton;
import org.icepdf.ri.common.utility.search.SearchTextTask;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.PageComponentSelector;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;

public class SearchPanel
extends JPanel
implements ActionListener,
MutableDocument,
TreeSelectionListener,
DocumentListener,
BaseSearchModel,
BaseRedactModel {
    private static final Logger logger = Logger.getLogger(SearchPanel.class.toString());
    private static final int maxPagesForLiveSearch = Defs.intProperty((String)"org.icepdf.ri.common.utility.search.maxPages.liveSearch", (int)50);
    public static final String HTML_TAG_START = "<html>";
    public static final String HTML_TAG_END = "</html>";
    public static final String BOLD_TAG_START = "<b>";
    public static final String BOLD_TAG_END = "</b>";
    private GridBagConstraints constraints;
    private JTextField searchTextField;
    private final Controller controller;
    private JTree tree;
    private DefaultMutableTreeNode rootTreeNode;
    private DefaultMutableTreeNode textTreeNode;
    private DefaultMutableTreeNode formsTreeNode;
    private DefaultMutableTreeNode commentsTreeNode;
    private DefaultMutableTreeNode outlinesTreeNode;
    private DefaultMutableTreeNode destinationsTreeNode;
    private DefaultTreeModel treeModel;
    private JButton searchButton;
    private JButton clearSearchButton;
    private JButton redactResultsButton;
    private SearchFilterButton searchFilterButton;
    private int lastTextNodePageIndex;
    private int lastCommentNodePageIndex;
    private JProgressBar progressBar;
    private SearchTextTask searchTextTask;
    private RedactSearchTask redactSearchTask;
    private JLabel findMessage;
    private final ResourceBundle messageBundle;
    private final MessageFormat searchResultMessageForm;

    public SearchPanel(SwingController swingController) {
        super(true);
        this.setFocusable(true);
        this.controller = swingController;
        this.messageBundle = this.controller.getMessageBundle();
        this.searchResultMessageForm = this.setupSearchResultMessageForm();
        this.setGui();
    }

    public String getSearchPhrase() {
        return this.searchTextField.getText();
    }

    public void setSearchPhrase(String string) {
        this.clearSearch();
        this.searchTextField.setText(string);
    }

    @Override
    public void refreshDocumentInstance() {
        this.stopSearch();
        Document document = this.controller.getDocument();
        if (document != null && this.progressBar != null) {
            this.progressBar.setMaximum(document.getNumberOfPages());
        }
        if (this.searchTextField != null) {
            this.searchTextField.setText("");
        }
        if (this.searchButton != null) {
            this.searchButton.setText(this.messageBundle.getString("viewer.utilityPane.search.tab.title"));
        }
        if (this.rootTreeNode != null) {
            this.resetTree();
            String string = this.getDocumentTitle();
            this.rootTreeNode.setUserObject(string);
            this.rootTreeNode.setAllowsChildren(true);
        }
        if (this.findMessage != null) {
            this.findMessage.setText("");
            this.findMessage.setVisible(false);
        }
        if (this.progressBar != null) {
            this.progressBar.setVisible(false);
        }
        if (this.searchTextField != null && this.searchTextField.getDocument() != null) {
            this.searchTextField.getDocument().removeDocumentListener(this);
            if (document != null && document.getNumberOfPages() < maxPagesForLiveSearch) {
                this.searchTextField.getDocument().addDocumentListener(this);
            }
        }
    }

    @Override
    public void disposeDocument() {
        this.searchTextTask = null;
    }

    private void setGui() {
        this.rootTreeNode = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.textTreeNode = new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.search.tree.text.title"), true);
        this.formsTreeNode = new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.search.tree.forms.title"), true);
        this.commentsTreeNode = new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.search.tree.markup.title"), true);
        this.outlinesTreeNode = new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.search.tree.outlines.title"), true);
        this.destinationsTreeNode = new DefaultMutableTreeNode(this.messageBundle.getString("viewer.utilityPane.search.tree.destinations.title"), true);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setScrollsOnExpand(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new AnnotationNodeSelectionListener());
        this.tree.setCellRenderer(new AnnotationCellRender());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setPreferredSize(new Dimension(150, 75));
        this.searchTextField = new JTextField("", 15);
        this.searchTextField.addActionListener(this);
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
        this.findMessage = new JLabel(this.messageBundle.getString("viewer.utilityPane.search.searching.msg"));
        this.findMessage.setVisible(false);
        this.searchButton = new JButton(this.messageBundle.getString("viewer.utilityPane.search.searchButton.label"));
        this.searchButton.addActionListener(this);
        this.clearSearchButton = new JButton(this.messageBundle.getString("viewer.utilityPane.search.clearSearchButton.label"));
        this.clearSearchButton.addActionListener(this);
        this.redactResultsButton = new JButton(this.messageBundle.getString("viewer.utilityPane.search.redactSearchResultsButton.label"));
        this.redactResultsButton.addActionListener(this);
        this.searchFilterButton = new SearchFilterButton(this, this.controller, "viewer.utilityPane.markupAnnotation.toolbar.filter.filterButton.tooltip");
        this.searchFilterButton.getShowPagesCheckbox().addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 1, 1, 5);
        JPanel jPanel = new JPanel(gridBagLayout);
        this.setLayout(new BorderLayout());
        this.add(jPanel);
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.addGB(jPanel, this.searchTextField, 0, 1, 1, 1);
        this.constraints.weightx = 0.0;
        this.constraints.fill = 2;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.searchFilterButton.setPreferredSize(new Dimension(this.searchFilterButton.getPreferredSize().width, this.searchButton.getPreferredSize().height));
        this.addGB(jPanel, this.searchFilterButton, 1, 1, 1, 1);
        this.addGB(jPanel, this.searchButton, 2, 1, 1, 1);
        this.constraints.fill = 0;
        this.addGB(jPanel, this.redactResultsButton, 0, 2, 1, 1);
        this.constraints.fill = 2;
        this.addGB(jPanel, this.clearSearchButton, 2, 2, 1, 1);
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.addGB(jPanel, jScrollPane, 0, 4, 3, 1);
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 13;
        this.findMessage.setAlignmentX(1.0f);
        this.addGB(jPanel, this.findMessage, 0, 5, 3, 1);
        this.constraints.insets = new Insets(5, 5, 1, 5);
        this.constraints.fill = 2;
        this.addGB(jPanel, this.progressBar, 0, 6, 3, 1);
        this.insertSectionNodes();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.isShowing()) {
            this.searchTextField.requestFocus(true);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.searchTextField.requestFocus();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.tree.getLastSelectedPathComponent() != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof FindEntry) {
                FindEntry findEntry = (FindEntry)defaultMutableTreeNode.getUserObject();
                if (this.controller != null) {
                    try {
                        int n = findEntry.getPageNumber();
                        WordText wordText = findEntry.getWordText();
                        this.controller.getDocumentSearchController().showWord(n, wordText);
                        PageText pageText = this.controller.getDocument().getPageViewText(n);
                        pageText.clearHighlightedCursor();
                        this.controller.getDocumentSearchController().setCurrentPage(n);
                        if (wordText != null && (wordText = pageText.find(wordText)) != null) {
                            wordText.setHasHighlightCursor(true);
                            wordText.setHighlightCursor(true);
                            DocumentSearchController documentSearchController = this.controller.getDocumentSearchController();
                            documentSearchController.setCurrentSearchHit(n, wordText);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        logger.finer("Page text retrieval interrupted.");
                    }
                }
            } else if (defaultMutableTreeNode instanceof AnnotationTreeNode) {
                AnnotationTreeNode annotationTreeNode = (AnnotationTreeNode)defaultMutableTreeNode;
                Annotation annotation = annotationTreeNode.getAnnotation();
                PageComponentSelector.SelectAnnotationComponent(this.controller, annotation, false);
            } else if (defaultMutableTreeNode instanceof OutlineItemTreeNode) {
                this.controller.followOutlineItem((OutlineItemTreeNode)defaultMutableTreeNode);
            } else if (defaultMutableTreeNode instanceof NameTreeNode) {
                this.controller.followDestinationItem((NameTreeNode)defaultMutableTreeNode);
            }
        }
    }

    @Override
    public void addFoundTextEntry(SearchTextTask.TextResult textResult, SearchTextTask searchTextTask) {
        String string = textResult.getNodeText();
        int n = textResult.getCurrentPage();
        List<LineText> list = textResult.getLineItems();
        if (list != null && !list.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            if (searchTextTask.isShowPages() && this.lastTextNodePageIndex != n) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(new FindEntry(string, n, null), true);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.textTreeNode, this.textTreeNode.getChildCount());
            } else {
                defaultMutableTreeNode = this.textTreeNode;
            }
            for (LineText lineText : list) {
                this.addObject(defaultMutableTreeNode, new DefaultMutableTreeNode(new FindEntry(SearchPanel.generateResultPreview(lineText.getWords()), n, lineText.getWords()), false), false);
            }
            if (this.lastTextNodePageIndex == -1) {
                this.tree.expandPath(new TreePath(this.textTreeNode.getPath()));
            }
            this.lastTextNodePageIndex = n;
        }
    }

    @Override
    public void addFoundFormsEntry(SearchTextTask.FormsResult formsResult, SearchTextTask searchTextTask) {
        String string = formsResult.getNodeText();
        int n = formsResult.getCurrentPage();
        List<TextWidgetAnnotation> list = formsResult.getWidgets();
        if (list != null && !list.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            if (searchTextTask.isShowPages() && this.lastTextNodePageIndex != n) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(new FindEntry(string, n, null), true);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.formsTreeNode, this.formsTreeNode.getChildCount());
            } else {
                defaultMutableTreeNode = this.formsTreeNode;
            }
            for (TextWidgetAnnotation textWidgetAnnotation : list) {
                AnnotationTreeNode annotationTreeNode = new AnnotationTreeNode((Annotation)textWidgetAnnotation, this.messageBundle, searchTextTask.getSearchPattern(), searchTextTask.isCaseSensitive());
                this.treeModel.insertNodeInto(annotationTreeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            if (this.lastTextNodePageIndex == -1) {
                this.tree.expandPath(new TreePath(this.formsTreeNode.getPath()));
            }
            this.lastTextNodePageIndex = n;
        }
    }

    @Override
    public void addFoundCommentEntry(SearchTextTask.CommentsResult commentsResult, SearchTextTask searchTextTask) {
        if (commentsResult != null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            int n = commentsResult.getCurrentPage();
            if (searchTextTask.isShowPages() && this.lastCommentNodePageIndex != n) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(new FindEntry(commentsResult.getNodeText(), n, null), true);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.commentsTreeNode, this.commentsTreeNode.getChildCount());
            } else {
                defaultMutableTreeNode = this.commentsTreeNode;
            }
            List<MarkupAnnotation> list = commentsResult.getMarkupAnnotations();
            for (MarkupAnnotation markupAnnotation : list) {
                AnnotationTreeNode annotationTreeNode = new AnnotationTreeNode((Annotation)markupAnnotation, this.messageBundle, searchTextTask.getSearchPattern(), searchTextTask.isCaseSensitive());
                this.treeModel.insertNodeInto(annotationTreeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            if (this.lastCommentNodePageIndex == -1) {
                this.tree.expandPath(new TreePath(this.commentsTreeNode.getPath()));
            }
            this.lastCommentNodePageIndex = n;
        }
    }

    @Override
    public void addFoundOutlineEntry(SearchTextTask.OutlineResult outlineResult, SearchTextTask searchTextTask) {
        List<OutlineItem> list = outlineResult.getOutlinesMatches();
        for (OutlineItem outlineItem : list) {
            OutlineItemTreeNode outlineItemTreeNode = new OutlineItemTreeNode(outlineItem, searchTextTask.getSearchPattern(), searchTextTask.isCaseSensitive());
            this.treeModel.insertNodeInto(outlineItemTreeNode, this.outlinesTreeNode, this.outlinesTreeNode.getChildCount());
        }
        this.tree.expandPath(new TreePath(this.outlinesTreeNode.getPath()));
    }

    @Override
    public void addFoundDestinationEntry(SearchTextTask.DestinationsResult destinationsResult, SearchTextTask searchTextTask) {
        List<DestinationResult> list = destinationsResult.getDestinationsResult();
        for (DestinationResult destinationResult : list) {
            NameTreeNode nameTreeNode = new NameTreeNode((StringObject)new LiteralStringObject(destinationResult.getName()), destinationResult.getValue(), searchTextTask.getSearchPattern(), searchTextTask.isCaseSensitive());
            this.treeModel.insertNodeInto(nameTreeNode, this.destinationsTreeNode, this.destinationsTreeNode.getChildCount());
        }
        this.tree.expandPath(new TreePath(this.destinationsTreeNode.getPath()));
    }

    private void addObject(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, boolean bl) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootTreeNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    private static String generateResultPreview(List<WordText> list) {
        StringBuilder stringBuilder = new StringBuilder(HTML_TAG_START);
        for (WordText wordText : list) {
            if (wordText.isHighlighted()) {
                stringBuilder.append(" ");
                stringBuilder.append(BOLD_TAG_START);
                stringBuilder.append(wordText.getText());
                stringBuilder.append(BOLD_TAG_END);
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(wordText.getText());
        }
        stringBuilder.append(HTML_TAG_END);
        return stringBuilder.toString();
    }

    private void resetTree() {
        this.tree.setSelectionPath(null);
        this.lastCommentNodePageIndex = -1;
        this.lastTextNodePageIndex = -1;
        this.textTreeNode.removeAllChildren();
        this.formsTreeNode.removeAllChildren();
        this.commentsTreeNode.removeAllChildren();
        this.outlinesTreeNode.removeAllChildren();
        this.destinationsTreeNode.removeAllChildren();
        this.rootTreeNode.removeAllChildren();
        this.insertSectionNodes();
        this.treeModel.nodeStructureChanged(this.rootTreeNode);
    }

    private void insertSectionNodes() {
        if (this.searchFilterButton.isText()) {
            this.rootTreeNode.insert(this.textTreeNode, this.rootTreeNode.getChildCount());
        }
        if (this.searchFilterButton.isForms()) {
            this.rootTreeNode.insert(this.formsTreeNode, this.rootTreeNode.getChildCount());
        }
        if (this.searchFilterButton.isComments()) {
            this.rootTreeNode.insert(this.commentsTreeNode, this.rootTreeNode.getChildCount());
        }
        if (this.searchFilterButton.isOutlines()) {
            this.rootTreeNode.insert(this.outlinesTreeNode, this.rootTreeNode.getChildCount());
        }
        if (this.searchFilterButton.isDestinations()) {
            this.rootTreeNode.insert(this.destinationsTreeNode, this.rootTreeNode.getChildCount());
        }
    }

    private String getDocumentTitle() {
        String string = null;
        Document document = this.controller.getDocument();
        if (document != null && document.getInfo() != null) {
            string = document.getInfo().getTitle();
        }
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        return string;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.stopSearch();
        this.resetTree();
        this.startSearch();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.stopSearch();
        this.resetTree();
        this.startSearch();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.stopSearch();
        this.resetTree();
        this.startSearch();
    }

    @Override
    public void notifySearchFiltersChanged() {
    }

    private void stopSearch() {
        if (this.searchTextTask != null) {
            this.searchTextTask.cancel(true);
        }
        this.searchFilterButton.setEnabled(true);
    }

    private void startSearch() {
        if (this.searchTextTask != null && !this.searchTextTask.isDone()) {
            this.searchTextTask.cancel(true);
            return;
        }
        this.findMessage.setVisible(true);
        this.progressBar.setVisible(true);
        this.resetTree();
        this.controller.getDocumentSearchController().clearAllSearchHighlight();
        this.controller.getDocumentViewController().getViewContainer().repaint();
        if (this.searchFilterButton.isRegex()) {
            try {
                Pattern.compile(this.searchTextField.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logger.warning("Error processing search pattern syntax");
                this.findMessage.setText(patternSyntaxException.getMessage());
                return;
            }
        }
        this.searchTextTask = this.searchFilterButton.getSearchTask(this, this.controller, this.searchTextField.getText());
        this.searchButton.setText(this.messageBundle.getString("viewer.utilityPane.search.stopButton.label"));
        this.searchFilterButton.setEnabled(false);
        this.redactResultsButton.setEnabled(false);
        this.searchTextTask.execute();
    }

    private void clearSearch() {
        this.stopSearch();
        this.searchTextField.setText("");
        this.resetTree();
        this.controller.getDocumentSearchController().clearAllSearchHighlight();
        this.controller.getDocumentViewController().getViewContainer().repaint();
    }

    private void redactSearchResults() {
        this.findMessage.setVisible(true);
        this.progressBar.setVisible(true);
        this.redactSearchTask = new RedactSearchTask(this.controller, this);
        this.redactResultsButton.setText(this.messageBundle.getString("viewer.utilityPane.search.stopButton.label"));
        this.searchButton.setEnabled(false);
        this.searchFilterButton.setEnabled(false);
        this.redactSearchTask.execute();
    }

    private void showAllNodePages() {
        this.showNodePages(this.textTreeNode);
        this.showNodePages(this.formsTreeNode);
        this.showNodePages(this.commentsTreeNode);
    }

    private void showNodePages(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            int n = -1;
            int n2 = 0;
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                Object[] objectArray;
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                if (!(defaultMutableTreeNode3.getUserObject() instanceof FindEntry) && !(defaultMutableTreeNode3 instanceof AnnotationTreeNode)) continue;
                int n3 = defaultMutableTreeNode3.getUserObject() instanceof FindEntry ? ((FindEntry)defaultMutableTreeNode3.getUserObject()).getPageNumber() : ((AnnotationTreeNode)defaultMutableTreeNode3).getAnnotation().getPageIndex();
                if (n == n3) {
                    ++n2;
                    if (defaultMutableTreeNode2 == null) continue;
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode3);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    defaultMutableTreeNode3.setParent(defaultMutableTreeNode2);
                    --i;
                    continue;
                }
                if (defaultMutableTreeNode2 != null) {
                    objectArray = new Object[]{String.valueOf(n + 1), n2, n2};
                    defaultMutableTreeNode2.setUserObject(new FindEntry(this.searchResultMessageForm.format(objectArray), n, null));
                }
                n = n3;
                n2 = 1;
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode3);
                objectArray = new Object[]{String.valueOf(n + 1), n2, n2};
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new FindEntry(this.searchResultMessageForm.format(objectArray), n, null), true);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                defaultMutableTreeNode3.setParent(defaultMutableTreeNode2);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, i);
            }
        }
    }

    private void hideAllNodePages() {
        this.hideNodePages(this.textTreeNode);
        this.hideNodePages(this.formsTreeNode);
        this.hideNodePages(this.commentsTreeNode);
    }

    private void hideNodePages(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.getChildCount() > 0) {
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                if (defaultMutableTreeNode2.getChildCount() > 0) {
                    int n2 = defaultMutableTreeNode2.getChildCount();
                    for (int j = 0; j < n2; ++j) {
                        this.treeModel.insertNodeInto((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    }
                }
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.searchTextField || object == this.searchButton) {
            this.startSearch();
        } else if (object == this.redactResultsButton) {
            this.redactSearchResults();
        } else if (object == this.clearSearchButton) {
            this.clearSearch();
        } else if (object == this.searchFilterButton.getShowPagesCheckbox() && actionEvent.getSource() != null) {
            if (this.searchFilterButton.isShowPages()) {
                this.showAllNodePages();
            } else {
                this.hideAllNodePages();
            }
        }
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    @Override
    public MessageFormat setupSearchResultMessageForm() {
        MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.search.result.msg"));
        ChoiceFormat choiceFormat = this.getResultsChoiceFormat();
        Format[] formatArray = new Format[]{null, choiceFormat};
        messageFormat.setFormats(formatArray);
        return messageFormat;
    }

    @Override
    public MessageFormat setupSearchingMessageForm() {
        MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.search.searching1.msg"));
        ChoiceFormat choiceFormat = this.getProgressPageChoiceFormat();
        Format[] formatArray = new Format[]{null, choiceFormat, null};
        messageFormat.setFormats(formatArray);
        return messageFormat;
    }

    @Override
    public MessageFormat setupSearchCompletionMessageForm() {
        MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.search.progress.msg"));
        ChoiceFormat choiceFormat = this.getProgressPagesChoiceFormat();
        ChoiceFormat choiceFormat2 = this.getProgressMatchChoiceFormat();
        Format[] formatArray = new Format[]{null, choiceFormat, choiceFormat2};
        messageFormat.setFormats(formatArray);
        return messageFormat;
    }

    @Override
    public MessageFormat setupRedactingMessageForm() {
        MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.redact.searching1.msg"));
        ChoiceFormat choiceFormat = this.getProgressPageChoiceFormat();
        Format[] formatArray = new Format[]{null, choiceFormat, null};
        messageFormat.setFormats(formatArray);
        return messageFormat;
    }

    @Override
    public MessageFormat setupRedactCompletionMessageForm() {
        MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.redact.progress.msg"));
        ChoiceFormat choiceFormat = this.getProgressPagesChoiceFormat();
        ChoiceFormat choiceFormat2 = this.getProgressMatchChoiceFormat();
        Format[] formatArray = new Format[]{null, choiceFormat, choiceFormat2};
        messageFormat.setFormats(formatArray);
        return messageFormat;
    }

    private ChoiceFormat getProgressPagesChoiceFormat() {
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        String[] stringArray = new String[]{this.messageBundle.getString("viewer.utilityPane.search.progress.morePage.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.onePage.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.morePage.msg")};
        return new ChoiceFormat(dArray, stringArray);
    }

    private ChoiceFormat getProgressMatchChoiceFormat() {
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        String[] stringArray = new String[]{this.messageBundle.getString("viewer.utilityPane.search.progress.moreMatch.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.oneMatch.msg"), this.messageBundle.getString("viewer.utilityPane.search.progress.moreMatch.msg")};
        return new ChoiceFormat(dArray, stringArray);
    }

    private ChoiceFormat getProgressPageChoiceFormat() {
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        String[] stringArray = new String[]{this.messageBundle.getString("viewer.utilityPane.search.searching1.moreFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.searching1.oneFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.searching1.moreFile.msg")};
        return new ChoiceFormat(dArray, stringArray);
    }

    private ChoiceFormat getResultsChoiceFormat() {
        double[] dArray = new double[]{0.0, 1.0, 2.0};
        String[] stringArray = new String[]{this.messageBundle.getString("viewer.utilityPane.search.result.moreFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.result.oneFile.msg"), this.messageBundle.getString("viewer.utilityPane.search.result.moreFile.msg")};
        return new ChoiceFormat(dArray, stringArray);
    }

    @Override
    public void updateProgressControls(String string) {
        this.progressBar.setValue(this.searchTextTask.getCurrent());
        if (string != null) {
            this.findMessage.setText(string);
        }
        if (this.searchTextTask != null && (this.searchTextTask.isDone() || this.searchTextTask.isCancelled())) {
            this.findMessage.setText(string);
            this.searchButton.setText(this.messageBundle.getString("viewer.utilityPane.search.searchButton.label"));
            this.searchFilterButton.setEnabled(true);
            this.redactResultsButton.setEnabled(true);
            this.progressBar.setValue(this.progressBar.getMinimum());
            this.progressBar.setVisible(false);
        }
        if (this.redactSearchTask != null && (this.redactSearchTask.isDone() || this.redactSearchTask.isCancelled())) {
            this.findMessage.setText(string);
            this.redactResultsButton.setText(this.messageBundle.getString("viewer.utilityPane.search.redactSearchResultsButton.label"));
            this.searchFilterButton.setEnabled(true);
            this.searchButton.setEnabled(true);
            this.progressBar.setValue(this.progressBar.getMinimum());
            this.progressBar.setVisible(false);
        }
    }

    private class AnnotationNodeSelectionListener
    extends MouseAdapter {
        private AnnotationNodeSelectionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block5: {
                Object object;
                block7: {
                    block6: {
                        int n;
                        int n2 = mouseEvent.getX();
                        int n3 = SearchPanel.this.tree.getRowForLocation(n2, n = mouseEvent.getY());
                        TreePath treePath = SearchPanel.this.tree.getPathForRow(n3);
                        if (treePath == null) break block5;
                        object = treePath.getLastPathComponent();
                        if (!(object instanceof AnnotationTreeNode)) break block6;
                        AnnotationTreeNode annotationTreeNode = (AnnotationTreeNode)object;
                        Annotation annotation = annotationTreeNode.getAnnotation();
                        AnnotationComponent annotationComponent = PageComponentSelector.SelectAnnotationComponent(SearchPanel.this.controller, annotation, false);
                        if (!(annotationComponent instanceof MarkupAnnotationComponent) || mouseEvent.getButton() != 1) break block5;
                        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)annotationComponent;
                        if (mouseEvent.getClickCount() == 2) {
                            markupAnnotationComponent.requestFocus();
                        }
                        break block5;
                    }
                    if (!(object instanceof OutlineItemTreeNode)) break block7;
                    if (mouseEvent.getClickCount() != 2) break block5;
                    SwingController swingController = (SwingController)SearchPanel.this.controller;
                    JTree jTree = swingController.getOutlineTree();
                    OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)jTree.getModel().getRoot();
                    int n = outlineItemTreeNode.getChildCount();
                    for (int i = 0; i < n; ++i) {
                        OutlineItemTreeNode outlineItemTreeNode2 = this.findOutlineTreeNode(outlineItemTreeNode.getChildAt(i), (OutlineItemTreeNode)object);
                        if (outlineItemTreeNode2 == null) continue;
                        swingController.showOutlinePanel(true);
                        TreePath treePath = new TreePath(outlineItemTreeNode2.getPath());
                        jTree.setSelectionPath(treePath);
                        jTree.scrollPathToVisible(treePath);
                        break block5;
                    }
                    break block5;
                }
                if (object instanceof NameTreeNode && mouseEvent.getClickCount() == 2) {
                    SwingController swingController = (SwingController)SearchPanel.this.controller;
                    Names names = SearchPanel.this.controller.getDocument().getCatalog().getNames();
                    if (names != null && names.getDestsNameTree() != null) {
                        NameTree nameTree = names.getDestsNameTree();
                        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new NameTreeNode(nameTree.getRoot(), SearchPanel.this.messageBundle));
                        NameTreeNode nameTreeNode = (NameTreeNode)object;
                        Enumeration<TreeNode> enumeration = ((NameTreeNode)defaultTreeModel.getRoot()).depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            NameTreeNode nameTreeNode2 = (NameTreeNode)enumeration.nextElement();
                            if (nameTreeNode2.getName() == null || nameTreeNode2.getName().toString().compareToIgnoreCase(nameTreeNode.getName().toString()) != 0) continue;
                            swingController.showAnnotationDestinationPanel(new TreePath(nameTreeNode2.getPath()));
                        }
                    }
                }
            }
        }

        private OutlineItemTreeNode findOutlineTreeNode(TreeNode treeNode, OutlineItemTreeNode outlineItemTreeNode) {
            OutlineItemTreeNode outlineItemTreeNode2 = (OutlineItemTreeNode)treeNode;
            OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
            if (outlineItem.equals((Object)outlineItemTreeNode2.getOutlineItem())) {
                return (OutlineItemTreeNode)treeNode;
            }
            int n = outlineItemTreeNode2.getChildCount();
            for (int i = 0; i < n; ++i) {
                OutlineItemTreeNode outlineItemTreeNode3;
                OutlineItemTreeNode outlineItemTreeNode4 = (OutlineItemTreeNode)outlineItemTreeNode2.getChildAt(i);
                if (outlineItem.equals((Object)outlineItemTreeNode4.getOutlineItem())) {
                    return outlineItemTreeNode4;
                }
                if (outlineItemTreeNode4.getChildCount() <= 0 || (outlineItemTreeNode3 = this.findOutlineTreeNode(outlineItemTreeNode4, outlineItemTreeNode)) == null) continue;
                return outlineItemTreeNode3;
            }
            return null;
        }
    }

    static class FindEntry
    extends DefaultMutableTreeNode {
        final String title;
        final int pageNumber;
        WordText wordText;

        FindEntry(String string, int n, List<WordText> list) {
            this.pageNumber = n;
            this.title = string;
            this.setUserObject(string);
            if (list != null) {
                for (WordText wordText : list) {
                    if (!wordText.isHighlighted()) continue;
                    this.wordText = wordText;
                    break;
                }
            }
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        WordText getWordText() {
            return this.wordText;
        }
    }
}

