/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.outline;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Names;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.NameJTree;
import org.icepdf.ri.common.NameTreeNode;
import org.icepdf.ri.common.utility.annotation.destinations.ImplicitDestinationPanel;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.utility.outline.OutlineItemTreeNode;
import org.icepdf.ri.common.views.Controller;

public class OutlineDialog
extends EscapeJDialog
implements ItemListener,
TreeSelectionListener,
ActionListener,
FocusListener {
    private final ResourceBundle messageBundle;
    private static final String IMPLICIT_DESTINATION = "Implicit Destination";
    private static final int IMPLICIT_DESTINATION_INDEX = 0;
    private static final String NAMED_DESTINATION = "Named Destination";
    private static final int NAMED_DESTINATION_INDEX = 1;
    private final Controller controller;
    private final boolean isNewOutlineItem;
    private final OutlineItemTreeNode outlineItemTreeNode;
    private final JTree parentTree;
    private Destination outlineDestination;
    private String title;
    private JTextField titleTextField;
    private JComboBox<ValueLabelItem> destinationTypeComboBox;
    private JPanel destinationTypesCards;
    private ImplicitDestinationPanel implicitDestinationPanel;
    private JButton okButton;
    private JButton cancelButton;
    private GridBagConstraints constraints;

    public OutlineDialog(Controller controller, JTree jTree, OutlineItemTreeNode outlineItemTreeNode) {
        this(controller, jTree, outlineItemTreeNode, false);
    }

    public OutlineDialog(Controller controller, JTree jTree, OutlineItemTreeNode outlineItemTreeNode, boolean bl) throws HeadlessException {
        super(controller.getViewerFrame());
        this.controller = controller;
        this.parentTree = jTree;
        this.isNewOutlineItem = bl;
        this.outlineItemTreeNode = outlineItemTreeNode;
        this.messageBundle = this.controller.getMessageBundle();
        Destination destination = outlineItemTreeNode.getOutlineItem().getDest();
        if (destination != null) {
            this.outlineDestination = new Destination(destination.getLibrary(), destination.getEntries().clone());
        } else {
            this.outlineDestination = new Destination(controller.getDocument().getCatalog().getLibrary(), (Object)"");
            outlineItemTreeNode.getOutlineItem().setDest(this.outlineDestination);
        }
        this.title = outlineItemTreeNode.getOutlineItem().getTitle();
        this.buildGui();
        this.implicitDestinationPanel.setDestination(outlineItemTreeNode.getOutlineItem().getDest());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            Object object;
            if (this.destinationTypeComboBox.getSelectedIndex() == 1) {
                this.outlineItemTreeNode.getOutlineItem().setDest(this.outlineDestination);
            } else {
                object = this.implicitDestinationPanel.getDestination(this.outlineDestination.getLibrary());
                object.clearNamedDestination();
                this.outlineItemTreeNode.getOutlineItem().setDest((Destination)object);
            }
            this.outlineItemTreeNode.getOutlineItem().setTitle(this.title);
            this.outlineItemTreeNode.setUserObject(this.title);
            if (this.isNewOutlineItem) {
                object = this.controller.getDocument().getCatalog().getLibrary();
                OutlineItem outlineItem = this.outlineItemTreeNode.getOutlineItem();
                object.getStateManager().addChange(new PObject((Object)outlineItem, outlineItem.getPObjectReference()));
            }
            object = (DefaultTreeModel)this.parentTree.getModel();
            ((DefaultTreeModel)object).nodeChanged(this.outlineItemTreeNode);
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.outlineDestination = null;
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.titleTextField) {
            this.title = this.titleTextField.getText();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.titleTextField) {
            this.title = this.titleTextField.getText();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        NameJTree nameJTree = (NameJTree)treeSelectionEvent.getSource();
        TreePath treePath = nameJTree.getSelectionPath();
        if (treePath != null) {
            NameTreeNode nameTreeNode = (NameTreeNode)treePath.getLastPathComponent();
            this.outlineDestination.setNamedDestination(nameTreeNode.getName());
            this.implicitDestinationPanel.setDestination(this.outlineDestination);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this.destinationTypesCards.getLayout();
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        cardLayout.show(this.destinationTypesCards, valueLabelItem.getValue().toString());
    }

    private void buildGui() {
        this.setLayout(new GridBagLayout());
        this.setTitle(this.messageBundle.getString("viewer.utilityPane.outline.edit.title"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 12;
        JLabel jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.outline.title.label"));
        this.constraints.insets = new Insets(0, 0, 5, 5);
        this.constraints.anchor = 17;
        this.addGB(jPanel, jLabel, 0, 0, 1, 1);
        this.titleTextField = new JTextField();
        this.titleTextField.setColumns(35);
        this.titleTextField.addActionListener(this);
        this.titleTextField.addFocusListener(this);
        this.constraints.insets = new Insets(0, 0, 5, 0);
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.titleTextField, 1, 0, 1, 1);
        this.buildDestinationTypeComboBox();
        JLabel jLabel2 = new JLabel(this.messageBundle.getString("viewer.utilityPane.outline.destination.type.label"));
        this.constraints.insets = new Insets(0, 0, 5, 5);
        this.constraints.anchor = 17;
        this.addGB(jPanel, jLabel2, 0, 1, 1, 1);
        this.addGB(jPanel, this.destinationTypeComboBox, 1, 1, 1, 1);
        this.destinationTypesCards = new JPanel(new CardLayout());
        this.implicitDestinationPanel = new ImplicitDestinationPanel(this.controller);
        this.destinationTypesCards.add((Component)this.implicitDestinationPanel, IMPLICIT_DESTINATION);
        JComponent jComponent = this.buildNameTreePanel();
        if (jComponent != null) {
            this.destinationTypesCards.add((Component)jComponent, NAMED_DESTINATION);
        }
        this.titleTextField.setText(this.outlineItemTreeNode.getOutlineItem().getTitle());
        Destination destination = this.outlineItemTreeNode.getOutlineItem().getDest();
        CardLayout cardLayout = (CardLayout)this.destinationTypesCards.getLayout();
        if (destination != null && destination.getNamedDestination() != null) {
            this.destinationTypeComboBox.setSelectedIndex(1);
            cardLayout.show(this.destinationTypesCards, NAMED_DESTINATION);
        } else {
            this.destinationTypeComboBox.setSelectedItem(0);
            cardLayout.show(this.destinationTypesCards, IMPLICIT_DESTINATION);
        }
        this.addGB(jPanel, this.destinationTypesCards, 0, 2, 1, 2);
        this.okButton = new JButton(this.messageBundle.getString("viewer.utilityPane.outline.ok.label"));
        this.okButton.addActionListener(this);
        this.constraints.insets = new Insets(0, 0, 0, 5);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.okButton, 0, 3, 1, 1);
        this.cancelButton = new JButton(this.messageBundle.getString("viewer.utilityPane.outline.cancel.label"));
        this.cancelButton.addActionListener(this);
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.cancelButton, 1, 3, 1, 1);
        this.add(jPanel);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.controller.getViewerFrame());
    }

    private JComponent buildNameTreePanel() {
        Catalog catalog = this.controller.getDocument().getCatalog();
        if (catalog.getNames() != null && catalog.getNames().getDestsNameTree() != null) {
            Object object;
            NameTree nameTree = catalog.getNames().getDestsNameTree();
            NameJTree nameJTree = new NameJTree();
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new NameTreeNode(nameTree.getRoot(), this.messageBundle));
            nameJTree.setModel(defaultTreeModel);
            nameJTree.setRootVisible(!nameTree.getRoot().isEmpty());
            nameJTree.setExpandsSelectedPaths(true);
            nameJTree.addTreeSelectionListener(this);
            if (this.outlineItemTreeNode.getOutlineItem().getDest() != null && (object = this.outlineItemTreeNode.getOutlineItem().getDest().getNamedDestination()) != null) {
                ((DefaultMutableTreeNode)defaultTreeModel.getRoot()).depthFirstEnumeration().asIterator().forEachRemaining(arg_0 -> OutlineDialog.lambda$buildNameTreePanel$1((String)object, nameJTree, arg_0));
            }
            object = new JScrollPane(nameJTree);
            ((JComponent)object).setPreferredSize(new Dimension(325, 225));
            return object;
        }
        return null;
    }

    private void buildDestinationTypeComboBox() {
        Names names = this.controller.getDocument().getCatalog().getNames();
        this.destinationTypeComboBox = new JComboBox();
        this.destinationTypeComboBox.addItem(new ValueLabelItem(IMPLICIT_DESTINATION, this.messageBundle.getString("viewer.utilityPane.outline.destination.type.implicit.label")));
        if (names != null && names.getDestsNameTree() != null) {
            this.destinationTypeComboBox.addItem(new ValueLabelItem(NAMED_DESTINATION, this.messageBundle.getString("viewer.utilityPane.outline.destination.type.named.label")));
        }
        this.destinationTypeComboBox.addItemListener(this);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n4;
        this.constraints.gridheight = n3;
        jPanel.add(component, this.constraints);
    }

    private static /* synthetic */ void lambda$buildNameTreePanel$1(String string, NameJTree nameJTree, TreeNode treeNode) {
        NameTreeNode nameTreeNode;
        if (treeNode instanceof NameTreeNode && (nameTreeNode = (NameTreeNode)treeNode).getName() != null && string.equals(nameTreeNode.getName().toString())) {
            TreePath treePath = new TreePath(nameTreeNode.getPath());
            SwingUtilities.invokeLater(() -> {
                nameJTree.setSelectionPath(treePath);
                nameJTree.scrollPathToVisible(treePath);
                nameJTree.expandPath(treePath);
            });
        }
    }
}

