/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.FontWidgetUtilities;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.FreeTextAnnotationComponent;
import org.icepdf.ri.common.widgets.RgbColorChooser;

public class FreeTextAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener,
ChangeListener {
    private static final int DEFAULT_FONT_SIZE = 5;
    private static final int DEFAULT_FONT_FAMILY = 0;
    private static final Color DEFAULT_FONT_COLOR = Color.DARK_GRAY;
    public static final int DEFAULT_STROKE_THICKNESS_STYLE = 0;
    public static final int DEFAULT_STROKE_STYLE = 0;
    public static final int DEFAULT_FILL_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = FreeTextAnnotation.defaultBorderColor;
    private static final Color DEFAULT_STROKE_COLOR = FreeTextAnnotation.defaultFillColor;
    private static ValueLabelItem[] FONT_NAMES_LIST;
    private static ValueLabelItem[] FONT_SIZES_LIST;
    private FreeTextAnnotation freeTextAnnotation;
    private JComboBox<ValueLabelItem> fontNameBox;
    private JComboBox<ValueLabelItem> fontSizeBox;
    private JButton fontColorButton;
    private JComboBox<ValueLabelItem> fillTypeBox;
    private JButton fillColorButton;
    private JComboBox<ValueLabelItem> strokeTypeBox;
    private JComboBox<ValueLabelItem> strokeThicknessBox;
    private JComboBox<ValueLabelItem> strokeStyleBox;
    private JButton strokeColorButton;
    private JSlider transparencySlider;

    public FreeTextAnnotationPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        FreeTextAnnotationComponent freeTextAnnotationComponent = (FreeTextAnnotationComponent)this.currentAnnotationComponent;
        this.freeTextAnnotation = (FreeTextAnnotation)freeTextAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.fontNameBox, this.freeTextAnnotation.getFontName());
        this.applySelectedValue(this.fontSizeBox, this.freeTextAnnotation.getFontSize());
        this.setButtonBackgroundColor(this.fontColorButton, this.freeTextAnnotation.getFontColor());
        this.applySelectedValue(this.strokeTypeBox, this.freeTextAnnotation.isStrokeType());
        this.applySelectedValue(this.strokeStyleBox, this.freeTextAnnotation.getBorderStyle().getBorderStyle());
        this.applySelectedValue(this.strokeThicknessBox, Float.valueOf(this.freeTextAnnotation.getBorderStyle().getStrokeWidth()));
        this.setButtonBackgroundColor(this.strokeColorButton, this.freeTextAnnotation.getColor());
        this.transparencySlider.setValue(Math.round(this.freeTextAnnotation.getOpacity() * 255.0f));
        this.applySelectedValue(this.fillTypeBox, this.freeTextAnnotation.isFillType());
        this.setButtonBackgroundColor(this.fillColorButton, this.freeTextAnnotation.getFillColor());
        this.safeEnable(this.fontNameBox, true);
        this.safeEnable(this.fontSizeBox, true);
        this.safeEnable(this.fontColorButton, true);
        this.safeEnable(this.strokeTypeBox, true);
        this.safeEnable(this.strokeThicknessBox, true);
        this.safeEnable(this.strokeStyleBox, true);
        this.safeEnable(this.strokeColorButton, true);
        this.safeEnable(this.fillTypeBox, true);
        this.safeEnable(this.fillColorButton, true);
        this.safeEnable(this.transparencySlider, true);
        this.disableInvisibleFields();
    }

    private void disableInvisibleFields() {
        boolean bl = this.freeTextAnnotation.isFillType();
        boolean bl2 = this.freeTextAnnotation.isStrokeType();
        this.safeEnable(this.fillColorButton, bl);
        this.safeEnable(this.strokeThicknessBox, bl2);
        this.safeEnable(this.strokeStyleBox, bl2);
        this.safeEnable(this.strokeColorButton, bl2);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.fontNameBox) {
                this.freeTextAnnotation.setFontName((String)valueLabelItem.getValue());
                this.preferences.put("application.viewer.preference.annotation.freetext.font", this.freeTextAnnotation.getFontName());
            } else if (itemEvent.getSource() == this.fontSizeBox) {
                this.freeTextAnnotation.setFontSize(((Integer)valueLabelItem.getValue()).intValue());
                this.preferences.putInt("application.viewer.preference.annotation.freetext.size", this.freeTextAnnotation.getFontSize());
            } else if (itemEvent.getSource() == this.strokeTypeBox) {
                Boolean bl = (Boolean)valueLabelItem.getValue();
                this.freeTextAnnotation.setStrokeType(bl.booleanValue());
                if (bl.booleanValue()) {
                    this.freeTextAnnotation.getBorderStyle().setStrokeWidth(((Float)((ValueLabelItem)this.strokeThicknessBox.getSelectedItem()).getValue()).floatValue());
                    this.freeTextAnnotation.getBorderStyle().setBorderStyle((Name)((ValueLabelItem)this.strokeStyleBox.getSelectedItem()).getValue());
                    this.freeTextAnnotation.setColor(this.strokeColorButton.getBackground());
                } else {
                    this.freeTextAnnotation.getBorderStyle().setStrokeWidth(0.0f);
                }
                this.disableInvisibleFields();
            } else if (itemEvent.getSource() == this.strokeStyleBox) {
                this.freeTextAnnotation.getBorderStyle().setBorderStyle((Name)valueLabelItem.getValue());
            } else if (itemEvent.getSource() == this.strokeThicknessBox) {
                this.freeTextAnnotation.getBorderStyle().setStrokeWidth(((Float)valueLabelItem.getValue()).floatValue());
            } else if (itemEvent.getSource() == this.fillTypeBox) {
                this.freeTextAnnotation.setFillType(((Boolean)valueLabelItem.getValue()).booleanValue());
                if (this.freeTextAnnotation.isFillType()) {
                    this.freeTextAnnotation.setFillColor(this.fillColorButton.getBackground());
                }
                this.disableInvisibleFields();
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.strokeColorButton) {
            Color color2 = RgbColorChooser.showDialog(this.strokeColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.color.ChooserTitle"), this.strokeColorButton.getBackground());
            if (color2 != null) {
                this.setButtonBackgroundColor(this.strokeColorButton, color2);
                this.freeTextAnnotation.setColor(color2);
                this.preferences.putInt("application.viewer.preference.annotation.freetext.border.color", color2.getRGB());
            }
        } else if (actionEvent.getSource() == this.fillColorButton) {
            Color color3 = RgbColorChooser.showDialog(this.fillColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.freeText.fill.color.ChooserTitle"), this.fillColorButton.getBackground());
            if (color3 != null) {
                this.setButtonBackgroundColor(this.fillColorButton, color3);
                this.freeTextAnnotation.setFillColor(color3);
                this.preferences.putInt("application.viewer.preference.annotation.freetext.fill.color", color3.getRGB());
            }
        } else if (actionEvent.getSource() == this.fontColorButton && (color = RgbColorChooser.showDialog(this.fillColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.color.ChooserTitle"), this.fontColorButton.getBackground())) != null) {
            this.setButtonBackgroundColor(this.fontColorButton, color);
            this.freeTextAnnotation.setFontColor(color);
            this.preferences.putInt("application.viewer.preference.annotation.freetext.color", color.getRGB());
        }
        this.updateCurrentAnnotation();
        this.currentAnnotationComponent.resetAppearanceShapes();
        this.currentAnnotationComponent.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.alphaSliderChange(changeEvent, (MarkupAnnotation)this.freeTextAnnotation, "application.viewer.preference.annotation.freetext.opacity");
    }

    private void createGUI() {
        if (FONT_NAMES_LIST == null) {
            FONT_NAMES_LIST = FontWidgetUtilities.generateFontNameList(this.messageBundle);
        }
        if (FONT_SIZES_LIST == null) {
            FONT_SIZES_LIST = FontWidgetUtilities.generateFontSizeNameList(this.messageBundle);
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.freeText.appearance.title"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.fontNameBox = new JComboBox<ValueLabelItem>(FONT_NAMES_LIST);
        this.fontNameBox.setSelectedIndex(0);
        this.fontNameBox.addItemListener(this);
        JLabel jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.name"));
        this.addGB(this, jLabel, 0, 0, 1, 1);
        this.addGB(this, this.fontNameBox, 1, 0, 1, 1);
        this.fontSizeBox = new JComboBox<ValueLabelItem>(FONT_SIZES_LIST);
        this.fontSizeBox.setSelectedIndex(5);
        this.fontSizeBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.size"));
        this.addGB(this, jLabel, 0, 1, 1, 1);
        this.addGB(this, this.fontSizeBox, 1, 1, 1, 1);
        this.fontColorButton = new JButton(" ");
        this.fontColorButton.addActionListener(this);
        this.fontColorButton.setOpaque(true);
        this.fontColorButton.setBackground(DEFAULT_FONT_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.font.color"));
        this.addGB(this, jLabel, 0, 2, 1, 1);
        this.addGB(this, this.fontColorButton, 1, 2, 1, 1);
        this.strokeTypeBox = new JComboBox<ValueLabelItem>(VISIBLE_TYPE_LIST);
        this.strokeTypeBox.setSelectedIndex(0);
        this.strokeTypeBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.type"));
        this.addGB(this, jLabel, 0, 3, 1, 1);
        this.addGB(this, this.strokeTypeBox, 1, 3, 1, 1);
        this.strokeThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.strokeThicknessBox.setSelectedIndex(0);
        this.strokeThicknessBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.thickness"));
        this.addGB(this, jLabel, 0, 4, 1, 1);
        this.addGB(this, this.strokeThicknessBox, 1, 4, 1, 1);
        this.strokeStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.strokeStyleBox.setSelectedIndex(0);
        this.strokeStyleBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.style"));
        this.addGB(this, jLabel, 0, 5, 1, 1);
        this.addGB(this, this.strokeStyleBox, 1, 5, 1, 1);
        this.strokeColorButton = new JButton(" ");
        this.strokeColorButton.addActionListener(this);
        this.strokeColorButton.setOpaque(true);
        this.setButtonBackgroundColor(this.strokeColorButton, DEFAULT_BORDER_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.border.color"));
        this.addGB(this, jLabel, 0, 6, 1, 1);
        this.addGB(this, this.strokeColorButton, 1, 6, 1, 1);
        this.fillTypeBox = new JComboBox<ValueLabelItem>(VISIBLE_TYPE_LIST);
        this.fillTypeBox.setSelectedIndex(0);
        this.fillTypeBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.fill.type"));
        this.addGB(this, jLabel, 0, 7, 1, 1);
        this.addGB(this, this.fillTypeBox, 1, 7, 1, 1);
        this.fillColorButton = new JButton(" ");
        this.fillColorButton.addActionListener(this);
        this.fillColorButton.setOpaque(true);
        this.setButtonBackgroundColor(this.fillColorButton, DEFAULT_STROKE_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.fill.color"));
        this.addGB(this, jLabel, 0, 8, 1, 1);
        this.addGB(this, this.fillColorButton, 1, 8, 1, 1);
        this.transparencySlider = this.buildAlphaSlider();
        this.transparencySlider.setMajorTickSpacing(255);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.freeText.transparencyLabel"));
        this.addGB(this, jLabel, 0, 9, 1, 1);
        this.addGB(this, this.transparencySlider, 1, 9, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 10, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.fontNameBox, bl);
        this.safeEnable(this.fontSizeBox, bl);
        this.safeEnable(this.fontColorButton, bl);
        this.safeEnable(this.strokeTypeBox, bl);
        this.safeEnable(this.strokeThicknessBox, bl);
        this.safeEnable(this.strokeStyleBox, bl);
        this.safeEnable(this.strokeColorButton, bl);
        this.safeEnable(this.fillTypeBox, bl);
        this.safeEnable(this.fillColorButton, bl);
        this.safeEnable(this.transparencySlider, bl);
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

