/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.destinations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.NameTreeNode;
import org.icepdf.ri.common.utility.annotation.destinations.ImplicitDestinationPanel;
import org.icepdf.ri.common.views.Controller;

public class NameTreeEditDialog
extends EscapeJDialog
implements ActionListener {
    private final Controller controller;
    private final ResourceBundle messageBundle;
    private NameTreeNode nameTreeNode;
    private String name;
    private Destination destination;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField nameTextField;
    private JLabel errorLabel;
    private ImplicitDestinationPanel implicitDestinationPanel;
    private GridBagConstraints constraints;

    public NameTreeEditDialog(Controller controller, Page page, int n, int n2) {
        super(controller.getViewerFrame(), true);
        this.controller = controller;
        this.messageBundle = controller.getMessageBundle();
        this.destination = new Destination(page, n, n2);
        this.setGui();
    }

    public NameTreeEditDialog(Controller controller, Page page, String string, int n, int n2) {
        super(controller.getViewerFrame(), true);
        this.controller = controller;
        this.messageBundle = controller.getMessageBundle();
        this.destination = new Destination(page, n, n2);
        this.name = string;
        this.setGui();
    }

    public NameTreeEditDialog(Controller controller, NameTreeNode nameTreeNode) {
        super(controller.getViewerFrame(), true);
        this.controller = controller;
        this.nameTreeNode = nameTreeNode;
        this.messageBundle = controller.getMessageBundle();
        this.name = nameTreeNode.getName().toString();
        this.destination = new Destination(controller.getDocument().getCatalog().getLibrary(), nameTreeNode.getReference());
        this.destination.setNamedDestination(nameTreeNode.getName().toString());
        this.setGui();
    }

    public NameTreeEditDialog(Controller controller, Destination destination) {
        super(controller.getViewerFrame(), true);
        this.controller = controller;
        this.nameTreeNode = new NameTreeNode((StringObject)new LiteralStringObject(destination.getNamedDestination()), destination.getPageReference());
        this.messageBundle = controller.getMessageBundle();
        this.name = destination.getNamedDestination();
        this.destination = destination;
        this.setGui();
    }

    public NameTreeNode getNameTreeNode() {
        return this.nameTreeNode;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            Catalog catalog = this.controller.getDocument().getCatalog();
            String string = this.nameTreeNode == null ? this.name : this.nameTreeNode.getName().toString();
            this.name = this.nameTextField.getText();
            Destination destination = this.destination;
            this.destination = this.implicitDestinationPanel.getDestination(catalog.getLibrary());
            if (this.name == null) {
                this.errorLabel.setText(this.messageBundle.getString("viewer.utilityPane.destinations.dialog.error.emptyName.label"));
                return;
            }
            this.destination.setNamedDestination(this.name);
            this.errorLabel.setText("");
            boolean bl = this.nameTreeNode == null ? catalog.addNamedDestination(this.name, this.destination) : catalog.updateNamedDestination(string, this.name, this.destination);
            if (!bl) {
                this.errorLabel.setText(this.messageBundle.getString("viewer.utilityPane.destinations.dialog.error.existingName.label"));
            } else {
                if (this.nameTreeNode != null) {
                    this.controller.getDocumentViewController().firePropertyChange("destinationUpdated", destination, this.destination);
                } else {
                    this.controller.getDocumentViewController().firePropertyChange("destinationAdded", null, this.destination);
                }
                this.setVisible(false);
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void setGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        this.setTitle(this.messageBundle.getString("viewer.utilityPane.destinations.dialog.title"));
        this.constraints = new GridBagConstraints();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.okButton = new JButton(this.messageBundle.getString("viewer.button.ok.label"));
        this.okButton.setMnemonic(this.messageBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.messageBundle.getString("viewer.button.cancel.label"));
        this.cancelButton.setMnemonic(this.messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        this.cancelButton.addActionListener(this);
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(Color.red);
        this.nameTextField = new JTextField();
        if (this.name != null) {
            this.nameTextField.setText(this.name);
        }
        this.implicitDestinationPanel = new ImplicitDestinationPanel(this.controller);
        if (this.destination != null) {
            this.implicitDestinationPanel.setDestination(this.destination);
        }
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 18;
        this.constraints.fill = 0;
        this.constraints.weightx = 0.1;
        this.constraints.weighty = 0.0;
        this.addGB(jPanel, new JLabel(this.messageBundle.getString("viewer.utilityPane.destinations.dialog.name.label")), 0, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.addGB(jPanel, this.nameTextField, 1, 0, 5, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.errorLabel, 1, 1, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.implicitDestinationPanel, 0, 2, 6, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.addGB(jPanel, new JLabel(""), 0, 3, 1, 1);
        this.constraints.anchor = 13;
        this.constraints.fill = 0;
        this.addGB(jPanel, this.okButton, 1, 4, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.cancelButton, 2, 4, 1, 1);
        this.getContentPane().add(jPanel);
        this.setSize(new Dimension(450, 250));
        this.setLocationRelativeTo(this.controller.getViewerFrame());
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

