/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.icepdf.ri.common.tools.TextSelection;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;

public class TextSelectionPageHandler
extends TextSelection
implements ToolHandler {
    protected boolean isMouseDrag;
    protected boolean isClearSelection;

    public TextSelectionPageHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
    }

    public void setDocumentViewController(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.wordLineSelection(mouseEvent.getClickCount(), mouseEvent.getPoint(), this.pageViewComponent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.isClearSelection = false;
        this.pageViewComponent.requestFocus();
        this.lastMousePressedLocation = mouseEvent.getPoint();
        this.selectionStart(mouseEvent.getPoint(), this.pageViewComponent, true);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.selectionEnd(mouseEvent.getPoint(), this.pageViewComponent);
        this.isMouseDrag = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isClearSelection) {
            return;
        }
        this.isMouseDrag = true;
        Point point = mouseEvent.getPoint();
        this.updateSelectionSize(point.x, point.y, this.pageViewComponent);
        boolean bl = true;
        boolean bl2 = true;
        if (this.lastMousePressedLocation != null) {
            bl = this.lastMousePressedLocation.y <= mouseEvent.getPoint().y;
            bl2 = this.lastMousePressedLocation.x <= mouseEvent.getPoint().x;
        }
        this.selection(mouseEvent.getPoint(), this.pageViewComponent, bl, bl2);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
        this.setSelectionSize(rectangle, this.pageViewComponent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.selectionTextSelectIcon(mouseEvent.getPoint(), this.pageViewComponent);
    }

    public void cancelSelection() {
        this.isMouseDrag = false;
        this.isClearSelection = true;
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void paintTool(Graphics graphics) {
        if (enableMarginExclusionBorder && this.topMarginExclusion != null && this.bottomMarginExclusion != null) {
            AffineTransform affineTransform = this.getPageTransform();
            ((Graphics2D)graphics).transform(affineTransform);
            graphics.setColor(Color.RED);
            this.paintSelectionBox(graphics, this.topMarginExclusion.getBounds());
            graphics.setColor(Color.BLUE);
            this.paintSelectionBox(graphics, this.bottomMarginExclusion.getBounds());
        }
    }
}

