/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.icepdf.core.util.SystemProperties;

public class BareBonesBrowserLaunch {
    private static final Logger logger = Logger.getLogger(BareBonesBrowserLaunch.class.toString());
    private static final String errMsg = "Error attempting to launch web browser";
    public static final String FILE_PREFIX = "file://";
    private static final String os = SystemProperties.OS_NAME.toLowerCase();

    public static void openURL(String string) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Opening URL: " + string);
            }
            if (BareBonesBrowserLaunch.isMac()) {
                Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                Method method = clazz.getDeclaredMethod("openURL", String.class);
                method.invoke(null, string);
            } else if (BareBonesBrowserLaunch.isWindows()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
            } else if (BareBonesBrowserLaunch.isUnix()) {
                String[] stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String string2 = null;
                for (int i = 0; i < stringArray.length && string2 == null; ++i) {
                    if (Runtime.getRuntime().exec(new String[]{"which", stringArray[i]}).waitFor() != 0) continue;
                    string2 = stringArray[i];
                }
                if (string2 == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{string2, string});
            } else {
                JOptionPane.showMessageDialog(null, errMsg);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + exception.getLocalizedMessage());
        }
    }

    public static void openFile(String string) {
        BareBonesBrowserLaunch.openURL(FILE_PREFIX + string);
    }

    public static boolean isWindows() {
        return os.contains("win");
    }

    public static boolean isMac() {
        return os.contains("mac");
    }

    public static boolean isUnix() {
        return os.contains("nix") || os.contains("nux");
    }
}

