/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.summary;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.views.PageComponentSelector;
import org.icepdf.ri.common.views.annotations.summary.AnnotationSummaryBox;

public class DraggableAnnotationPanel
extends JPanel {
    private static final int DEFAULT_GAP = 8;
    private boolean firstLoad = true;
    private Component dragComponent;
    private boolean isDragging;
    protected Frame frame;

    public DraggableAnnotationPanel(Frame frame, int n, int n2, int n3) {
        this.setLayout(new ColumnLayoutManager(n3));
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public DraggableAnnotationPanel(Frame frame) {
        this(frame, 1, 8, 8);
    }

    static class ComponentBoundsCompare
    implements Comparator<Component> {
        ComponentBoundsCompare() {
        }

        @Override
        public int compare(Component component, Component component2) {
            return Integer.compare(component.getY(), component2.getY());
        }
    }

    public class ColumnLayoutManager
    implements LayoutManager2 {
        public int padding = 10;
        private final ArrayList<Component> children = new ArrayList(25);

        public ColumnLayoutManager(int n) {
            this();
            this.padding = n;
        }

        public ColumnLayoutManager() {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.children.add(component);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            int n = this.padding;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.padding * 2;
            for (Component component : this.children) {
                n2 = container.getWidth() - n4;
                n3 = n = Math.max(n3, component.getLocation().y + component.getPreferredSize().height + this.padding);
            }
            return new Dimension(n2 += this.padding, n += this.padding);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.maximumLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.maximumLayoutSize(container);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.children.remove(component);
        }

        @Override
        public void layoutContainer(Container container) {
            if (DraggableAnnotationPanel.this.firstLoad) {
                this.evenLayout(container);
            } else {
                this.stickyLayout(container);
            }
        }

        private void stickyLayout(Container container) {
            Component[] componentArray;
            Rectangle rectangle = new Rectangle();
            int n = this.padding * 2;
            for (Component component : componentArray = container.getComponents()) {
                Rectangle rectangle2 = component.getBounds();
                Dimension dimension = component.getPreferredSize();
                int n2 = this.padding;
                int n3 = rectangle2.y;
                if (dimension.width > container.getWidth()) {
                    component.setBounds(n2, n3, component.getWidth(), component.getHeight());
                } else {
                    component.setBounds(n2, n3, container.getWidth() - n, dimension.height);
                }
                rectangle.setRect(rectangle2);
            }
        }

        private void evenLayout(Container container) {
            Point point = new Point();
            int n = this.padding * 2;
            for (Component component : container.getComponents()) {
                int n2 = point.x + this.padding;
                int n3 = point.y + this.padding;
                Dimension dimension = component.getPreferredSize();
                if (dimension.width > container.getWidth()) {
                    component.setBounds(n2, n3, component.getWidth(), component.getHeight());
                } else {
                    component.setBounds(n2, n3, container.getWidth() - n, dimension.height);
                }
                point.y = n3 + dimension.height;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private Point dragOffset;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            AnnotationSummaryBox annotationSummaryBox;
            Component component;
            if (mouseEvent.getButton() == 3 && (component = DraggableAnnotationPanel.this.getComponentAt(mouseEvent.getPoint())) instanceof AnnotationSummaryBox) {
                annotationSummaryBox = (AnnotationSummaryBox)component;
                jPopupMenu = annotationSummaryBox.getContextMenu(DraggableAnnotationPanel.this.frame, this);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (component = DraggableAnnotationPanel.this.getComponentAt(mouseEvent.getPoint())) instanceof AnnotationSummaryBox) {
                annotationSummaryBox = (AnnotationSummaryBox)component;
                jPopupMenu = ((PopupAnnotation)annotationSummaryBox.getAnnotation()).getParent();
                PageComponentSelector.SelectAnnotationComponent(annotationSummaryBox.getController(), (Annotation)jPopupMenu);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = DraggableAnnotationPanel.this.getComponentAt(mouseEvent.getPoint());
            if (mouseEvent.getButton() == 1 && component instanceof AnnotationSummaryBox) {
                DraggableAnnotationPanel.this.dragComponent = component;
                DraggableAnnotationPanel.this.dragComponent.requestFocus();
                DraggableAnnotationPanel.this.setComponentZOrder(DraggableAnnotationPanel.this.dragComponent, 0);
                this.dragOffset = new Point();
                this.dragOffset.x = mouseEvent.getPoint().x - component.getX();
                this.dragOffset.y = mouseEvent.getPoint().y - component.getY();
                DraggableAnnotationPanel.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (DraggableAnnotationPanel.this.isDragging) {
                this.moveComponent(DraggableAnnotationPanel.this.dragComponent);
            }
            DraggableAnnotationPanel.this.isDragging = false;
            DraggableAnnotationPanel.this.dragComponent = null;
        }

        public void checkForOverlap(Component component) {
            int n = 10;
            Component[] componentArray = DraggableAnnotationPanel.this.getComponents();
            Arrays.sort(componentArray, new ComponentBoundsCompare());
            for (int i = 0; i < componentArray.length - 1; ++i) {
                Component component2 = componentArray[i];
                Component component3 = componentArray[i + 1];
                Rectangle rectangle = component3.getBounds();
                if (!component2.getBounds().intersects(rectangle)) continue;
                component3.setLocation(rectangle.x, component2.getY() + component2.getHeight() + n);
                this.checkForOverlap(component3);
            }
        }

        public void moveComponent(Component component) {
            if (component != null) {
                Component component2;
                int n;
                int n2 = 10;
                Component[] componentArray = DraggableAnnotationPanel.this.getComponents();
                Arrays.sort(componentArray, new ComponentBoundsCompare());
                int n3 = this.findComponentAt(componentArray, component);
                Rectangle rectangle = component.getBounds();
                for (n = 0; n < componentArray.length; ++n) {
                    component2 = componentArray[n];
                    if (n == n3 || !component2.getBounds().intersects(rectangle)) continue;
                    if (component2.getY() < rectangle.y) {
                        component.setLocation(rectangle.x, component2.getY() + component2.getHeight() + n2);
                        this.moveComponent(component);
                        continue;
                    }
                    component2.setLocation(rectangle.x, component.getY() + component.getHeight() + n2);
                    this.moveComponent(component2);
                }
                if (n3 == 0 && component.getY() < n2) {
                    component.setLocation(component.getX(), n2);
                    this.moveComponent(component);
                }
                if (n3 >= 1) {
                    component2 = componentArray[n3 - 1];
                    n = component.getY() - (component2.getY() + component2.getHeight());
                    if (n < n2) {
                        component.setLocation(component.getX(), component.getY() + (n2 - n));
                        this.moveComponent(component);
                    }
                }
                DraggableAnnotationPanel.this.revalidate();
            }
        }

        private int findComponentAt(Component[] componentArray, Component component) {
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].equals(component)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            DraggableAnnotationPanel.this.isDragging = true;
            if (DraggableAnnotationPanel.this.dragComponent != null) {
                DraggableAnnotationPanel.this.firstLoad = false;
                Point point = new Point();
                point.x = mouseEvent.getPoint().x - this.dragOffset.x;
                point.y = mouseEvent.getPoint().y - this.dragOffset.y;
                DraggableAnnotationPanel.this.dragComponent.setLocation(point);
                DraggableAnnotationPanel.this.revalidate();
                DraggableAnnotationPanel.this.repaint();
            }
        }

        private int getComponentIndex(Component component) {
            for (int i = 0; i < DraggableAnnotationPanel.this.getComponentCount(); ++i) {
                if (!component.equals(DraggableAnnotationPanel.this.getComponent(i))) continue;
                return i;
            }
            return -1;
        }
    }
}

