/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signatures;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.SignatureHandler;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignaturePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignatureValidationPanel;
import org.icepdf.ri.common.views.annotations.signatures.SignatureValidationStatus;

public class SignatureValidationDialog
extends EscapeJDialog {
    private static final Logger logger = Logger.getLogger(SignatureValidationDialog.class.toString());
    private final SignatureValidator signatureValidator;
    protected static ResourceBundle messageBundle;
    protected final SignatureWidgetAnnotation signatureWidgetAnnotation;

    public SignatureValidationDialog(Frame frame, ResourceBundle resourceBundle, SignatureWidgetAnnotation signatureWidgetAnnotation, SignatureValidator signatureValidator) {
        super(frame, true);
        messageBundle = resourceBundle;
        this.signatureValidator = signatureValidator;
        this.signatureWidgetAnnotation = signatureWidgetAnnotation;
        this.buildUI();
    }

    protected void buildUI() {
        SignatureValidationStatus signatureValidationStatus = new SignatureValidationStatus(messageBundle, this.signatureWidgetAnnotation, this.signatureValidator);
        this.setTitle(messageBundle.getString("viewer.annotation.signature.validation.dialog.title"));
        JButton jButton = new JButton(messageBundle.getString("viewer.annotation.signature.validation.dialog.close.button.label"));
        jButton.setMnemonic(messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        jButton.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        JButton jButton2 = new JButton(messageBundle.getString("viewer.annotation.signature.validation.dialog.signerProperties.button.label"));
        SignatureValidationDialog signatureValidationDialog = this;
        jButton2.addActionListener(actionEvent -> {
            SignatureHandler signatureHandler;
            SignatureValidator signatureValidator;
            SignatureFieldDictionary signatureFieldDictionary = this.signatureWidgetAnnotation.getFieldDictionary();
            if (signatureFieldDictionary != null && (signatureValidator = (signatureHandler = signatureFieldDictionary.getLibrary().getSignatureHandler()).validateSignature(signatureFieldDictionary)) != null) {
                new SignaturePropertiesDialog(signatureValidationDialog, messageBundle, this.signatureWidgetAnnotation).setVisible(true);
            }
        });
        SignatureValidationPanel signatureValidationPanel = new SignatureValidationPanel(signatureValidationStatus, messageBundle, this.signatureWidgetAnnotation, this.signatureValidator, true, false);
        GridBagConstraints gridBagConstraints = signatureValidationPanel.getConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        signatureValidationPanel.addGB(jButton2, 0, 5, 1, 1);
        gridBagConstraints.anchor = 13;
        signatureValidationPanel.addGB(jButton, 1, 5, 1, 1);
        this.getContentPane().add(signatureValidationPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setResizable(false);
    }
}

