/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.TextAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.ResizableBorder;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.AnnotationFileDropHandler;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationPopupMenu;
import org.icepdf.ri.common.views.annotations.MarkupGlueComponent;
import org.icepdf.ri.common.views.annotations.PageViewAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupListener;
import org.icepdf.ri.common.views.annotations.SpellCheckLoader;
import org.icepdf.ri.common.views.annotations.summary.AnnotationSummaryBox;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class PopupAnnotationComponent
extends AbstractAnnotationComponent<PopupAnnotation>
implements TreeSelectionListener,
ActionListener,
DocumentListener,
PropertyChangeListener,
MouseWheelListener,
DropTargetListener,
PageViewAnnotationComponent {
    public static final int DEFAULT_WIDTH = 215;
    public static final int DEFAULT_HEIGHT = 150;
    public static final Color backgroundColor = new Color(252, 253, 227);
    public static final Dimension BUTTON_SIZE = new Dimension(22, 22);
    private GridBagConstraints constraints;
    protected Color popupBackgroundColor;
    protected MouseListener popupListener;
    protected JPanel commentPanel;
    protected JTextArea textArea;
    protected JLabel creationLabel;
    protected JLabel titleLabel;
    protected JButton minimizeButton;
    protected JToggleButton privateToggleButton;
    protected JTree commentTree;
    protected JScrollPane commentTreeScrollPane;
    protected MarkupAnnotation selectedMarkupAnnotation;
    protected MarkupGlueComponent markupGlueComponent;
    protected final boolean disableSpellCheck;
    protected AbstractPageViewComponent parentPageViewComponent;
    private final String userName = SystemProperties.USER_NAME;

    public PopupAnnotationComponent(PopupAnnotation popupAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        this(popupAnnotation, documentViewController, abstractPageViewComponent, false);
    }

    public PopupAnnotationComponent(PopupAnnotation popupAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent, boolean bl) {
        super(popupAnnotation, documentViewController, abstractPageViewComponent);
        this.isEditable = true;
        this.isRollover = false;
        this.isMovable = true;
        this.isResizable = true;
        this.isShowInvisibleBorder = false;
        this.disableSpellCheck = bl;
        try {
            popupAnnotation.init();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.fine("Popup annotation component instance creation was interrupted");
        }
        this.buildGUI();
        this.addFontSizeBindings();
        boolean bl2 = popupAnnotation.isOpen();
        this.setVisible(bl2);
        ((DocumentViewControllerImpl)documentViewController).addPropertyChangeListener(this);
        new DropTarget(this, 3, this);
    }

    @Override
    public void setParentPageComponent(AbstractPageViewComponent abstractPageViewComponent) {
        this.parentPageViewComponent = abstractPageViewComponent;
    }

    @Override
    protected Rectangle limitAnnotationPosition(int n, int n2, int n3, int n4) {
        return new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void refreshDirtyBounds() {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        Rectangle rectangle = ((PopupAnnotation)this.annotation).calculatePageSpaceRectangle(page, documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        Rectangle rectangle2 = this.parentPageViewComponent.getParent().getBounds();
        rectangle.x += rectangle2.x;
        rectangle.y += rectangle2.y;
        this.setBounds(rectangle);
        this.setTextAreaFontSize(((PopupAnnotation)this.annotation).getTextAreaFontsize());
        this.setHeaderLabelsFontSize(((PopupAnnotation)this.annotation).getHeaderLabelsFontSize());
    }

    @Override
    public void refreshAnnotationRect() {
        Page page = this.pageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        AffineTransform affineTransform = page.getToPageSpaceTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        Rectangle rectangle = this.parentPageViewComponent.getParent().getBounds();
        Rectangle rectangle2 = this.getBounds();
        rectangle2.x -= rectangle.x;
        rectangle2.y -= rectangle.y;
        Rectangle rectangle3 = Annotation.commonBoundsNormalization((GeneralPath)new GeneralPath(rectangle2), (AffineTransform)affineTransform);
        ((PopupAnnotation)this.annotation).syncBBoxToUserSpaceRectangle((Rectangle2D)rectangle3);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((DocumentViewControllerImpl)this.documentViewController).removePropertyChangeListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!((PopupAnnotation)this.annotation).getFlagLocked() && !((PopupAnnotation)this.annotation).getFlagReadOnly()) {
            ResizableBorder resizableBorder = (ResizableBorder)this.getBorder();
            this.setCursor(Cursor.getPredefinedCursor(resizableBorder.getCursor(mouseEvent)));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.isMousePressed = true;
        if (SystemProperties.INTERACTIVE_ANNOTATIONS && !((PopupAnnotation)this.annotation).getFlagReadOnly()) {
            this.initiateMouseMoved(mouseEvent);
        }
        this.repaint();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.isMousePressed) {
            Rectangle rectangle = this.getBounds();
            Dimension dimension = ((JComponent)((Object)this.pageViewComponent.getParentDocumentView())).getSize();
            if (rectangle.x != n || rectangle.y != n2) {
                if (n < 0) {
                    if (rectangle.width != n3) {
                        n3 += n;
                    }
                    n = 0;
                } else if (n + n3 > dimension.width) {
                    n = dimension.width - rectangle.width;
                }
                if (n2 < 0) {
                    if (rectangle.height != n4) {
                        n4 += n2;
                    }
                    n2 = 0;
                } else if (n2 + n4 > dimension.height) {
                    n2 = dimension.height - rectangle.height;
                }
            }
            if (rectangle.width != n3 || rectangle.height != n4) {
                if (n + n3 > dimension.width) {
                    n3 = dimension.width - n;
                } else if (n2 + n4 > dimension.height) {
                    n4 = dimension.height - n2;
                }
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.popupBackgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(PopupAnnotation.BORDER_COLOR);
        graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < 215 || rectangle.height < 150) {
            this.setBounds(rectangle.x, rectangle.y, 215, 150);
        }
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        if (bl) {
            this.textArea.requestFocusInWindow();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void buildGUI() {
        List list = this.pageViewComponent.getPage().getAnnotations();
        this.selectedMarkupAnnotation = ((PopupAnnotation)this.annotation).getParent();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
        boolean bl = this.buildCommentTree(this.selectedMarkupAnnotation, list, defaultMutableTreeNode);
        this.commentTree = new JTree(defaultMutableTreeNode);
        this.commentTree.setRootVisible(true);
        this.commentTree.setExpandsSelectedPaths(true);
        this.commentTree.setShowsRootHandles(true);
        this.commentTree.setScrollsOnExpand(true);
        this.commentTree.setRootVisible(false);
        this.commentTree.getSelectionModel().setSelectionMode(1);
        this.commentTree.addTreeSelectionListener(this);
        this.refreshTree(this.commentTree);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        this.commentTree.setCellRenderer(defaultTreeCellRenderer);
        this.commentTree.addMouseListener(new PopupTreeListener());
        this.commentTreeScrollPane = new JScrollPane(this.commentTree);
        this.commentTree.setSelectionRow(0);
        this.popupBackgroundColor = backgroundColor;
        if (this.selectedMarkupAnnotation != null && this.selectedMarkupAnnotation.getColor() != null) {
            this.popupBackgroundColor = this.checkColor(this.selectedMarkupAnnotation.getColor());
        }
        this.minimizeButton = new JButton("  _  ");
        this.minimizeButton.addActionListener(this);
        this.minimizeButton.setToolTipText(this.messageBundle.getString("viewer.annotation.popup.mimimize.tooltip.label"));
        this.minimizeButton.setContentAreaFilled(false);
        this.minimizeButton.setBorder(BorderFactory.createLineBorder(PopupAnnotation.BORDER_COLOR));
        this.minimizeButton.setBorderPainted(true);
        this.minimizeButton.setFocusPainted(false);
        this.minimizeButton.addActionListener(this);
        this.minimizeButton.setPreferredSize(BUTTON_SIZE);
        this.minimizeButton.setSize(BUTTON_SIZE);
        this.privateToggleButton = new JToggleButton();
        boolean bl2 = this.selectedMarkupAnnotation != null && this.selectedMarkupAnnotation.getFlagPrivateContents();
        this.privateToggleButton.setToolTipText(this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.publicToggleButton.tooltip.label"));
        this.privateToggleButton.setSelected(bl2);
        this.privateToggleButton.setFocusPainted(false);
        this.privateToggleButton.setPreferredSize(BUTTON_SIZE);
        this.privateToggleButton.setSize(BUTTON_SIZE);
        this.privateToggleButton.addActionListener(this);
        this.privateToggleButton.setContentAreaFilled(false);
        this.privateToggleButton.setBorder(BorderFactory.createLineBorder(PopupAnnotation.BORDER_COLOR));
        this.privateToggleButton.setBorderPainted(true);
        String string = this.selectedMarkupAnnotation != null ? this.selectedMarkupAnnotation.getContents() : "";
        this.textArea = new JTextArea(string != null ? string : "");
        this.textArea.setFont(new JLabel().getFont());
        this.textArea.setWrapStyleWord(true);
        this.textArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PopupAnnotation.BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.textArea.setLineWrap(true);
        this.textArea.getDocument().addDocumentListener(this);
        if (!this.disableSpellCheck) {
            SpellCheckLoader.addSpellChecker(this.textArea);
        }
        this.creationLabel = new JLabel();
        this.refreshCreationLabel();
        String string2 = this.selectedMarkupAnnotation != null ? this.selectedMarkupAnnotation.getFormattedTitleText() : "";
        this.titleLabel = new JLabel(string2);
        this.resetComponentColors();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.commentPanel = new JPanel(gridBagLayout);
        this.commentPanel.setBackground(this.popupBackgroundColor);
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.addGB(this, this.commentPanel, 0, 0, 1, 1);
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.fill = 13;
        this.constraints.weightx = 0.0;
        this.addGB(this.commentPanel, this.titleLabel, 0, 0, 1, 1);
        this.constraints.fill = 0;
        this.constraints.weightx = 0.0;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        if (SystemProperties.PRIVATE_PROPERTY_ENABLED && this.selectedMarkupAnnotation != null && this.userName.equals(this.selectedMarkupAnnotation.getTitleText())) {
            this.addGB(this.commentPanel, this.privateToggleButton, 2, 0, 1, 1);
        }
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.addGB(this.commentPanel, this.minimizeButton, 3, 0, 1, 1);
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.6;
        this.commentTreeScrollPane.setVisible(bl);
        this.addGB(this.commentPanel, this.commentTreeScrollPane, 0, 1, 4, 1);
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 13;
        this.addGB(this.commentPanel, this.creationLabel, 0, 2, 1, 1);
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.4;
        this.addGB(this.commentPanel, this.textArea, 0, 3, 4, 1);
        this.commentPanel.addMouseListener(this);
        this.commentPanel.addMouseMotionListener(this);
        this.buildContextMenu();
    }

    public void focusTextArea() {
        this.textArea.requestFocusInWindow();
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void setBoundsRelativeToParent(int n, int n2, AffineTransform affineTransform) {
        Rectangle rectangle = this.pageViewComponent.getParent().getBounds();
        Rectangle rectangle2 = new Rectangle(n, n2, (int)Math.abs(215.0 * affineTransform.getScaleX()), (int)Math.abs(150.0 * affineTransform.getScaleY()));
        rectangle2.x += rectangle.x;
        rectangle2.y += rectangle.y;
        this.setBounds(rectangle2);
        this.refreshAnnotationRect();
    }

    private void refreshTree(JTree jTree) {
        ((DefaultTreeModel)jTree.getModel()).reload();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    public void buildContextMenu() {
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)this.getAnnotationParentComponent();
        if (markupAnnotationComponent != null) {
            this.contextMenu = new MarkupAnnotationPopupMenu(markupAnnotationComponent, this.documentViewController.getParentController(), this.getPageViewComponent(), false);
            this.popupListener = new PopupListener(this.contextMenu);
            this.commentPanel.addMouseListener(this.popupListener);
        }
    }

    public void replyToSelectedMarkupExecute() {
        String string = System.getProperty("user.name");
        this.setVisible(true);
        this.createNewTextAnnotation(string, "", "Review", "None");
    }

    public AnnotationComponent getAnnotationParentComponent() {
        return this.findAnnotationComponent((Annotation)((PopupAnnotation)this.annotation).getParent());
    }

    public void deleteSelectedMarkupExecute(boolean bl) {
        this.setVisible(true);
        AnnotationComponent annotationComponent = bl ? this.getAnnotationParentComponent() : this.findAnnotationComponent((Annotation)this.selectedMarkupAnnotation);
        this.documentViewController.deleteAnnotation(annotationComponent);
        this.removeMarkupInReplyTo(this.selectedMarkupAnnotation.getPObjectReference());
        this.rebuildTree();
        this.commentPanel.revalidate();
        this.refreshPopupState();
    }

    public void setStatusSelectedMarkupExecute(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
        MessageFormat messageFormat = new MessageFormat(string);
        String string4 = messageFormat.format(objectArray);
        objectArray = new Object[]{this.selectedMarkupAnnotation.getTitleText()};
        messageFormat = new MessageFormat(string2);
        String string5 = messageFormat.format(objectArray);
        this.createNewTextAnnotation(string4, string5, "Review", string3);
    }

    private void addFontSizeBindings() {
        this.addMouseWheelListener(this);
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(61, 128);
        inputMap.put(keyStroke, "font-size-increase");
        actionMap.put("font-size-increase", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PopupAnnotationComponent.this.hasFocus()) {
                    PopupAnnotationComponent.this.changeFontSize(1.0f);
                }
            }
        });
        keyStroke = KeyStroke.getKeyStroke(48, 128);
        inputMap.put(keyStroke, "font-size-default");
        actionMap.put("font-size-default", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PopupAnnotationComponent.this.hasFocus()) {
                    PopupAnnotationComponent.this.setFontSize(new JLabel().getFont().getSize());
                }
            }
        });
        keyStroke = KeyStroke.getKeyStroke(45, 128);
        inputMap.put(keyStroke, "font-size-decrease");
        actionMap.put("font-size-decrease", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PopupAnnotationComponent.this.hasFocus()) {
                    PopupAnnotationComponent.this.changeFontSize(-1.0f);
                }
            }
        });
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.hasFocus() || this.textArea.hasFocus()) {
            if (this.findComponentAt(mouseWheelEvent.getPoint()) == this.textArea) {
                this.setTextAreaFontSize(((PopupAnnotation)this.annotation).getTextAreaFontsize() - (float)mouseWheelEvent.getWheelRotation());
            } else {
                this.changeFontSize(-mouseWheelEvent.getWheelRotation());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.minimizeButton) {
            this.setVisible(false);
            ((PopupAnnotation)this.annotation).setOpen(false);
            ((PopupAnnotation)this.annotation).setModifiedDate(PDate.formatDateTime((Date)new Date()));
            this.documentViewController.updateAnnotation(this);
        } else if (object == this.privateToggleButton) {
            boolean bl = this.privateToggleButton.isSelected();
            MarkupAnnotation markupAnnotation = ((PopupAnnotation)this.annotation).getParent();
            if (markupAnnotation != null) {
                markupAnnotation.setFlag(1024, bl);
                markupAnnotation.setModifiedDate(PDate.formatDateTime((Date)new Date()));
                this.documentViewController.updateAnnotation(this.findAnnotationComponent((Annotation)markupAnnotation));
                this.documentViewController.updateAnnotation(this);
            }
        }
    }

    public void showHidePopupAnnotations(boolean bl) {
        ArrayList<AbstractAnnotationComponent> arrayList = this.pageViewComponent.getAnnotationComponents();
        for (AnnotationComponent annotationComponent : arrayList) {
            PopupAnnotation popupAnnotation;
            PopupAnnotationComponent popupAnnotationComponent;
            if (!(annotationComponent instanceof PopupAnnotationComponent) || (popupAnnotationComponent = (PopupAnnotationComponent)annotationComponent).getAnnotation() == null || (popupAnnotation = (PopupAnnotation)popupAnnotationComponent.getAnnotation()).getParent() == null || popupAnnotation.getParent().getInReplyToAnnotation() != null) continue;
            popupAnnotationComponent.setVisible(bl);
            ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(bl);
        }
    }

    private void createNewTextAnnotation(String string, String string2, String string3, String string4) {
        TextAnnotation textAnnotation = TextAnnotationHandler.createTextAnnotation(this.documentViewController.getDocument().getPageTree().getLibrary(), this.selectedMarkupAnnotation.getUserSpaceRectangle().getBounds(), this.getToPageSpaceTransform());
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        textAnnotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        textAnnotation.setTitleText(string);
        textAnnotation.setContents(string2);
        textAnnotation.setState(string4);
        textAnnotation.setStateModel(string3);
        textAnnotation.setInReplyToAnnotation(this.selectedMarkupAnnotation);
        textAnnotation.setColor(this.selectedMarkupAnnotation.getColor());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.commentTree.getLastSelectedPathComponent();
        MarkupAnnotationTreeNode markupAnnotationTreeNode = new MarkupAnnotationTreeNode((MarkupAnnotation)textAnnotation);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = ((DefaultMutableTreeNode)this.commentTree.getModel().getRoot()).getFirstLeaf();
        }
        defaultMutableTreeNode.insert(markupAnnotationTreeNode, defaultMutableTreeNode.getChildCount());
        this.commentTree.expandRow(markupAnnotationTreeNode.getDepth() - 1);
        this.selectedMarkupAnnotation = textAnnotation;
        this.refreshTree(this.commentTree);
        this.commentTree.setSelectionPath(new TreePath(markupAnnotationTreeNode.getPath()));
        this.commentTreeScrollPane.setVisible(true);
        this.commentPanel.revalidate();
        this.addAnnotationComponent((Annotation)textAnnotation);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateContent(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateContent(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateContent(documentEvent);
    }

    protected void updateContent(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        try {
            if (document.getLength() > 0) {
                this.selectedMarkupAnnotation.setModifiedDate(PDate.formatDateTime((Date)new Date()));
                this.selectedMarkupAnnotation.setContents(document.getText(0, document.getLength()));
                this.documentViewController.updateAnnotation(this.getMarkupAnnotationComponent());
                this.documentViewController.updateAnnotation(this);
            }
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.FINE, "Error updating markup annotation content", badLocationException);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.commentTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof MarkupAnnotation) {
            this.selectedMarkupAnnotation = (MarkupAnnotation)object;
            this.refreshPopupState();
        }
    }

    public void refreshPopupState() {
        if (this.textArea != null) {
            if (this.privateToggleButton.isVisible()) {
                this.privateToggleButton.setSelected(this.selectedMarkupAnnotation.getFlagPrivateContents());
            }
            this.textArea.getDocument().removeDocumentListener(this);
            this.textArea.setText(this.selectedMarkupAnnotation.getContents());
            this.textArea.getDocument().addDocumentListener(this);
        }
        this.refreshCreationLabel();
    }

    private void refreshCreationLabel() {
        if (this.selectedMarkupAnnotation != null && this.creationLabel != null) {
            this.creationLabel.setText(this.selectedMarkupAnnotation.getFormattedCreationDate(FormatStyle.MEDIUM));
        }
    }

    private void rebuildTree() {
        List list = this.pageViewComponent.getPage().getAnnotations();
        MarkupAnnotation markupAnnotation = ((PopupAnnotation)this.annotation).getParent();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root");
        boolean bl = this.buildCommentTree(markupAnnotation, list, defaultMutableTreeNode);
        this.commentTree.removeTreeSelectionListener(this);
        ((DefaultTreeModel)this.commentTree.getModel()).setRoot(defaultMutableTreeNode);
        this.commentTree.addTreeSelectionListener(this);
        this.commentTreeScrollPane.setVisible(bl);
        this.refreshTree(this.commentTree);
        if (!bl) {
            this.selectedMarkupAnnotation = markupAnnotation;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        AnnotationComponent annotationComponent;
        if ("annotationSummaryUpdated".equals(propertyChangeEvent.getPropertyName())) {
            if (!(this instanceof AnnotationSummaryBox)) {
                AnnotationSummaryBox annotationSummaryBox = (AnnotationSummaryBox)propertyChangeEvent.getNewValue();
                if (((PopupAnnotation)this.getAnnotation()).equals(annotationSummaryBox.getAnnotation())) {
                    this.textArea.getDocument().removeDocumentListener(this);
                    this.textArea.setText(annotationSummaryBox.textArea.getText());
                    this.textArea.getDocument().addDocumentListener(this);
                    this.privateToggleButton.setSelected(annotationSummaryBox.privateToggleButton.isSelected());
                }
            }
        } else if ("annotationDeleted".equals(propertyChangeEvent.getPropertyName())) {
            AnnotationComponent annotationComponent2 = (AnnotationComponent)propertyChangeEvent.getOldValue();
            if (annotationComponent2 instanceof MarkupAnnotationComponent && annotationComponent2.getAnnotation() != null && this.containsRefs(Collections.singleton(annotationComponent2.getAnnotation().getPObjectReference()))) {
                this.rebuildTree();
                this.commentPanel.revalidate();
            }
        } else if ("annotationAdded".equals(propertyChangeEvent.getPropertyName())) {
            MarkupAnnotation markupAnnotation;
            AnnotationComponent annotationComponent3 = (AnnotationComponent)propertyChangeEvent.getNewValue();
            if (annotationComponent3 instanceof MarkupAnnotationComponent && annotationComponent3.getAnnotation() != null && !this.containsRefs(Collections.singleton((markupAnnotation = (MarkupAnnotation)annotationComponent3.getAnnotation()).getPObjectReference()))) {
                HashSet<Reference> hashSet = new HashSet<Reference>();
                while (markupAnnotation.isInReplyTo()) {
                    hashSet.add(markupAnnotation.getInReplyToAnnotation().getPObjectReference());
                    markupAnnotation = markupAnnotation.getInReplyToAnnotation();
                }
                if (this.containsRefs(hashSet)) {
                    this.rebuildTree();
                    this.commentPanel.revalidate();
                }
            }
        } else if ("annotationUpdated".equals(propertyChangeEvent.getPropertyName()) && (annotationComponent = (AnnotationComponent)propertyChangeEvent.getNewValue()) instanceof MarkupAnnotationComponent && annotationComponent.getAnnotation() != null) {
            this.updateTreeColor(annotationComponent.getAnnotation());
        }
    }

    private void updateTreeColor(Annotation annotation) {
        HashSet<Annotation> hashSet = new HashSet<Annotation>(this.getAllAnnotations());
        if (hashSet.contains(annotation)) {
            List<Annotation> list = hashSet.stream().filter(annotation2 -> !annotation2.getColor().equals(annotation.getColor())).collect(Collectors.toList());
            list.forEach(annotation2 -> {
                annotation2.setColor(annotation.getColor());
                AnnotationComponent annotationComponent = this.pageViewComponent.getComponentFor((Annotation)annotation2);
                if (annotationComponent != null) {
                    this.documentViewController.updateAnnotation(annotationComponent);
                } else {
                    logger.warning("Component not found for " + annotation2);
                }
            });
            if (!list.isEmpty()) {
                this.refreshPopupState();
                this.commentPanel.revalidate();
            }
        }
    }

    private boolean containsRefs(Set<Reference> set) {
        if (this.commentTree != null) {
            return PopupAnnotationComponent.containsRefs(set, this.commentTree.getModel().getRoot());
        }
        return false;
    }

    private static boolean containsRefs(Set<Reference> set, Object object) {
        if (object != null && object instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)object;
            if (object instanceof MarkupAnnotationTreeNode) {
                MarkupAnnotation markupAnnotation = (MarkupAnnotation)((MarkupAnnotationTreeNode)object).getUserObject();
                if (set != null && set.contains(markupAnnotation.getPObjectReference())) {
                    return true;
                }
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                if (!PopupAnnotationComponent.containsRefs(set, treeNode.getChildAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public List<Annotation> getAllAnnotations() {
        if (this.commentTree != null) {
            return PopupAnnotationComponent.getAllAnnotations(this.commentTree.getModel().getRoot()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static Stream<Annotation> getAllAnnotations(Object object) {
        if (object != null) {
            if (object instanceof TreeNode) {
                boolean bl;
                TreeNode treeNode = (TreeNode)object;
                boolean bl2 = bl = treeNode.getChildCount() > 0;
                if (object instanceof MarkupAnnotationTreeNode) {
                    MarkupAnnotation markupAnnotation = (MarkupAnnotation)((MarkupAnnotationTreeNode)object).getUserObject();
                    return bl ? Stream.concat(Stream.of(markupAnnotation), Collections.list(treeNode.children()).stream().flatMap(PopupAnnotationComponent::getAllAnnotations)) : Stream.of(markupAnnotation);
                }
                return bl ? Collections.list(treeNode.children()).stream().flatMap(PopupAnnotationComponent::getAllAnnotations) : Stream.empty();
            }
            return Stream.empty();
        }
        return Stream.empty();
    }

    @Override
    public boolean isActive() {
        return false;
    }

    public MarkupAnnotationComponent getMarkupAnnotationComponent() {
        MarkupAnnotation markupAnnotation;
        if (this.annotation != null && (markupAnnotation = this.selectedMarkupAnnotation) != null) {
            ArrayList<AbstractAnnotationComponent> arrayList = this.pageViewComponent.getAnnotationComponents();
            Reference reference = markupAnnotation.getPObjectReference();
            for (AnnotationComponent annotationComponent : arrayList) {
                Reference reference2 = annotationComponent.getAnnotation().getPObjectReference();
                if (reference2 == null || !reference2.equals((Object)reference)) continue;
                if (!(annotationComponent instanceof MarkupAnnotationComponent)) break;
                return (MarkupAnnotationComponent)annotationComponent;
            }
        }
        return null;
    }

    private void addGB(JComponent jComponent, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jComponent.add(component, this.constraints);
    }

    private boolean buildCommentTree(MarkupAnnotation markupAnnotation, List<Annotation> list, DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = this.checkForIRT(markupAnnotation, list);
        MarkupAnnotationTreeNode markupAnnotationTreeNode = new MarkupAnnotationTreeNode(markupAnnotation);
        defaultMutableTreeNode.add(markupAnnotationTreeNode);
        if (!bl) {
            return false;
        }
        this.buildRecursiveCommentTree(markupAnnotationTreeNode, list);
        return true;
    }

    private void buildRecursiveCommentTree(DefaultMutableTreeNode defaultMutableTreeNode, List<Annotation> list) {
        MarkupAnnotation markupAnnotation = (MarkupAnnotation)defaultMutableTreeNode.getUserObject();
        Reference reference = markupAnnotation.getPObjectReference();
        for (Annotation annotation : list) {
            MarkupAnnotation markupAnnotation2;
            MarkupAnnotation markupAnnotation3;
            if (!(annotation instanceof MarkupAnnotation) || (markupAnnotation3 = (markupAnnotation2 = (MarkupAnnotation)annotation).getInReplyToAnnotation()) == null || !markupAnnotation3.getPObjectReference().equals((Object)reference)) continue;
            defaultMutableTreeNode.add(new MarkupAnnotationTreeNode(markupAnnotation2));
            this.selectedMarkupAnnotation = markupAnnotation2;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.buildRecursiveCommentTree((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), list);
        }
    }

    private void removeMarkupInReplyTo(Reference reference) {
        if (reference != null) {
            ArrayList<AbstractAnnotationComponent> arrayList = this.pageViewComponent.getAnnotationComponents();
            for (int i = 0; i < arrayList.size(); ++i) {
                MarkupAnnotationComponent markupAnnotationComponent;
                MarkupAnnotation markupAnnotation;
                AnnotationComponent annotationComponent = arrayList.get(i);
                if (!(annotationComponent instanceof MarkupAnnotationComponent) || (markupAnnotation = (MarkupAnnotation)(markupAnnotationComponent = (MarkupAnnotationComponent)annotationComponent).getAnnotation()).getInReplyToAnnotation() == null || !markupAnnotation.getInReplyToAnnotation().getPObjectReference().equals((Object)reference)) continue;
                this.removeMarkupInReplyTo(markupAnnotation.getPObjectReference());
                this.documentViewController.deleteAnnotation(markupAnnotationComponent);
            }
        }
    }

    private boolean checkForIRT(MarkupAnnotation markupAnnotation, List<Annotation> list) {
        if (markupAnnotation != null && list != null) {
            Reference reference = markupAnnotation.getPObjectReference();
            for (Annotation annotation : list) {
                MarkupAnnotation markupAnnotation2;
                MarkupAnnotation markupAnnotation3;
                if (!(annotation instanceof MarkupAnnotation) || (markupAnnotation3 = (markupAnnotation2 = (MarkupAnnotation)annotation).getInReplyToAnnotation()) == null || !markupAnnotation3.getPObjectReference().equals((Object)reference)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAnnotationComponent(Annotation annotation) {
        Rectangle rectangle = new Rectangle(-20, -20, 20, 20);
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent);
        markupAnnotationComponent.setBounds(rectangle);
        markupAnnotationComponent.refreshAnnotationRect();
        markupAnnotationComponent.setVisible(false);
        markupAnnotationComponent.getPopupAnnotationComponent().setVisible(false);
        this.documentViewController.addNewAnnotation(markupAnnotationComponent);
    }

    protected AnnotationComponent findAnnotationComponent(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        return this.pageViewComponent.getComponentFor(annotation);
    }

    protected void resetComponentColors() {
        Color color = ((PopupAnnotation)this.annotation).calculateContrastHighLowColor(this.popupBackgroundColor.getRGB());
        this.minimizeButton.setForeground(color);
        this.minimizeButton.setBackground(this.popupBackgroundColor);
        this.minimizeButton.setBackground(this.popupBackgroundColor);
        this.privateToggleButton.setBackground(this.popupBackgroundColor);
        Icon icon = Images.getSingleIcon("lock", IconPack.Variant.NONE, Images.IconSize.TINY);
        Icon icon2 = Images.getSingleIcon("unlock", IconPack.Variant.NONE, Images.IconSize.TINY);
        this.privateToggleButton.setIcon(icon2);
        this.privateToggleButton.setPressedIcon(null);
        this.privateToggleButton.setSelectedIcon(icon);
        this.privateToggleButton.setRolloverIcon(icon2);
        this.privateToggleButton.setRolloverSelectedIcon(icon);
        this.titleLabel.setForeground(color);
        this.creationLabel.setForeground(color);
    }

    @Override
    public void resetAppearanceShapes() {
        MarkupAnnotation markupAnnotation = ((PopupAnnotation)this.annotation).getParent();
        if (markupAnnotation.getColor() != null) {
            Color color;
            this.popupBackgroundColor = color = this.checkColor(markupAnnotation.getColor());
            this.minimizeButton.setBackground(color);
            this.privateToggleButton.setBackground(color);
            this.commentPanel.setBackground(color);
            this.resetComponentColors();
        }
        if (this.contextMenu != null) {
            ((MarkupAnnotationPopupMenu)this.contextMenu).refreshColorMenu();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            DataFlavor[] dataFlavorArray;
            if (!this.isDropAcceptable(dropTargetDropEvent)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(1);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
                if (!dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
                List list = (List)transferable.getTransferData(dataFlavor);
                for (Object e : list) {
                    File file = (File)e;
                    AnnotationFileDropHandler annotationFileDropHandler = AnnotationFileDropHandler.getInstance();
                    annotationFileDropHandler.handlePopupAnnotationFileDrop(file, this);
                }
            }
            dropTargetDropEvent.dropComplete(true);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "IO exception during file drop", iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            logger.log(Level.FINE, "Drag and drop not supported", unsupportedFlavorException);
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return (dropTargetDragEvent.getDropAction() & 3) != 0;
    }

    private boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
        return (dropTargetDropEvent.getDropAction() & 3) != 0;
    }

    private Color checkColor(Color color) {
        return color;
    }

    protected Color calculateContrastColor(int n) {
        int n2 = 120;
        if (Math.abs((n & 0xFF) - 128) <= n2 && Math.abs((n >> 8 & 0xFF) - 128) <= n2 && Math.abs((n >> 16 & 0xFF) - 128) <= n2) {
            return new Color(0x7F7F7F + n & 0xFFFFFF);
        }
        return new Color(n ^ 0xFFFFFF);
    }

    public void setTextAreaFontSize(float f) {
        float f2 = ((PopupAnnotation)this.annotation).getTextAreaFontsize();
        ((PopupAnnotation)this.annotation).setTextAreaFontsize(f);
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        PopupAnnotation.updateTextAreaFontSize((Component)this.textArea, (float)f2, (float)documentViewModel.getViewZoom());
    }

    public void setHeaderLabelsFontSize(float f) {
        float f2 = ((PopupAnnotation)this.annotation).getHeaderLabelsFontSize();
        ((PopupAnnotation)this.annotation).setHeaderLabelsFontSize(f);
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        PopupAnnotation.updateTextAreaFontSize((Component)this.titleLabel, (float)f2, (float)documentViewModel.getViewZoom());
        PopupAnnotation.updateTextAreaFontSize((Component)this.creationLabel, (float)f2, (float)documentViewModel.getViewZoom());
    }

    public void changeFontSize(float f) {
        this.setTextAreaFontSize(((PopupAnnotation)this.annotation).getTextAreaFontsize() + f);
        this.setHeaderLabelsFontSize(((PopupAnnotation)this.annotation).getHeaderLabelsFontSize() + f);
    }

    public MarkupGlueComponent getMarkupGlueComponent() {
        return this.markupGlueComponent;
    }

    public void setMarkupGlueComponent(MarkupGlueComponent markupGlueComponent) {
        this.markupGlueComponent = markupGlueComponent;
    }

    public void setFontSize(float f) {
        this.setTextAreaFontSize(f);
        this.setHeaderLabelsFontSize(f);
    }

    public int getTextAreaFontSize() {
        return this.textArea.getFont().getSize();
    }

    public int getHeaderFontSize() {
        return this.titleLabel.getFont().getSize();
    }

    private static class MarkupAnnotationTreeNode
    extends DefaultMutableTreeNode {
        private MarkupAnnotationTreeNode(MarkupAnnotation markupAnnotation) {
            super(markupAnnotation);
        }

        @Override
        public String toString() {
            MarkupAnnotation markupAnnotation = (MarkupAnnotation)this.userObject;
            if (markupAnnotation != null) {
                return markupAnnotation.getTitleText() + " - " + markupAnnotation.getContents();
            }
            return "";
        }

        @Override
        public MarkupAnnotationTreeNode clone() {
            return (MarkupAnnotationTreeNode)super.clone();
        }
    }

    class PopupTreeListener
    extends MouseAdapter {
        PopupTreeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n = PopupAnnotationComponent.this.commentTree.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                PopupAnnotationComponent.this.commentTree.setSelectionRow(n);
                PopupAnnotationComponent.this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

