/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupGluePainter;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PageViewAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class MarkupGlueComponent
extends JComponent
implements PageViewAnnotationComponent,
ComponentListener {
    protected final MarkupAnnotationComponent markupAnnotationComponent;
    protected final PopupAnnotationComponent popupAnnotationComponent;
    protected Rectangle adjustedMarkupAnnotationBounds;
    private final DocumentViewController documentViewController;
    protected AbstractPageViewComponent parentPageViewComponent;

    public MarkupGlueComponent(DocumentViewController documentViewController, MarkupAnnotationComponent markupAnnotationComponent, PopupAnnotationComponent popupAnnotationComponent) {
        this.documentViewController = documentViewController;
        this.markupAnnotationComponent = markupAnnotationComponent;
        this.popupAnnotationComponent = popupAnnotationComponent;
        this.popupAnnotationComponent.addComponentListener(this);
        this.popupAnnotationComponent.setMarkupGlueComponent(this);
    }

    public void dispose() {
        if (this.popupAnnotationComponent != null) {
            this.popupAnnotationComponent.removeComponentListener(this);
        }
    }

    public PopupAnnotationComponent getPopupAnnotationComponent() {
        return this.popupAnnotationComponent;
    }

    private Rectangle recalculateAnnotationBounds() {
        Page page = this.parentPageViewComponent.getPage();
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        AffineTransform affineTransform = page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        Rectangle2D.Float float_ = this.markupAnnotationComponent.getAnnotation().getUserSpaceRectangle();
        Rectangle rectangle = Annotation.commonBoundsNormalization((GeneralPath)new GeneralPath(float_), (AffineTransform)affineTransform);
        Rectangle rectangle2 = this.parentPageViewComponent.getParent().getBounds();
        rectangle.x += rectangle2.x;
        rectangle.y += rectangle2.y;
        return rectangle;
    }

    @Override
    public void refreshDirtyBounds() {
        this.adjustedMarkupAnnotationBounds = this.recalculateAnnotationBounds();
        Rectangle rectangle = this.popupAnnotationComponent.getBounds();
        Rectangle rectangle2 = this.adjustedMarkupAnnotationBounds;
        Rectangle rectangle3 = rectangle2.union(rectangle);
        this.setBounds(rectangle3);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.popupAnnotationComponent.isVisible()) {
            Rectangle rectangle = this.popupAnnotationComponent.getBounds();
            Rectangle rectangle2 = this.adjustedMarkupAnnotationBounds;
            MarkupGluePainter.paintGlue((Graphics)graphics, (Rectangle)rectangle2, (Rectangle)rectangle, (Rectangle)this.getBounds(), (Color)this.markupAnnotationComponent.getAnnotation().getColor());
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.refreshDirtyBounds();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void setParentPageComponent(AbstractPageViewComponent abstractPageViewComponent) {
        this.parentPageViewComponent = abstractPageViewComponent;
    }

    public MarkupAnnotationComponent getMarkupAnnotationComponent() {
        return this.markupAnnotationComponent;
    }
}

