/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Arrays;
import org.icepdf.ri.common.views.BasePageViewLayout;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewDecorator;

public class OnePageViewLayout
extends BasePageViewLayout
implements LayoutManager2 {
    protected int minWidth = 0;
    protected int minHeight = 0;
    protected int preferredWidth = 0;
    protected int preferredHeight = 0;
    protected boolean sizeUnknown = true;

    public OnePageViewLayout(DocumentViewModel documentViewModel) {
        super(documentViewModel);
    }

    @Override
    public void layoutContainer(Container container) {
        PageViewDecorator[] pageViewDecoratorArray;
        Insets insets = container.getInsets();
        int n = container.getWidth() - (insets.left + insets.right);
        int n2 = container.getHeight() - (insets.top + insets.bottom);
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        for (PageViewDecorator pageViewDecorator : pageViewDecoratorArray = (PageViewDecorator[])Arrays.stream(container.getComponents()).filter(component -> component instanceof PageViewDecorator && component.isVisible()).toArray(PageViewDecorator[]::new)) {
            Dimension dimension = pageViewDecorator.getPreferredSize();
            int n3 = (n - dimension.width) / 2;
            int n4 = (n2 - dimension.height) / 2;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            pageViewDecorator.setBounds(n3 += insets.left, n4 += insets.top, dimension.width, dimension.height);
            this.updatePopupAnnotationComponents(pageViewDecorator);
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        this.setSizes(container);
        Insets insets = container.getInsets();
        dimension.width = this.preferredWidth + insets.left + insets.right;
        dimension.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width = this.minWidth + insets.left + insets.right;
        dimension.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dimension;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return null;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    protected void setSizes(Container container) {
        PageViewDecorator[] pageViewDecoratorArray;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        for (PageViewDecorator pageViewDecorator : pageViewDecoratorArray = (PageViewDecorator[])Arrays.stream(container.getComponents()).filter(component -> component instanceof PageViewDecorator && component.isVisible()).toArray(PageViewDecorator[]::new)) {
            Dimension dimension = pageViewDecorator.getPreferredSize();
            this.preferredWidth = dimension.width;
            this.preferredHeight += dimension.height + 2;
            this.minWidth = Math.max(pageViewDecorator.getMinimumSize().width, this.minWidth);
            this.minHeight = this.preferredHeight;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

