/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import org.icepdf.core.CombinedMemento;
import org.icepdf.core.Memento;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.NamedDestinations;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.CollectionDocumentView;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.FullScreenDocumentView;
import org.icepdf.ri.common.views.OneColumnPageView;
import org.icepdf.ri.common.views.OnePageView;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.TwoColumnPageView;
import org.icepdf.ri.common.views.TwoPageView;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationState;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.destinations.DestinationComponent;
import org.icepdf.ri.images.Images;

public class DocumentViewControllerImpl
implements DocumentViewController,
ComponentListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DocumentViewControllerImpl.class.toString());
    private static final Pattern MULTI_SPACE_PATTERN = Pattern.compile(" +");
    private static final Pattern DASH_NEWLINE_PATTERN = Pattern.compile("- *\n");
    public static final int ONE_PAGE_VIEW = 1;
    public static final int ONE_COLUMN_VIEW = 2;
    public static final int TWO_PAGE_LEFT_VIEW = 3;
    public static final int TWO_COLUMN_LEFT_VIEW = 4;
    public static final int TWO_PAGE_RIGHT_VIEW = 5;
    public static final int TWO_COLUMN_RIGHT_VIEW = 6;
    public static final int USE_ATTACHMENTS_VIEW = 7;
    public static final int FULL_SCREEN_VIEW = 8;
    public static final float ZOOM_FACTOR = 1.2f;
    public static final float ROTATION_FACTOR = 90.0f;
    protected float[] zoomLevels;
    protected Document document;
    protected DocumentViewModel documentViewModel;
    protected DocumentView documentView;
    protected final JScrollPane documentViewScrollPane;
    protected int viewType;
    protected int oldViewType;
    protected int viewportFitMode;
    protected int cursorType;
    protected final SwingController viewerController;
    protected AnnotationCallback annotationCallback;
    protected SecurityCallback securityCallback;
    protected final PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public DocumentViewControllerImpl(final SwingController swingController) {
        this.viewerController = swingController;
        this.documentViewScrollPane = new JScrollPane();
        this.documentViewScrollPane.getViewport().setBackground(AbstractDocumentView.backgroundColour);
        this.documentViewScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.documentViewScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DocumentViewControllerImpl.this.documentViewModel != null) {
                    DocumentViewControllerImpl.this.deleteCurrentAnnotation();
                    swingController.reflectUndoCommands();
                }
            }
        };
        InputMap inputMap = this.documentViewScrollPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "removeSelectedAnnotation");
        this.documentViewScrollPane.getActionMap().put("removeSelectedAnnotation", abstractAction);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.dispose();
        }
        this.document = document;
        if (this.documentViewModel != null) {
            this.documentViewModel.dispose();
            this.documentViewModel = null;
        }
        this.documentViewModel = this.createDocumentViewMode(this.document);
        if (this.document != null) {
            this.setViewType();
            this.documentViewScrollPane.addComponentListener(this);
            this.documentViewScrollPane.validate();
        }
    }

    protected DocumentViewModel createDocumentViewMode(Document document) {
        return new DocumentViewModelImpl(document);
    }

    @Override
    public void closeDocument() {
        this.documentViewScrollPane.removeComponentListener(this);
        if (this.documentView != null) {
            this.documentView.uninstallCurrentTool();
            this.documentViewScrollPane.remove((JComponent)((Object)this.documentView));
            this.documentView.dispose();
            this.documentView = null;
        }
        if (this.documentViewModel != null) {
            this.documentViewModel.dispose();
            this.documentViewModel = null;
        }
        this.setFitMode(1);
        this.setCurrentPageIndex(0);
        this.setZoom(1.0f);
        this.setRotation(0.0f);
        this.setViewCursor(8);
    }

    @Override
    public Adjustable getHorizontalScrollBar() {
        return this.documentViewScrollPane.getHorizontalScrollBar();
    }

    @Override
    public Adjustable getVerticalScrollBar() {
        return this.documentViewScrollPane.getVerticalScrollBar();
    }

    @Override
    public JViewport getViewPort() {
        return this.documentViewScrollPane.getViewport();
    }

    @Override
    public void setAnnotationCallback(AnnotationCallback annotationCallback) {
        this.annotationCallback = annotationCallback;
    }

    @Override
    public void setSecurityCallback(SecurityCallback securityCallback) {
        this.securityCallback = securityCallback;
    }

    @Override
    public void clearSelectedAnnotations() {
        if (this.documentViewModel.getCurrentAnnotation() != null) {
            this.documentViewModel.getCurrentAnnotation().setSelected(false);
            this.firePropertyChange("annotationDeselected", this.documentViewModel.getCurrentAnnotation(), null);
            this.documentViewModel.setCurrentAnnotation(null);
        }
    }

    @Override
    public void assignSelectedAnnotation(AnnotationComponent annotationComponent) {
        this.firePropertyChange("annotationSelected", this.documentViewModel.getCurrentAnnotation(), annotationComponent);
        this.documentViewModel.setCurrentAnnotation(annotationComponent);
    }

    @Override
    public void clearSelectedText() {
        ArrayList<AbstractPageViewComponent> arrayList = this.documentViewModel.getSelectedPageText();
        this.documentViewModel.setSelectAll(false);
        if (arrayList != null && arrayList.size() > 0) {
            for (AbstractPageViewComponent abstractPageViewComponent : arrayList) {
                if (!(abstractPageViewComponent instanceof PageViewComponentImpl)) continue;
                abstractPageViewComponent.clearSelectedText();
            }
            arrayList.clear();
            this.documentView.repaint();
        }
        this.firePropertyChange("textDeselected", null, null);
    }

    @Override
    public void clearHighlightedText() {
        DocumentSearchController documentSearchController = this.viewerController.getDocumentSearchController();
        documentSearchController.clearAllSearchHighlight();
        this.documentView.repaint();
    }

    @Override
    public void selectAllText() {
        this.documentViewModel.setSelectAll(true);
        this.documentView.repaint();
        this.firePropertyChange("textSelectAll", null, null);
    }

    public String getFlatSelectedText() {
        String string = this.getSelectedText();
        return MULTI_SPACE_PATTERN.matcher(DASH_NEWLINE_PATTERN.matcher(string).replaceAll("").replace("\n", " ")).replaceAll(" ");
    }

    @Override
    public String getSelectedText() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (!this.documentViewModel.isSelectAll()) {
                ArrayList<AbstractPageViewComponent> arrayList = this.documentViewModel.getSelectedPageText();
                if (arrayList != null && arrayList.size() > 0) {
                    for (AbstractPageViewComponent abstractPageViewComponent : arrayList) {
                        if (abstractPageViewComponent == null) continue;
                        int n = abstractPageViewComponent.getPageIndex();
                        stringBuilder.append((CharSequence)this.document.getPageText(n).getSelected());
                    }
                }
            } else {
                Document document = this.documentViewModel.getDocument();
                for (int i = 0; i < document.getNumberOfPages(); ++i) {
                    stringBuilder.append(this.viewerController.getDocument().getPageText(i));
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.SEVERE, "Page text extraction thread interrupted.", interruptedException);
        }
        return stringBuilder.toString();
    }

    @Override
    public AnnotationCallback getAnnotationCallback() {
        return this.annotationCallback;
    }

    @Override
    public SecurityCallback getSecurityCallback() {
        return this.securityCallback;
    }

    @Override
    public DocumentView getDocumentView() {
        return this.documentView;
    }

    @Override
    public synchronized void setViewKeyListener(KeyListener keyListener) {
        if (this.documentView != null) {
            ((JComponent)((Object)this.documentView)).addKeyListener(keyListener);
        }
    }

    @Override
    public void setComponentTarget(PageViewComponent pageViewComponent, Component component) {
        if (this.documentView == null || this.documentViewModel == null) {
            return;
        }
        Page page = this.getPageTree().getPage(pageViewComponent.getPageIndex());
        Point point = component.getLocation();
        Point2D.Float float_ = page.convertToPageSpace(point, this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        Destination destination = new Destination(page, (int)float_.x, (int)float_.y);
        this.setDestinationTarget(destination);
    }

    @Override
    public void setDestinationTarget(Destination destination) {
        JViewport jViewport;
        Destination destination2;
        if (this.documentView == null || this.documentViewModel == null) {
            return;
        }
        NamedDestinations namedDestinations = this.document.getCatalog().getDestinations();
        if (namedDestinations != null && (destination2 = namedDestinations.getDestination(destination.getNamedDestination())) != null) {
            destination = destination2;
        }
        if (destination == null || destination.getPageReference() == null) {
            return;
        }
        int n = -1;
        if (this.getPageTree() != null) {
            n = this.getPageTree().getPageNumber(destination.getPageReference());
        }
        if (n < 0) {
            return;
        }
        JViewport jViewport2 = jViewport = this.documentViewScrollPane != null ? this.documentViewScrollPane.getViewport() : null;
        if (jViewport != null) {
            Rectangle rectangle = this.documentViewModel.getPageBounds(n);
            if (this.documentViewModel.getViewRotation() == 0.0f && rectangle != null) {
                this.setCurrentPageIndex(n);
                if (destination.getZoom() != null && destination.getZoom().floatValue() > 0.0f) {
                    this.setZoomCentered(destination.getZoom().floatValue(), null, false);
                }
                Point point = new Point(rectangle.getLocation());
                float f = this.getZoom();
                Rectangle rectangle2 = ((JComponent)((Object)this.documentView)).getBounds();
                Rectangle rectangle3 = jViewport.getViewRect();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("viewPort bounds " + rectangle2);
                    logger.finer("viewPort rect " + rectangle3);
                    logger.finer("page bounds " + rectangle);
                    logger.finer("page " + n);
                    logger.finer("top/left " + destination.getTop() + " " + destination.getLeft());
                }
                if (destination.getTop() != null && destination.getTop().floatValue() != 0.0f) {
                    point.y = rectangle.y + rectangle.height - (int)(destination.getTop().floatValue() * f);
                }
                if (point.y + rectangle3.height > rectangle2.height) {
                    point.y = rectangle2.height - rectangle3.height;
                }
                if (destination.getLeft() != null && destination.getLeft().floatValue() != 0.0f) {
                    point.x = rectangle.x + (int)(destination.getLeft().floatValue() * f);
                }
                if (point.x + rectangle3.width > rectangle2.width) {
                    point.x = rectangle2.width - rectangle3.width;
                }
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                jViewport.setViewPosition(point);
                int n2 = this.documentViewModel.getViewCurrentPageIndex();
                this.documentViewModel.setViewCurrentPageIndex(n);
                this.firePropertyChange("documentCurrentPage", n2, n);
            } else {
                this.setCurrentPageIndex(n);
            }
            this.viewerController.updateDocumentView();
        }
    }

    @Override
    public void dispose() {
        if (this.documentView != null) {
            this.documentView.dispose();
            this.documentView = null;
        }
        if (this.documentViewModel != null) {
            this.documentViewModel.dispose();
            this.documentViewModel = null;
        }
    }

    @Override
    public Container getViewContainer() {
        return this.documentViewScrollPane;
    }

    @Override
    public Controller getParentController() {
        return this.viewerController;
    }

    @Override
    public int getViewMode() {
        return this.viewType;
    }

    @Override
    public void setViewType(int n) {
        this.viewType = n;
        if (this.oldViewType != this.viewType) {
            this.setViewType();
            this.oldViewType = this.viewType != 8 ? this.viewType : this.oldViewType;
            this.firePropertyChange("documentViewTypeChange", this.oldViewType, this.viewType);
        }
    }

    @Override
    public void revertViewType() {
        this.viewType = this.oldViewType;
        this.oldViewType = -1;
        this.setViewType(this.viewType);
        this.viewerController.setPageViewMode(this.viewType, true);
    }

    protected void setViewType() {
        if (this.documentView != null) {
            this.documentView.uninstallCurrentTool();
            ((JComponent)((Object)this.documentView)).removePropertyChangeListener(this);
            this.documentViewScrollPane.remove((JComponent)((Object)this.documentView));
            this.documentViewScrollPane.validate();
            this.documentView.dispose();
        }
        if (this.documentViewModel == null) {
            return;
        }
        this.createDocumentView(this.viewType);
        this.documentView.setToolMode(this.documentViewModel.getViewToolMode());
        if (this.viewType != 8) {
            this.documentViewScrollPane.setViewportView((Component)((Object)this.documentView));
            this.documentViewScrollPane.validate();
        } else {
            ((FullScreenDocumentView)this.documentView).display();
        }
        this.viewerController.setPageFitMode(this.viewportFitMode, true);
        this.setCurrentPageIndex(this.documentViewModel.getViewCurrentPageIndex());
    }

    protected void createDocumentView(int n) {
        this.documentView = n == 2 ? new OneColumnPageView(this, this.documentViewScrollPane, this.documentViewModel) : (n == 1 ? new OnePageView(this, this.documentViewScrollPane, this.documentViewModel) : (n == 4 ? new TwoColumnPageView(this, this.documentViewScrollPane, this.documentViewModel, 0) : (n == 3 ? new TwoPageView(this, this.documentViewScrollPane, this.documentViewModel, 0) : (n == 6 ? new TwoColumnPageView(this, this.documentViewScrollPane, this.documentViewModel, 1) : (n == 5 ? new TwoPageView(this, this.documentViewScrollPane, this.documentViewModel, 1) : (n == 7 ? new CollectionDocumentView(this, this.documentViewScrollPane, this.documentViewModel) : (n == 8 ? new FullScreenDocumentView(this) : new OneColumnPageView(this, this.documentViewScrollPane, this.documentViewModel))))))));
        ((JComponent)((Object)this.documentView)).addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.documentView != null) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if ("documentViewRefreshChange".equals(string) || "documentViewZoomChange".equals(string) || "documentViewRotationChange".equals(string)) {
                List<AbstractPageViewComponent> list = this.documentViewModel.getPageComponents();
                for (AbstractPageViewComponent abstractPageViewComponent : list) {
                    abstractPageViewComponent.updateView(string, object2, object);
                }
            }
        }
    }

    @Override
    public boolean setFitMode(int n) {
        if (this.documentViewModel == null || this.viewType == 7) {
            return false;
        }
        boolean bl = n != this.viewportFitMode;
        this.viewportFitMode = n;
        if (this.document != null) {
            float f = this.documentViewModel.getViewZoom();
            if (this.viewportFitMode == 2) {
                f = 1.0f;
            } else if (this.viewportFitMode == 3) {
                if (this.documentView != null && this.documentViewScrollPane != null) {
                    float f2 = this.documentViewScrollPane.getViewport().getViewRect().height;
                    float f3 = this.documentView.getDocumentSize().height;
                    f = f2 > 0.0f ? f2 / (f3 += 4.0f) : 1.0f;
                }
            } else if (this.viewportFitMode == 4 && this.documentView != null && this.documentViewScrollPane != null) {
                float f4 = this.documentViewScrollPane.getViewport().getViewRect().width;
                float f5 = this.documentView.getDocumentSize().width;
                if (!this.documentViewScrollPane.getVerticalScrollBar().isVisible()) {
                    f4 -= (float)this.documentViewScrollPane.getVerticalScrollBar().getWidth();
                }
                f = f4 > 0.0f ? f4 / (f5 += 4.0f) : 1.0f;
            }
            if (this.getVerticalScrollBar().getValue() == 0) {
                this.setZoomCentered(f, new Point(0, 0), true);
            } else {
                this.setZoomCentered(f, null, true);
            }
        }
        return bl;
    }

    @Override
    public int getFitMode() {
        return this.viewportFitMode;
    }

    @Override
    public void setDocumentViewType(int n, int n2) {
        this.setViewType(n);
        this.setFitMode(n2);
    }

    @Override
    public boolean setCurrentPageIndex(int n) {
        Rectangle rectangle;
        if (this.documentViewModel == null) {
            return false;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this.document.getNumberOfPages() - 1) {
            n = this.document.getNumberOfPages() - 1;
        }
        int n2 = this.documentViewModel.getViewCurrentPageIndex();
        boolean bl = this.documentViewModel.setViewCurrentPageIndex(n);
        if (this.documentView != null) {
            this.documentView.updateDocumentView();
        }
        if ((rectangle = this.documentViewModel.getPageBounds(this.getCurrentPageIndex())) != null) {
            Rectangle rectangle2 = ((JComponent)((Object)this.documentView)).getBounds();
            if (rectangle.x + rectangle.width > rectangle2.width) {
                rectangle.x = rectangle2.width - rectangle.width;
            }
            if (rectangle.y + rectangle.height > rectangle2.height) {
                rectangle.y = rectangle2.height - rectangle.height;
            }
            this.documentViewScrollPane.getViewport().setViewPosition(rectangle.getLocation());
            this.documentViewScrollPane.revalidate();
        }
        this.firePropertyChange("documentCurrentPage", n2, n);
        return bl;
    }

    @Override
    public int setCurrentPageNext() {
        int n = 0;
        if (this.documentViewModel != null) {
            n = this.documentView.getNextPageIncrement();
            int n2 = this.documentViewModel.getViewCurrentPageIndex();
            if (n2 + n < this.document.getNumberOfPages()) {
                this.documentViewModel.setViewCurrentPageIndex(n2 + n);
            } else {
                this.documentViewModel.setViewCurrentPageIndex(this.document.getNumberOfPages() - 1);
            }
        }
        return n;
    }

    @Override
    public int setCurrentPagePrevious() {
        int n = 0;
        if (this.documentViewModel != null) {
            n = this.documentView.getPreviousPageIncrement();
            int n2 = this.documentViewModel.getViewCurrentPageIndex();
            this.documentViewModel.setViewCurrentPageIndex(Math.max(n2 - n, 0));
        }
        return n;
    }

    @Override
    public int getCurrentPageIndex() {
        if (this.documentViewModel == null) {
            return -1;
        }
        return this.documentViewModel.getViewCurrentPageIndex();
    }

    @Override
    public int getCurrentPageDisplayValue() {
        if (this.documentViewModel == null) {
            return -1;
        }
        return this.documentViewModel.getViewCurrentPageIndex() + 1;
    }

    @Override
    public float[] getZoomLevels() {
        return this.zoomLevels;
    }

    @Override
    public void setZoomLevels(float[] fArray) {
        this.zoomLevels = fArray;
    }

    @Override
    public boolean setZoom(float f) {
        return this.setZoomCentered(f, null, false);
    }

    @Override
    public boolean setZoomIn() {
        return this.setZoomIn(null);
    }

    @Override
    public boolean setZoomOut() {
        return this.setZoomOut(null);
    }

    @Override
    public float getZoom() {
        if (this.documentViewModel != null) {
            return this.documentViewModel.getViewZoom();
        }
        return 0.0f;
    }

    @Override
    public float getRotation() {
        if (this.documentViewModel == null) {
            return -1.0f;
        }
        return this.documentViewModel.getViewRotation();
    }

    @Override
    public float setRotateRight() {
        if (this.documentViewModel == null) {
            return -1.0f;
        }
        float f = this.documentViewModel.getViewRotation();
        if ((f -= 90.0f) < 0.0f) {
            f += 360.0f;
        }
        this.setRotation(f);
        return f;
    }

    @Override
    public float setRotateLeft() {
        if (this.documentViewModel == null) {
            return -1.0f;
        }
        float f = this.documentViewModel.getViewRotation();
        f += 90.0f;
        this.setRotation(f %= 360.0f);
        return f;
    }

    @Override
    public boolean setRotation(float f) {
        if (this.documentViewModel == null) {
            return false;
        }
        float f2 = this.documentViewModel.getViewRotation();
        boolean bl = this.documentViewModel.setViewRotation(f);
        if (bl) {
            this.firePropertyChange("documentViewRotationChange", Float.valueOf(f2), Float.valueOf(f));
            ((JComponent)((Object)this.documentView)).invalidate();
            ((JComponent)((Object)this.documentView)).firePropertyChange("documentViewRotationChange", f2, f);
            ((JComponent)((Object)this.documentView)).revalidate();
        }
        return bl;
    }

    @Override
    public boolean setToolMode(int n) {
        if (this.documentViewModel != null) {
            boolean bl = this.documentViewModel.setViewToolMode(n);
            if (bl) {
                if (this.documentView != null) {
                    this.documentView.setToolMode(n);
                }
                List<AbstractPageViewComponent> list = this.documentViewModel.getPageComponents();
                for (AbstractPageViewComponent abstractPageViewComponent : list) {
                    ((PageViewComponentImpl)abstractPageViewComponent).setToolMode(n);
                }
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean isToolModeSelected(int n) {
        return this.getToolMode() == n;
    }

    @Override
    public int getToolMode() {
        if (this.documentViewModel == null) {
            return 50;
        }
        return this.documentViewModel.getViewToolMode();
    }

    @Override
    public void setViewCursor(int n) {
        this.cursorType = n;
        Cursor cursor = this.getViewCursor(n);
        if (this.documentViewModel != null && this.documentViewModel.getDocumentViewScrollPane() != null && this.documentViewModel.getDocumentViewScrollPane().getViewport() != null) {
            this.documentViewModel.getDocumentViewScrollPane().getViewport().setCursor(cursor);
        }
    }

    @Override
    public int getViewCursor() {
        return this.cursorType;
    }

    @Override
    public Cursor getViewCursor(int n) {
        Cursor cursor;
        String string;
        if (n == 8) {
            return Cursor.getPredefinedCursor(0);
        }
        if (n == 6) {
            return Cursor.getPredefinedCursor(3);
        }
        if (n == 7) {
            return Cursor.getPredefinedCursor(0);
        }
        if (n == 1) {
            string = "hand_open.gif";
        } else if (n == 2) {
            string = "hand_closed.gif";
        } else if (n == 3) {
            string = "zoom_in.gif";
        } else if (n == 4) {
            string = "zoom_out.gif";
        } else if (n == 12) {
            string = "zoom.gif";
        } else {
            if (n == 9) {
                return Cursor.getPredefinedCursor(12);
            }
            if (n == 10) {
                return Cursor.getPredefinedCursor(2);
            }
            if (n == 11) {
                return Cursor.getPredefinedCursor(1);
            }
            return Cursor.getPredefinedCursor(0);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(24, 24);
        if (dimension.width != 0) {
            Point point = new Point(12, 12);
            try {
                ImageIcon imageIcon = new ImageIcon(Images.get(string));
                cursor = toolkit.createCustomCursor(imageIcon.getImage(), point, string);
            }
            catch (RuntimeException runtimeException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Trying to load image: " + string, runtimeException);
                }
                throw runtimeException;
            }
        } else {
            cursor = Cursor.getDefaultCursor();
            logger.warning("System does not support custom cursors");
        }
        return cursor;
    }

    @Override
    public void requestViewFocusInWindow() {
        if (this.documentViewScrollPane != null) {
            this.documentViewScrollPane.requestFocus();
        }
    }

    @Override
    public boolean setZoomIn(Point point) {
        float f = this.getZoom() * 1.2f;
        return this.setZoomCentered(f, point, false);
    }

    @Override
    public boolean setZoomOut(Point point) {
        float f = this.getZoom() / 1.2f;
        return this.setZoomCentered(f, point, false);
    }

    private void zoomCenter(Point point, float f, float f2) {
        if (point == null) {
            point = this.getCenteringPoint();
        }
        if (point == null || this.documentViewScrollPane == null) {
            return;
        }
        int n = this.documentViewScrollPane.getViewport().getWidth();
        int n2 = this.documentViewScrollPane.getViewport().getHeight();
        int n3 = this.documentViewScrollPane.getViewport().getViewPosition().x;
        int n4 = this.documentViewScrollPane.getViewport().getViewPosition().y;
        Dimension dimension = ((JComponent)((Object)this.documentView)).getPreferredSize();
        int n5 = dimension.width;
        int n6 = dimension.height;
        point.setLocation(point.x - n / 2, point.y - n2 / 2);
        if (n5 < n || n6 < n2) {
            if (point.x >= n5 - n || point.x < 0) {
                point.x = n3;
            }
            if (point.y >= n6 - n2 || point.y < 0) {
                point.y = n4;
            }
        } else {
            if (point.x + n > n5) {
                point.x = n5 - n;
            } else if (point.x < 0) {
                point.x = 0;
            }
            if (point.y + n2 > n6) {
                point.y = n6 - n2;
            } else if (point.y < 0) {
                point.y = 0;
            }
        }
        this.documentViewScrollPane.getViewport().setViewPosition(point);
        this.documentViewScrollPane.getViewport().setViewPosition(point);
    }

    @Override
    public boolean setZoomCentered(float f, Point point, boolean bl) {
        if (this.documentViewModel == null) {
            return false;
        }
        f = this.calculateZoom(f);
        if (point == null) {
            point = this.getCenteringPoint();
        }
        float f2 = this.getZoom();
        float f3 = this.documentViewModel.getViewZoom();
        boolean bl2 = this.documentViewModel.setViewZoom(f);
        if (bl2) {
            this.firePropertyChange("documentViewZoomChange", Float.valueOf(f3), Float.valueOf(f));
            ((JComponent)((Object)this.documentView)).firePropertyChange("documentViewZoomChange", f3, f);
            ((JComponent)((Object)this.documentView)).revalidate();
        }
        if (bl2 && point != null) {
            point.setLocation((float)point.x / f2 * f, (float)point.y / f2 * f);
        }
        this.zoomCenter(point, f2, f);
        if (this.viewerController != null) {
            this.viewerController.doCommonZoomUIUpdates(bl);
        }
        return bl2;
    }

    private float calculateZoom(float f) {
        if (this.zoomLevels != null) {
            if (f < this.zoomLevels[0]) {
                f = this.zoomLevels[0];
            } else if (f > this.zoomLevels[this.zoomLevels.length - 1]) {
                f = this.zoomLevels[this.zoomLevels.length - 1];
            }
        }
        return f;
    }

    @Override
    public boolean setZoomToViewPort(float f, Point point, int n, boolean bl) {
        if (this.documentViewModel == null) {
            return false;
        }
        f = this.calculateZoom(f);
        if (point == null) {
            point = new Point();
        }
        float f2 = this.getZoom();
        Rectangle rectangle = this.documentViewModel.getPageBounds(n);
        boolean bl2 = this.documentViewModel.setViewZoom(f);
        if (bl2) {
            this.firePropertyChange("documentViewZoomChange", Float.valueOf(f2), Float.valueOf(f));
            ((JComponent)((Object)this.documentView)).firePropertyChange("documentViewZoomChange", f2, f);
            this.documentViewScrollPane.invalidate();
            this.documentViewScrollPane.validate();
            this.documentViewScrollPane.getViewport().getView().invalidate();
            this.documentViewScrollPane.getViewport().getView().validate();
        }
        if (bl2) {
            Rectangle rectangle2 = this.documentViewModel.getPageBounds(n);
            double d = rectangle2.getWidth() / rectangle.getWidth();
            int n2 = (int)((double)point.x * d);
            int n3 = (int)((double)point.y * d);
            Point point2 = new Point(rectangle2.x + n2, rectangle2.y + n3);
            this.getViewPort().setViewPosition(point2);
            this.documentViewScrollPane.validate();
            rectangle2 = this.documentViewModel.getPageBounds(n);
            point2 = new Point(rectangle2.x + n2, rectangle2.y + n3);
            this.getViewPort().setViewPosition(point2);
        }
        if (this.viewerController != null) {
            this.viewerController.doCommonZoomUIUpdates(bl);
        }
        return bl2;
    }

    private Point getCenteringPoint() {
        Point point = null;
        if (this.documentViewScrollPane != null) {
            int n = this.documentViewScrollPane.getViewport().getViewPosition().x + this.documentViewScrollPane.getViewport().getWidth() / 2;
            int n2 = this.documentViewScrollPane.getViewport().getViewPosition().y + this.documentViewScrollPane.getViewport().getHeight() / 2;
            point = new Point(n, n2);
        }
        return point;
    }

    private PageTree getPageTree() {
        if (this.document == null) {
            return null;
        }
        return this.document.getPageTree();
    }

    @Override
    public DocumentViewModel getDocumentViewModel() {
        return this.documentViewModel;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.documentViewScrollPane) {
            this.setFitMode(this.getFitMode());
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
        this.changes.firePropertyChange(string, n, n2);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.changes.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void deleteCurrentAnnotation() {
        AbstractAnnotationComponent abstractAnnotationComponent = (AbstractAnnotationComponent)this.documentViewModel.getCurrentAnnotation();
        if (abstractAnnotationComponent != null && !(abstractAnnotationComponent instanceof PopupAnnotationComponent)) {
            this.deleteAnnotation(abstractAnnotationComponent);
        }
    }

    @Override
    public void addNewAnnotation(AnnotationComponent annotationComponent) {
        if (this.documentViewModel != null && annotationComponent != null) {
            PageViewComponent pageViewComponent = annotationComponent.getPageViewComponent();
            if (this.annotationCallback != null) {
                this.annotationCallback.newAnnotation(pageViewComponent, annotationComponent);
            }
            this.documentViewModel.addMemento(new AnnotationState(annotationComponent, AnnotationState.Operation.DELETE), new AnnotationState(annotationComponent, AnnotationState.Operation.ADD));
            this.firePropertyChange("annotationAdded", null, annotationComponent);
            this.assignSelectedAnnotation(null);
            this.documentView.repaint();
        }
    }

    @Override
    public void updateAnnotation(AnnotationComponent annotationComponent) {
        if (this.documentViewModel != null && annotationComponent != null) {
            annotationComponent.setSynthetic(false);
            if (this.annotationCallback != null) {
                this.annotationCallback.updateAnnotation(annotationComponent);
            }
            this.firePropertyChange("annotationUpdated", null, annotationComponent);
            this.documentView.repaint();
        }
    }

    @Override
    public void updatedSummaryAnnotation(AnnotationComponent annotationComponent) {
        if (this.documentViewModel != null && annotationComponent != null) {
            annotationComponent.setSynthetic(false);
            if (this.annotationCallback != null) {
                this.annotationCallback.updateAnnotation(annotationComponent);
            }
            this.firePropertyChange("annotationSummaryUpdated", null, annotationComponent);
            this.documentView.repaint();
        }
    }

    @Override
    public void deleteAnnotation(AnnotationComponent annotationComponent) {
        if (this.documentViewModel != null && annotationComponent != null) {
            PageViewComponent pageViewComponent = annotationComponent.getPageViewComponent();
            if (this.annotationCallback != null) {
                this.annotationCallback.removeAnnotation(pageViewComponent, annotationComponent);
            }
            this.documentViewModel.addMemento(new AnnotationState(annotationComponent, AnnotationState.Operation.ADD), new AnnotationState(annotationComponent, AnnotationState.Operation.DELETE));
            this.firePropertyChange("annotationDeleted", annotationComponent, null);
            this.assignSelectedAnnotation(null);
            this.documentView.repaint();
        }
    }

    @Override
    public void deleteAnnotations(Collection<AnnotationComponent> collection) {
        if (this.documentViewModel != null) {
            ArrayList arrayList = new ArrayList(collection.size());
            ArrayList arrayList2 = new ArrayList(collection.size());
            collection.forEach(annotationComponent -> {
                PageViewComponent pageViewComponent = annotationComponent.getPageViewComponent();
                if (this.annotationCallback != null) {
                    this.annotationCallback.removeAnnotation(pageViewComponent, (AnnotationComponent)annotationComponent);
                }
                arrayList.add(new AnnotationState((AnnotationComponent)annotationComponent, AnnotationState.Operation.ADD));
                arrayList2.add(new AnnotationState((AnnotationComponent)annotationComponent, AnnotationState.Operation.DELETE));
                this.firePropertyChange("annotationDeleted", annotationComponent, null);
            });
            this.documentViewModel.addMemento((Memento)new CombinedMemento(arrayList), (Memento)new CombinedMemento(arrayList2));
            this.assignSelectedAnnotation(null);
            this.documentView.repaint();
        }
    }

    @Override
    public void addNewDestination(Destination destination) {
        if (this.documentViewModel != null && destination != null) {
            Library library = this.document.getCatalog().getLibrary();
            Page page = (Page)library.getObject(destination.getPageReference());
            int n = page.getPageIndex();
            PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.documentViewModel.getPageComponents().get(n);
            pageViewComponentImpl.refreshDestinationComponents(pageViewComponentImpl.getPage(), false);
        }
    }

    @Override
    public void updateDestination(Destination destination, Destination destination2) {
        if (this.documentViewModel != null && destination2 != null) {
            if (destination2.getPageReference() != null) {
                Library library = this.document.getCatalog().getLibrary();
                Page page = (Page)library.getObject(destination2.getPageReference());
                int n = page.getPageIndex();
                if (destination.getPageReference().equals((Object)destination2.getPageReference())) {
                    PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.documentViewModel.getPageComponents().get(n);
                    ArrayList<DestinationComponent> arrayList = pageViewComponentImpl.getDestinationComponents();
                    for (DestinationComponent destinationComponent : arrayList) {
                        if (!destinationComponent.getDestination().getNamedDestination().equals(destination.getNamedDestination())) continue;
                        destinationComponent.updateDestination(destination2);
                        break;
                    }
                } else {
                    Page page2 = (Page)library.getObject(destination.getPageReference());
                    int n2 = page2.getPageIndex();
                    PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.documentViewModel.getPageComponents().get(n2);
                    ArrayList<DestinationComponent> arrayList = pageViewComponentImpl.getDestinationComponents();
                    for (DestinationComponent destinationComponent : arrayList) {
                        if (!destinationComponent.getDestination().getNamedDestination().equals(destination.getNamedDestination())) continue;
                        pageViewComponentImpl.removeDestination(destinationComponent);
                        break;
                    }
                    this.addNewDestination(destination2);
                }
            }
            this.documentView.repaint();
        }
    }

    @Override
    public void deleteDestination(Destination destination) {
        if (this.documentViewModel != null && destination != null) {
            if (destination.getPageReference() != null) {
                Library library = this.document.getCatalog().getLibrary();
                Page page = (Page)library.getObject(destination.getPageReference());
                int n = page.getPageIndex();
                PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.documentViewModel.getPageComponents().get(n);
                ArrayList<DestinationComponent> arrayList = pageViewComponentImpl.getDestinationComponents();
                for (DestinationComponent destinationComponent : arrayList) {
                    if (!destinationComponent.getDestination().getNamedDestination().equals(destination.getNamedDestination())) continue;
                    pageViewComponentImpl.removeDestination(destinationComponent);
                    break;
                }
            }
            this.documentView.repaint();
        }
    }

    @Override
    public void undo() {
        Memento memento = this.documentViewModel.getAnnotationCareTaker().undo();
        this.fireEvent(memento);
        this.documentView.repaint();
    }

    @Override
    public void redo() {
        Memento memento = this.documentViewModel.getAnnotationCareTaker().redo();
        this.fireEvent(memento);
        this.documentView.repaint();
    }

    private void fireEvent(Memento memento) {
        if (memento instanceof AnnotationState) {
            this.fireEvent((AnnotationState)memento);
        } else if (memento instanceof CombinedMemento) {
            ((CombinedMemento)memento).getMementos().forEach(this::fireEvent);
        }
    }

    private void fireEvent(AnnotationState annotationState) {
        switch (annotationState.getOperation()) {
            case ADD: {
                this.firePropertyChange("annotationAdded", null, annotationState.getAnnotationComponent());
                break;
            }
            case DELETE: {
                this.firePropertyChange("annotationDeleted", annotationState.getAnnotationComponent(), null);
                break;
            }
            case MOVE: {
                this.firePropertyChange("annotationBounds", annotationState.getAnnotationComponent(), annotationState.getAnnotationComponent());
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }
}

