/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.icepdf.core.pobjects.DictionaryEntries;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.FileSpecification;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Utils;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.DocumentViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.ModifiedFlowLayout;
import org.icepdf.ri.common.views.PageViewDecorator;

public class CollectionDocumentView
extends AbstractDocumentView {
    private static final long serialVersionUID = 7220521612114533227L;
    protected JPanel pagesPanel;

    public CollectionDocumentView(DocumentViewController documentViewController, JScrollPane jScrollPane, DocumentViewModel documentViewModel) {
        super(documentViewController, jScrollPane, documentViewModel);
        this.buildGUI();
    }

    private void buildGUI() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        ModifiedFlowLayout modifiedFlowLayout = new ModifiedFlowLayout();
        modifiedFlowLayout.setHgap(15);
        modifiedFlowLayout.setVgap(15);
        this.pagesPanel = new JPanel(modifiedFlowLayout);
        this.pagesPanel.setBackground(backgroundColour);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pagesPanel, "Center");
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        jScrollPane.getViewport().addChangeListener(changeEvent -> {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Dimension dimension = modifiedFlowLayout.computeSize(jViewport.getWidth(), this.pagesPanel);
            this.pagesPanel.setPreferredSize(dimension);
        });
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentEvent -> {
            if (!adjustmentEvent.getValueIsAdjusting()) {
                this.repaint();
            }
        });
        Document document = this.documentViewController.getDocument();
        Library library = document.getCatalog().getLibrary();
        NameTree nameTree = document.getCatalog().getEmbeddedFilesNameTree();
        if (nameTree != null) {
            List list = nameTree.getNamesAndValues();
            int n = list.size();
            for (int i = 0; i < n; i += 2) {
                String string = Utils.convertStringObject((Library)library, (StringObject)((StringObject)list.get(i)));
                DictionaryEntries dictionaryEntries = (DictionaryEntries)library.getObject((Reference)list.get(i + 1));
                FileSpecification fileSpecification = new FileSpecification(library, dictionaryEntries);
                dictionaryEntries = fileSpecification.getEmbeddedFileDictionary();
                Reference reference = (Reference)dictionaryEntries.get((Object)FileSpecification.F_KEY);
                DocumentViewComponent documentViewComponent = new DocumentViewComponent(library, string, reference);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBackground(backgroundColour);
                PageViewDecorator pageViewDecorator = new PageViewDecorator(documentViewComponent);
                pageViewDecorator.setAlignmentX(0.5f);
                jPanel.add(pageViewDecorator);
                JLabel jLabel = new JLabel(string);
                jLabel.setAlignmentX(0.5f);
                jPanel.add(jLabel);
                this.pagesPanel.add(jPanel);
            }
            this.pagesPanel.revalidate();
            jScrollPane.validate();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.pagesPanel != null) {
            this.pagesPanel.invalidate();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeMouseListener(this);
        this.pagesPanel.removeAll();
    }

    @Override
    public void updateDocumentView() {
    }

    @Override
    public int getNextPageIncrement() {
        return 0;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 0;
    }

    @Override
    public Dimension getDocumentSize() {
        return null;
    }
}

