/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.NameTreeDialog;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;

public class LinkAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_HIGHLIGHT_STYLE = 1;
    private JComboBox<ValueLabelItem> highlightStyleBox;
    private JLabel destinationName;
    private JButton viewNamedDesButton;
    private Name highlightStyle;
    private LinkAnnotation linkAnnotation;

    public LinkAnnotationPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null || !(annotationComponent.getAnnotation() instanceof LinkAnnotation)) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        this.linkAnnotation = (LinkAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.highlightStyle = this.linkAnnotation.getHighlightMode();
        this.applySelectedValue(this.highlightStyleBox, this.highlightStyle);
        Object object = this.linkAnnotation.getEntries().get((Object)LinkAnnotation.DESTINATION_KEY);
        if (object instanceof LiteralStringObject) {
            this.destinationName.setText(((LiteralStringObject)object).getDecryptedLiteralString(this.controller.getDocument().getSecurityManager()));
        }
        this.enableAppearanceInputComponents(this.linkAnnotation.getBorderType());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.highlightStyleBox) {
                this.highlightStyle = (Name)valueLabelItem.getValue();
                this.linkAnnotation.setHighlightMode(this.highlightStyle);
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        NameTree nameTree;
        if (actionEvent.getSource() == this.viewNamedDesButton && (nameTree = this.controller.getDocument().getCatalog().getNames().getDestsNameTree()) != null) {
            NameTreeDialog nameTreeDialog = new NameTreeDialog(this.controller, true, nameTree);
            nameTreeDialog.setDestinationName(this.destinationName.getText());
            nameTreeDialog.setVisible(true);
            this.linkAnnotation.setNamedDestination(nameTreeDialog.getDestinationName());
            this.updateCurrentAnnotation();
            nameTreeDialog.dispose();
        }
    }

    private void createGUI() {
        ValueLabelItem[] valueLabelItemArray = new ValueLabelItem[]{new ValueLabelItem(LinkAnnotation.HIGHLIGHT_NONE, this.messageBundle.getString("viewer.utilityPane.annotation.link.none")), new ValueLabelItem(LinkAnnotation.HIGHLIGHT_INVERT, this.messageBundle.getString("viewer.utilityPane.annotation.link.invert")), new ValueLabelItem(LinkAnnotation.HIGHLIGHT_OUTLINE, this.messageBundle.getString("viewer.utilityPane.annotation.link.outline")), new ValueLabelItem(LinkAnnotation.HIGHLIGHT_PUSH, this.messageBundle.getString("viewer.utilityPane.annotation.link.push"))};
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.link.appearance.title"), 1, 0));
        this.highlightStyleBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.highlightStyleBox.setSelectedIndex(1);
        this.highlightStyleBox.addItemListener(this);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.link.highlightType")), 0, 0, 1, 1);
        this.addGB(this, this.highlightStyleBox, 1, 0, 2, 1);
        this.addGB(this, new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.link.destination")), 0, 1, 1, 1);
        this.destinationName = new JLabel("      ");
        this.addGB(this, this.destinationName, 1, 1, 1, 1);
        this.viewNamedDesButton = new JButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.browse"));
        this.viewNamedDesButton.addActionListener(this);
        this.addGB(this, this.viewNamedDesButton, 2, 1, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 2, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.highlightStyleBox, bl);
    }

    private void enableAppearanceInputComponents(int n) {
        if (n == 0) {
            this.safeEnable(this.highlightStyleBox, true);
        } else {
            this.safeEnable(this.highlightStyleBox, true);
        }
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

