/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class LinkAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler,
MouseInputListener {
    private static final Logger logger = Logger.getLogger(LinkAnnotationHandler.class.toString());

    public LinkAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        selectionBoxColour = Color.GRAY;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.currentRect = new Rectangle(n, n2, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        if (this.rectToDraw.getWidth() < 5.0 || this.rectToDraw.getHeight() < 5.0) {
            this.rectToDraw.setSize(new Dimension(15, 25));
        }
        Rectangle rectangle = this.convertToPageSpace(this.rectToDraw).getBounds();
        Annotation annotation = AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_LINK, (Rectangle)rectangle);
        AbstractAnnotationComponent abstractAnnotationComponent = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent);
        abstractAnnotationComponent.setBounds(this.rectToDraw);
        abstractAnnotationComponent.refreshAnnotationRect();
        this.documentViewController.addNewAnnotation(abstractAnnotationComponent);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.link.selection.type", 0));
        this.clearRectangle(this.pageViewComponent);
    }

    @Override
    protected void checkAndApplyPreferences() {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    @Override
    public void paintTool(Graphics graphics) {
        this.paintSelectionBox(graphics, this.rectToDraw);
    }
}

