/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.search;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.NameNode;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Names;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.search.DestinationResult;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.search.SearchMode;
import org.icepdf.core.search.SearchTerm;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.search.DocumentSearchModelImpl;
import org.icepdf.ri.common.search.SearchHit;
import org.icepdf.ri.common.utility.search.SearchHitComponent;
import org.icepdf.ri.common.utility.search.SearchHitComponentFactory;
import org.icepdf.ri.common.utility.search.SearchHitComponentFactoryImpl;
import org.icepdf.ri.common.views.PageViewComponentImpl;

public class DocumentSearchControllerImpl
implements DocumentSearchController {
    private static final Logger logger = Logger.getLogger(DocumentSearchControllerImpl.class.toString());
    private final DocumentSearchModelImpl searchModel;
    private SwingController viewerController;
    protected Document document;
    public static final SearchHitComponentFactory componentFactory = new SearchHitComponentFactoryImpl();
    private SearchMode searchMode = SearchMode.WORD;
    private final Map<Integer, Set<SearchHitComponent>> pageToComponents = new HashMap<Integer, Set<SearchHitComponent>>();

    public DocumentSearchControllerImpl(SwingController swingController) {
        this.viewerController = swingController;
        this.searchModel = new DocumentSearchModelImpl();
    }

    public DocumentSearchControllerImpl(Document document) {
        this.searchModel = new DocumentSearchModelImpl();
        this.document = document;
    }

    public int searchHighlightPage(int n, String string, boolean bl, boolean bl2) {
        this.clearSearchHighlight(n);
        this.addSearchTerm(string, bl, bl2);
        return this.searchHighlightPage(n);
    }

    public int searchHighlightPage(int n) {
        List<LineText> list = this.searchHighlightPage(n, 0);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public List<LineText> searchHighlightPage(int n, int n2) {
        switch (this.searchMode) {
            case WORD: {
                return this.searchHighlightWordPage(n, n2);
            }
            case PAGE: {
                return this.searchHighlightWholePage(n);
            }
        }
        return Collections.emptyList();
    }

    private List<LineText> searchHighlightWordPage(int n, int n2) {
        ArrayList<LineText> arrayList = new ArrayList<LineText>();
        PageText pageText = this.getPageText(n);
        if (pageText == null) {
            return arrayList;
        }
        ArrayList<SearchTerm> arrayList2 = this.searchModel.getSearchTerms();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            SearchTerm searchTerm;
            SearchTerm searchTerm2 = searchTerm = (SearchTerm)iterator.next();
            int n3 = 0;
            int n4 = searchTerm2.getTerms().size();
            ArrayList arrayList3 = pageText.getPageLines();
            if (arrayList3 == null) continue;
            for (LineText lineText : arrayList3) {
                List list = lineText.getWords();
                int n5 = list.size();
                for (int i = 0; i < n5; ++i) {
                    int n6;
                    Serializable serializable;
                    char c;
                    String string;
                    WordText wordText = (WordText)list.get(i);
                    String string2 = string = searchTerm2.isCaseSensitive() ? wordText.toString() : wordText.toString().toLowerCase();
                    if (string.length() == 1 && WordText.isWhiteSpace((int)(c = string.charAt(0)))) continue;
                    if (searchTerm2.isWholeWord()) {
                        String string3;
                        serializable = searchTerm2.getTerms();
                        n3 = serializable != null && serializable.size() > n3 ? (string.equals(string3 = (String)serializable.get(n3)) ? ++n3 : 0) : 0;
                    } else if (searchTerm2.isRegex()) {
                        serializable = searchTerm2.getRegexPattern();
                        Matcher matcher = ((Pattern)serializable).matcher(string);
                        if (matcher.find() && !wordText.isWhiteSpace()) {
                            ++n3;
                        }
                    } else {
                        String string4;
                        serializable = searchTerm2.getTerms();
                        n3 = serializable != null && serializable.size() > n3 ? ((string4 = (String)searchTerm2.getTerms().get(n3)) != null && string.contains(string4) ? ++n3 : 0) : 0;
                    }
                    if (n3 <= 0 || n3 != n4) continue;
                    serializable = new LineText();
                    int n7 = list.size();
                    List list2 = serializable.getWords();
                    int n8 = n3 - 1;
                    n8 = Math.max(n8, 0);
                    int n9 = i - n3 - n8 - n2 + 1;
                    n9 = Math.max(n9, 0);
                    int n10 = i - n3 - n8;
                    n10 = Math.max(n10, 0);
                    int n11 = i + 1;
                    n11 = Math.min(n11, n7);
                    int n12 = n11 + n2;
                    n12 = Math.min(n12, n7);
                    for (int j = n9; j < n10; ++j) {
                        list2.add((WordText)list.get(j));
                    }
                    int n13 = n6 = n10 == 0 ? 0 : n10 + 1;
                    while (n6 < n11) {
                        WordText wordText2 = (WordText)list.get(n6);
                        wordText2.setHighlighted(true);
                        wordText2.setHasHighlight(true);
                        wordText2.setHighlightColor(searchTerm2.getHighlightColor());
                        list2.add(wordText2);
                        this.addComponent(n, wordText2.getText(), wordText2.getBounds());
                        ++n6;
                    }
                    for (n6 = n11; n6 < n12; ++n6) {
                        list2.add((WordText)list.get(n6));
                    }
                    arrayList.add((LineText)serializable);
                    n3 = 0;
                }
            }
        }
        if (arrayList.size() > 0) {
            this.searchModel.addPageSearchHit(n, pageText, arrayList.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found search hits on page " + n + " hit count " + arrayList.size());
            }
        }
        return arrayList;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    private List<LineText> searchHighlightWholePage(int n) {
        String string;
        int n2;
        Object object5;
        WordText wordText;
        Object object22;
        Object object3;
        Object object42;
        ArrayList<LineText> arrayList = new ArrayList<LineText>();
        PageText pageText = this.getPageText(n);
        if (pageText == null) {
            return arrayList;
        }
        ArrayList<SearchTerm> arrayList2 = this.searchModel.getSearchTerms();
        HashMap hashMap = new HashMap();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        HashMap hashMap2 = new HashMap();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object42 : pageText.getPageLines()) {
            object3 = null;
            if (object42 != null && object42.getWords() != null) {
                object22 = object42.getWords().iterator();
                while (object22.hasNext()) {
                    wordText = (WordText)object22.next();
                    object5 = wordText.getText();
                    if (((String)object5).equals(" ") && (object3 == null || ((String)object3).equals(" "))) continue;
                    arrayList3.add(stringBuilder.length());
                    hashMap.put(arrayList3.size() - 1, wordText);
                    stringBuilder.append((String)object5);
                    arrayList3.add(stringBuilder.length());
                    hashMap.put(arrayList3.size() - 1, wordText);
                    object3 = object5;
                    hashMap2.put(wordText, object42);
                }
            }
            stringBuilder.append("\n");
        }
        WordText wordText2 = stringBuilder.toString();
        object42 = new HashMap();
        object3 = arrayList2.iterator();
        while (object3.hasNext()) {
            SearchTerm searchTerm = object22 = (SearchTerm)object3.next();
            wordText = wordText2;
            if (!searchTerm.isRegex()) {
                wordText = wordText.replace("\n", " ");
            }
            object5 = searchTerm.isRegex() ? searchTerm.getRegexPattern() : Pattern.compile(Pattern.quote(searchTerm.getTerm()), searchTerm.isCaseSensitive() ? 0 : 2);
            Matcher matcher = ((Pattern)object5).matcher((CharSequence)wordText);
            ArrayList<SearchHit> arrayList4 = new ArrayList<SearchHit>();
            while (matcher.find()) {
                int n3 = matcher.start();
                n2 = matcher.end();
                string = wordText2.substring(n3, n2);
                arrayList4.add(new SearchHit(n3, n2, string));
            }
            List list = object42.getOrDefault(searchTerm.getHighlightColor(), new ArrayList());
            list.addAll(arrayList4);
            object42.put(searchTerm.getHighlightColor(), list);
        }
        for (Object object22 : object42.keySet()) {
            for (Object object5 : (List)object42.get(object22)) {
                WordText wordText3;
                WordText wordText4;
                WordText wordText5;
                int n4 = ((SearchHit)object5).getStartOffset();
                int n5 = ((SearchHit)object5).getEndOffset();
                int n6 = Collections.binarySearch(arrayList3, n4);
                if (n6 < 0) {
                    n6 = -(n6 + 1);
                } else if (n6 + 1 < arrayList3.size() && (Integer)arrayList3.get(n6 + 1) == n4) {
                    ++n6;
                }
                n2 = Collections.binarySearch(arrayList3, n5);
                if (n2 < 0) {
                    n2 = Math.min(-(n2 + 1), hashMap.size() - 1);
                }
                string = new LineText();
                WordText wordText6 = (WordText)hashMap.get(n6);
                LineText lineText = (LineText)hashMap2.get(wordText6);
                if (lineText != null && lineText.getWords() != null) {
                    wordText5 = lineText.getWords().iterator();
                    while (wordText5.hasNext() && (wordText4 = (WordText)wordText5.next()) != wordText6) {
                        string.getWords().add(wordText4);
                    }
                }
                wordText5 = null;
                for (int i = n6; i <= n2; ++i) {
                    wordText3 = (WordText)hashMap.get(i);
                    if (wordText3 != wordText5) {
                        wordText3.setHighlighted(true);
                        wordText3.setHasHighlight(true);
                        wordText3.setHighlightColor((Color)object22);
                        string.getWords().add(wordText3);
                        this.addComponent(n, ((SearchHit)object5).getText(), wordText3.getBounds());
                    }
                    wordText5 = wordText3;
                }
                wordText4 = (WordText)hashMap.get(n2);
                wordText3 = (LineText)hashMap2.get(wordText4);
                if (wordText3 != null && wordText3.getWords() != null) {
                    boolean bl = false;
                    for (WordText wordText7 : wordText3.getWords()) {
                        if (bl) {
                            string.getWords().add(wordText7);
                            continue;
                        }
                        if (wordText7 != wordText4) continue;
                        bl = true;
                    }
                }
                arrayList.add((LineText)string);
            }
        }
        if (!arrayList.isEmpty()) {
            this.searchModel.addPageSearchHit(n, pageText, arrayList.size());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found search hits on page " + n + " hit count " + arrayList.size());
            }
        }
        return arrayList;
    }

    public ArrayList<WordText> searchPage(int n) {
        PageText pageText;
        int n2 = this.searchHighlightPage(n);
        if (n2 > 0 && (pageText = this.searchModel.getPageTextHit(n)) != null) {
            ArrayList<WordText> arrayList = new ArrayList<WordText>(n2);
            ArrayList arrayList2 = pageText.getPageLines();
            if (arrayList2 != null) {
                for (LineText lineText : arrayList2) {
                    List list = lineText.getWords();
                    if (list == null) continue;
                    for (WordText wordText : list) {
                        if (!wordText.isHighlighted()) continue;
                        arrayList.add(wordText);
                    }
                }
            }
            return arrayList;
        }
        return null;
    }

    public List<TextWidgetAnnotation> searchForms(int n) {
        Page page;
        if (this.document == null) {
            this.document = this.viewerController.getDocument();
        }
        return (page = this.document.getPageTree().getPage(n)).getAnnotations() == null ? Collections.emptyList() : page.getAnnotations().stream().filter(TextWidgetAnnotation.class::isInstance).map(TextWidgetAnnotation.class::cast).filter(this::textWidgetAnnotationMatches).collect(Collectors.toList());
    }

    private boolean textWidgetAnnotationMatches(TextWidgetAnnotation textWidgetAnnotation) {
        String string = (String)textWidgetAnnotation.getFieldDictionary().getFieldValue();
        if (string != null) {
            ArrayList<SearchTerm> arrayList = this.searchModel.getSearchTerms();
            boolean bl = false;
            for (int i = 0; i < arrayList.size() && !bl; ++i) {
                SearchTerm searchTerm = (SearchTerm)arrayList.get(i);
                Pattern pattern = searchTerm.getRegexPattern();
                String string2 = searchTerm.getTerm();
                if (searchTerm.isRegex() && pattern != null) {
                    Matcher matcher = pattern.matcher(string);
                    bl = matcher.find();
                    continue;
                }
                if (string2 == null) continue;
                bl = searchTerm.isCaseSensitive() ? string.contains(string2) : string.toLowerCase().contains(string2.toLowerCase());
            }
            return bl;
        }
        return false;
    }

    public ArrayList<MarkupAnnotation> searchComments(int n) {
        ArrayList<SearchTerm> arrayList;
        if (this.document == null) {
            this.document = this.viewerController.getDocument();
        }
        Page page = this.document.getPageTree().getPage(n);
        Library library = this.document.getCatalog().getLibrary();
        List list = page.getAnnotationReferences();
        ArrayList<MarkupAnnotation> arrayList2 = new ArrayList<MarkupAnnotation>();
        if (list != null && !list.isEmpty() && !(arrayList = this.searchModel.getSearchTerms()).isEmpty()) {
            SearchTerm searchTerm = arrayList.get(0);
            Pattern pattern = searchTerm.getRegexPattern();
            String string = searchTerm.getTerm();
            for (Object e : list) {
                Object object;
                Object object2 = library.getObject(e);
                if (!(object2 instanceof MarkupAnnotation)) continue;
                boolean bl = false;
                if (searchTerm.isRegex() && pattern != null) {
                    object = pattern.matcher(((MarkupAnnotation)object2).getContents());
                    bl = ((Matcher)object).find();
                } else if (string != null) {
                    object = ((MarkupAnnotation)object2).getContents();
                    if (searchTerm.isCaseSensitive() && object != null) {
                        bl = ((String)object).contains(string);
                    } else if (object != null) {
                        bl = ((String)object).toLowerCase().contains(string.toLowerCase());
                    }
                }
                if (!bl) continue;
                arrayList2.add((MarkupAnnotation)object2);
            }
        }
        return arrayList2;
    }

    public ArrayList<DestinationResult> searchDestinations() {
        NameTree nameTree;
        if (this.document == null) {
            this.document = this.viewerController.getDocument();
        }
        ArrayList<DestinationResult> arrayList = new ArrayList<DestinationResult>();
        Names names = this.document.getCatalog().getNames();
        if (this.searchModel.getSearchTerms().size() > 0 && names != null && names.getDestsNameTree() != null && (nameTree = names.getDestsNameTree()) != null) {
            ArrayList<SearchTerm> arrayList2 = this.searchModel.getSearchTerms();
            SearchTerm searchTerm = arrayList2.get(0);
            Pattern pattern = searchTerm.getRegexPattern();
            String string = searchTerm.getTerm();
            if (pattern == null) {
                pattern = Pattern.compile(searchTerm.isCaseSensitive() ? string : string.toLowerCase());
            }
            this.recursiveNameSearch(pattern, searchTerm.isCaseSensitive(), arrayList, nameTree.getRoot());
        }
        return arrayList;
    }

    private void recursiveNameSearch(Pattern pattern, boolean bl, ArrayList<DestinationResult> arrayList, NameNode nameNode) {
        block4: {
            block3: {
                List list = nameNode.getKidsReferences();
                if (list == null) break block3;
                int n = nameNode.getKidsReferences().size();
                for (int i = 0; i < n; ++i) {
                    NameNode nameNode2 = nameNode.getNode(i);
                    if (!nameNode2.hasLimits()) continue;
                    this.recursiveNameSearch(pattern, bl, arrayList, nameNode2);
                }
                break block4;
            }
            if (nameNode.getNamesAndValues() == null) break block4;
            List list = nameNode.getNamesAndValues();
            int n = list.size() - 1;
            for (int i = 0; i < n; i += 2) {
                Matcher matcher;
                String string = ((StringObject)list.get(i)).getLiteralString();
                if (string == null || string.isEmpty()) continue;
                String string2 = string;
                if (!bl) {
                    string2 = string.toLowerCase();
                }
                if (!(matcher = pattern.matcher(string2)).find()) continue;
                arrayList.add(new DestinationResult(string, list.get(i + 1)));
            }
        }
    }

    public ArrayList<OutlineItem> searchOutlines() {
        if (this.document == null) {
            this.document = this.viewerController.getDocument();
        }
        ArrayList<OutlineItem> arrayList = new ArrayList<OutlineItem>();
        Outlines outlines = this.document.getCatalog().getOutlines();
        if (outlines != null && !this.searchModel.getSearchTerms().isEmpty()) {
            ArrayList<SearchTerm> arrayList2 = this.searchModel.getSearchTerms();
            SearchTerm searchTerm = arrayList2.get(0);
            Pattern pattern = searchTerm.getRegexPattern();
            String string = searchTerm.getTerm();
            if (pattern == null) {
                pattern = Pattern.compile(searchTerm.isCaseSensitive() ? string : string.toLowerCase());
            }
            this.recursiveOutlineSearch(pattern, searchTerm.isCaseSensitive(), arrayList, outlines.getRootOutlineItem());
        }
        return arrayList;
    }

    private void recursiveOutlineSearch(Pattern pattern, boolean bl, ArrayList<OutlineItem> arrayList, OutlineItem outlineItem) {
        int n = outlineItem.getSubItemCount();
        for (int i = 0; i < n; ++i) {
            Matcher matcher;
            OutlineItem outlineItem2 = outlineItem.getSubItem(i);
            if (outlineItem2.getSubItemCount() > 0) {
                this.recursiveOutlineSearch(pattern, bl, arrayList, outlineItem2);
                continue;
            }
            String string = outlineItem2.getTitle();
            if (string == null || string.isEmpty() || !(matcher = pattern.matcher(bl ? string : string.toLowerCase())).find()) continue;
            arrayList.add(outlineItem2);
        }
    }

    public void setCurrentSearchHit(int n, WordText wordText) {
        PageText pageText = this.searchModel.getPageTextHit(n);
        if (pageText != null) {
            ArrayList arrayList = pageText.getPageLines();
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                LineText lineText = (LineText)arrayList.get(i);
                List list = lineText.getWords();
                int n3 = list.size();
                for (int j = 0; j < n3; ++j) {
                    WordText wordText2 = (WordText)list.get(j);
                    if (!wordText2.equals((Object)wordText)) continue;
                    wordText2.setHighlightCursor(true);
                    this.searchModel.setSearchPageCursor(n);
                    this.searchModel.setSearchLineCursor(i);
                    this.searchModel.setSearchWordCursor(j);
                }
            }
        }
    }

    public WordText nextSearchHit() {
        if (this.searchModel.getPageSearchHitsSize() == 0) {
            return null;
        }
        int n = this.searchModel.getSearchPageCursor();
        int n2 = this.searchModel.getSearchLineCursor();
        int n3 = this.searchModel.getSearchWordCursor();
        int n4 = this.viewerController.getDocument().getNumberOfPages();
        if (n < n4) {
            ++n3;
            for (int i = n; i < n4; ++i) {
                PageText pageText;
                if (!this.searchModel.isPageSearchHit(i)) continue;
                if (this.searchModel.getPageTextHit(i) == null) {
                    this.searchHighlightPage(i);
                }
                if ((pageText = this.searchModel.getPageTextHit(i)) == null) continue;
                pageText.clearHighlightedCursor();
                ArrayList arrayList = pageText.getPageLines();
                int n5 = arrayList.size();
                for (int j = n2; j < n5; ++j) {
                    LineText lineText = (LineText)arrayList.get(j);
                    List list = lineText.getWords();
                    int n6 = list.size();
                    for (int k = n3; k < n6; ++k) {
                        WordText wordText = (WordText)list.get(k);
                        if (!wordText.isHighlighted()) continue;
                        while (k < n6 && ((WordText)list.get(k)).isHighlighted()) {
                            ((WordText)list.get(k)).setHighlightCursor(true);
                            ++k;
                        }
                        this.searchModel.setSearchPageCursor(i);
                        this.searchModel.setSearchLineCursor(j);
                        this.searchModel.setSearchWordCursor(k);
                        this.showWord(i, wordText);
                        return wordText;
                    }
                    n3 = 0;
                }
                n2 = 0;
            }
            this.searchModel.setSearchPageCursor(0);
            this.searchModel.setSearchLineCursor(0);
            this.searchModel.setSearchWordCursor(-1);
            return this.nextSearchHit();
        }
        return null;
    }

    public void showWord(int n, WordText wordText) {
        this.viewerController.showPage(n);
        Rectangle2D.Double double_ = wordText.getBounds();
        this.viewerController.getDocumentViewController().setDestinationTarget(new Destination(this.viewerController.getDocument().getPageTree().getPage(n), (int)double_.x, (int)(double_.y + double_.height + 100.0)));
    }

    public WordText previousSearchHit() {
        if (this.searchModel.getPageSearchHitsSize() == 0) {
            return null;
        }
        int n = this.searchModel.getSearchPageCursor();
        int n2 = this.searchModel.getSearchLineCursor();
        int n3 = this.searchModel.getSearchWordCursor();
        int n4 = this.viewerController.getDocument().getNumberOfPages();
        if (n < n4) {
            --n3;
            for (int i = n; i >= 0; --i) {
                PageText pageText;
                if (!this.searchModel.isPageSearchHit(i)) continue;
                if (this.searchModel.getPageTextHit(i) == null) {
                    this.searchHighlightPage(i);
                }
                if ((pageText = this.searchModel.getPageTextHit(i)) == null) continue;
                pageText.clearHighlightedCursor();
                ArrayList arrayList = pageText.getPageLines();
                if (!arrayList.isEmpty()) {
                    if (n3 < 0) {
                        --n2;
                    }
                    if (n2 < 0) {
                        n2 = arrayList.size() - 1;
                    }
                    for (int j = n2; j >= 0; --j) {
                        LineText lineText = (LineText)arrayList.get(j);
                        List list = lineText.getWords();
                        if (n3 < 0) {
                            n3 = list.size() - 1;
                        }
                        for (int k = n3; k >= 0; --k) {
                            WordText wordText = (WordText)list.get(k);
                            if (!wordText.isHighlighted()) continue;
                            while (k >= 0 && ((WordText)list.get(k)).isHighlighted()) {
                                ((WordText)list.get(k)).setHighlightCursor(true);
                                --k;
                            }
                            this.searchModel.setSearchPageCursor(i);
                            this.searchModel.setSearchLineCursor(j);
                            this.searchModel.setSearchWordCursor(k);
                            this.showWord(i, wordText);
                            return wordText;
                        }
                        n3 = -1;
                    }
                }
                n2 = -1;
            }
            this.searchModel.setSearchPageCursor(n4 - 1);
            this.searchModel.setSearchLineCursor(-1);
            this.searchModel.setSearchWordCursor(-1);
            return this.previousSearchHit();
        }
        return null;
    }

    public void setCurrentPage(int n) {
        this.searchModel.setSearchPageCursor(n);
        this.searchModel.setSearchLineCursor(0);
        this.searchModel.setSearchWordCursor(-1);
    }

    public SearchTerm addSearchTerm(String string, boolean bl, boolean bl2) {
        return this.addSearchTerm(string, bl, bl2, false);
    }

    public SearchTerm addSearchTerm(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.addSearchTerm(string, bl, bl2, bl3, Page.highlightColor);
    }

    public SearchTerm addSearchTerm(String string, boolean bl, boolean bl2, boolean bl3, Color color) {
        String string2 = String.valueOf(string);
        if (!bl) {
            string = string.toLowerCase();
        }
        ArrayList<String> arrayList = this.searchMode == SearchMode.PAGE ? new ArrayList<String>(Collections.singletonList(string)) : this.searchPhraseParser(string);
        SearchTerm searchTerm = new SearchTerm(string2, arrayList, bl, bl2, bl3, color);
        this.searchModel.addSearchTerm(searchTerm);
        return searchTerm;
    }

    public void removeSearchTerm(SearchTerm searchTerm) {
        this.searchModel.removeSearchTerm(searchTerm);
    }

    public void clearSearchHighlight(int n) {
        this.searchModel.clearSearchResults(n);
        PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.viewerController.getDocumentViewController().getDocumentViewModel().getPageComponents().get(n);
        pageViewComponentImpl.clearSearchHighlights();
    }

    public void clearAllSearchHighlight() {
        this.searchModel.clearSearchResults();
        this.pageToComponents.forEach((n, set) -> {
            PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.viewerController.getDocumentViewController().getDocumentViewModel().getPageComponents().get((int)n);
            pageViewComponentImpl.clearSearchHighlights();
        });
        this.pageToComponents.clear();
    }

    public boolean isSearchHighlightRefreshNeeded(int n, PageText pageText) {
        return this.searchModel.isPageTextMatch(n, pageText);
    }

    public void dispose() {
        this.searchModel.clearSearchResults();
        this.pageToComponents.clear();
        this.document = null;
    }

    protected PageText getPageText(int n) {
        PageText pageText = null;
        if (this.document == null) {
            this.document = this.viewerController.getDocument();
        }
        try {
            if (this.viewerController != null) {
                pageText = this.viewerController.getDocument().getPageText(n);
            } else if (this.document != null) {
                pageText = this.document.getPageText(n);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.fine("PageText extraction thread was interrupted.");
        }
        return pageText;
    }

    protected ArrayList<String> searchPhraseParser(String string) {
        string = string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            boolean bl = WordText.isPunctuation((int)c2);
            if (WordText.isWhiteSpace((int)c2) || bl && !WordText.isDigit((char)c)) {
                if (n != i) {
                    arrayList.add(string.substring(n, i));
                }
                if (bl) {
                    arrayList.add(string.substring(i, i + 1));
                }
                n = i + 1 < n2 ? i + 1 : n;
            } else if (i + 1 == n2) {
                arrayList.add(string.substring(n, i + 1));
            }
            c = c2;
        }
        return arrayList;
    }

    public Set<SearchHitComponent> getComponentsFor(int n) {
        return this.pageToComponents.getOrDefault(n, new HashSet());
    }

    protected void addComponent(int n, String string, Rectangle2D.Double double_) {
        SearchHitComponent searchHitComponent;
        Set set = this.pageToComponents.getOrDefault(n, new HashSet());
        if (!set.contains(searchHitComponent = componentFactory.createComponent(string, double_, this.document.getPageTree().getPage(n), this.viewerController))) {
            if (searchHitComponent != null) {
                set.add(searchHitComponent);
            }
            this.pageToComponents.put(n, set);
        }
    }
}

