/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.util.ArrayList;
import org.icepdf.core.Memento;
import org.icepdf.core.util.Defs;

public class UndoCaretaker {
    private static final int maxHistorySize = Defs.sysPropertyInt((String)"org.icepdf.ri.viewer.undo.size", (int)100);
    private final ArrayList<Memento> mementoStateHistory = new ArrayList(maxHistorySize);
    private int cursor = -1;

    public Memento undo() {
        if (this.isUndo()) {
            --this.cursor;
            Memento memento = this.restore();
            --this.cursor;
            return memento;
        }
        return null;
    }

    public boolean isUndo() {
        return this.cursor >= 0;
    }

    public Memento redo() {
        if (this.isRedo()) {
            this.cursor += 2;
            return this.restore();
        }
        return null;
    }

    private Memento restore() {
        Memento memento = this.mementoStateHistory.get(this.cursor);
        memento.restore();
        return memento;
    }

    public boolean isRedo() {
        return this.cursor < this.mementoStateHistory.size() - 1;
    }

    public void addState(Memento memento, Memento memento2) {
        if (this.isRedo()) {
            this.mementoStateHistory.subList(this.cursor + 1, this.mementoStateHistory.size()).clear();
        }
        this.mementoStateHistory.add(memento);
        this.mementoStateHistory.add(memento2);
        while (this.mementoStateHistory.size() > maxHistorySize) {
            this.mementoStateHistory.remove(0);
        }
        this.cursor = this.mementoStateHistory.size() - 1;
    }
}

