/*
 * Decompiled with CFR 0.152.
 */
package co.ceryle.radiorealbutton;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import co.ceryle.radiorealbutton.ConversionHelper;
import co.ceryle.radiorealbutton.R;
import co.ceryle.radiorealbutton.RippleHelper;

public class RadioRealButton
extends LinearLayout {
    private AppCompatImageView imageView;
    private AppCompatTextView textView;
    private Typeface defaultTypeface;
    private Typeface textTypeface;
    private String text;
    private String textTypefacePath;
    private int textStyle;
    private int textSize;
    private int drawable;
    private int drawableTint;
    private int drawableTintTo;
    private int textColor;
    private int textColorTo;
    private int rippleColor;
    private int drawableWidth;
    private int drawableHeight;
    private int selectorColor;
    private int padding;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;
    private int drawablePadding;
    private int backgroundColor;
    private int textGravity;
    private boolean hasPaddingLeft;
    private boolean hasPaddingRight;
    private boolean hasPaddingTop;
    private boolean hasPaddingBottom;
    private boolean hasDrawableTint;
    private boolean hasTextTypefacePath;
    private boolean hasDrawable;
    private boolean hasText;
    private boolean hasDrawableWidth;
    private boolean hasDrawableHeight;
    private boolean checked;
    private boolean enabled;
    private boolean hasEnabled;
    private boolean clickable;
    private boolean hasClickable;
    private boolean hasTextStyle;
    private boolean hasTextSize;
    private boolean hasTextColor;
    private boolean textFillSpace;
    private boolean hasRipple;
    private boolean hasRippleColor;
    private boolean hasSelectorColor;
    private boolean hasDrawableTintTo;
    private boolean hasTextColorTo;
    private OnSelectorColorChangedListener onSelectorColorChangedListener;
    private int position;
    private DrawableGravity drawableGravity;

    public RadioRealButton(Context context) {
        super(context);
        this.init(null);
    }

    public RadioRealButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    @TargetApi(value=11)
    public RadioRealButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public RadioRealButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.getAttributes(attrs);
        this.initViews();
        this.setDrawableGravity();
        this.setState();
        super.setPadding(0, 0, 0, 0);
        this.setPaddingAttrs();
    }

    private void initViews() {
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        this.setOrientation(0);
        this.setGravity(17);
        this.imageView = new AppCompatImageView(this.getContext());
        this.imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2){
            {
                this.gravity = 17;
            }
        });
        this.setDrawableAttrs();
        this.addView((View)this.imageView);
        this.textView = new AppCompatTextView(this.getContext());
        this.textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2){
            {
                this.gravity = 17;
            }
        });
        this.setTextAttrs();
        this.addView((View)this.textView);
    }

    private void getAttributes(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.RadioRealButton);
        this.drawable = ta.getResourceId(R.styleable.RadioRealButton_rrb_drawable, -1);
        this.drawableTint = ta.getColor(R.styleable.RadioRealButton_rrb_drawableTint, 0);
        this.drawableTintTo = ta.getColor(R.styleable.RadioRealButton_rrb_drawableTintTo, 0);
        this.drawableWidth = ta.getDimensionPixelSize(R.styleable.RadioRealButton_rrb_drawableWidth, -1);
        this.drawableHeight = ta.getDimensionPixelSize(R.styleable.RadioRealButton_rrb_drawableHeight, -1);
        this.hasDrawable = ta.hasValue(R.styleable.RadioRealButton_rrb_drawable);
        this.hasDrawableTint = ta.hasValue(R.styleable.RadioRealButton_rrb_drawableTint);
        this.hasDrawableTintTo = ta.hasValue(R.styleable.RadioRealButton_rrb_drawableTintTo);
        this.hasDrawableWidth = ta.hasValue(R.styleable.RadioRealButton_rrb_drawableWidth);
        this.hasDrawableHeight = ta.hasValue(R.styleable.RadioRealButton_rrb_drawableHeight);
        this.text = ta.getString(R.styleable.RadioRealButton_rrb_text);
        this.hasText = ta.hasValue(R.styleable.RadioRealButton_rrb_text);
        this.textColor = ta.getColor(R.styleable.RadioRealButton_rrb_textColor, -16777216);
        this.textColorTo = ta.getColor(R.styleable.RadioRealButton_rrb_textColorTo, -16777216);
        this.hasTextColor = ta.hasValue(R.styleable.RadioRealButton_rrb_textColor);
        this.hasTextColorTo = ta.hasValue(R.styleable.RadioRealButton_rrb_textColorTo);
        this.textSize = ta.getDimensionPixelSize(R.styleable.RadioRealButton_rrb_textSize, -1);
        this.hasTextSize = ta.hasValue(R.styleable.RadioRealButton_rrb_textSize);
        this.textStyle = ta.getInt(R.styleable.RadioRealButton_rrb_textStyle, -1);
        this.hasTextStyle = ta.hasValue(R.styleable.RadioRealButton_rrb_textStyle);
        int typeface = ta.getInt(R.styleable.RadioRealButton_rrb_textTypeface, -1);
        switch (typeface) {
            case 0: {
                this.textTypeface = Typeface.MONOSPACE;
                break;
            }
            case 1: {
                this.textTypeface = Typeface.DEFAULT;
                break;
            }
            case 2: {
                this.textTypeface = Typeface.SANS_SERIF;
                break;
            }
            case 3: {
                this.textTypeface = Typeface.SERIF;
            }
        }
        this.textTypefacePath = ta.getString(R.styleable.RadioRealButton_rrb_textTypefacePath);
        this.hasTextTypefacePath = ta.hasValue(R.styleable.RadioRealButton_rrb_textTypefacePath);
        this.hasRipple = ta.getBoolean(R.styleable.RadioRealButton_rrb_ripple, true);
        this.rippleColor = ta.getColor(R.styleable.RadioRealButton_rrb_rippleColor, -7829368);
        this.hasRippleColor = ta.hasValue(R.styleable.RadioRealButton_rrb_rippleColor);
        this.backgroundColor = ta.getColor(R.styleable.RadioRealButton_rrb_backgroundColor, 0);
        int defaultPadding = ConversionHelper.dpToPx(this.getContext(), 10.0f);
        this.padding = ta.getDimensionPixelSize(R.styleable.RadioRealButton_android_padding, defaultPadding);
        this.paddingLeft = ta.getDimensionPixelSize(R.styleable.RadioRealButton_android_paddingLeft, 0);
        this.paddingRight = ta.getDimensionPixelSize(R.styleable.RadioRealButton_android_paddingRight, 0);
        this.paddingTop = ta.getDimensionPixelSize(R.styleable.RadioRealButton_android_paddingTop, 0);
        this.paddingBottom = ta.getDimensionPixelSize(R.styleable.RadioRealButton_android_paddingBottom, 0);
        this.hasPaddingLeft = ta.hasValue(R.styleable.RadioRealButton_android_paddingLeft);
        this.hasPaddingRight = ta.hasValue(R.styleable.RadioRealButton_android_paddingRight);
        this.hasPaddingTop = ta.hasValue(R.styleable.RadioRealButton_android_paddingTop);
        this.hasPaddingBottom = ta.hasValue(R.styleable.RadioRealButton_android_paddingBottom);
        this.drawablePadding = ta.getDimensionPixelSize(R.styleable.RadioRealButton_rrb_drawablePadding, 4);
        this.drawableGravity = DrawableGravity.getById(ta.getInteger(R.styleable.RadioRealButton_rrb_drawableGravity, 0));
        this.checked = ta.getBoolean(R.styleable.RadioRealButton_rrb_checked, false);
        this.enabled = ta.getBoolean(R.styleable.RadioRealButton_android_enabled, true);
        this.hasEnabled = ta.hasValue(R.styleable.RadioRealButton_android_enabled);
        this.clickable = ta.getBoolean(R.styleable.RadioRealButton_android_clickable, true);
        this.hasClickable = ta.hasValue(R.styleable.RadioRealButton_android_clickable);
        this.textGravity = ta.getInt(R.styleable.RadioRealButton_rrb_textGravity, 0);
        this.textFillSpace = ta.getBoolean(R.styleable.RadioRealButton_rrb_textFillSpace, false);
        this.selectorColor = ta.getColor(R.styleable.RadioRealButton_rrb_selectorColor, 0);
        this.hasSelectorColor = ta.hasValue(R.styleable.RadioRealButton_rrb_selectorColor);
        ta.recycle();
    }

    public int getTextColorTo() {
        return this.textColorTo;
    }

    public void setTextColorTo(int textColorTo) {
        this.textColorTo = textColorTo;
    }

    public boolean hasTextColorTo() {
        return this.hasTextColorTo;
    }

    public boolean hasTextColor() {
        return this.hasTextColor;
    }

    public void setHasTextColor(boolean hasTextColor) {
        this.hasTextColor = hasTextColor;
    }

    public void setHasTextColorTo(boolean hasTextColorTo) {
        this.hasTextColorTo = hasTextColorTo;
    }

    public boolean hasDrawableTintTo() {
        return this.hasDrawableTintTo;
    }

    public void setHasDrawableTintTo(boolean hasDrawableTintTo) {
        this.hasDrawableTintTo = hasDrawableTintTo;
    }

    public int getDrawableTintTo() {
        return this.drawableTintTo;
    }

    public void setDrawableTintTo(int drawableTintTo) {
        this.drawableTintTo = drawableTintTo;
    }

    public int getSelectorColor() {
        return this.selectorColor;
    }

    public void setSelectorColor(int selectorColor) {
        this.selectorColor = selectorColor;
        this.onSelectorColorChangedListener.onSelectorColorChanged(this.position, selectorColor);
    }

    public boolean hasSelectorColor() {
        return this.hasSelectorColor;
    }

    void setOnSelectorColorChangedListener(OnSelectorColorChangedListener onSelectorColorChangedListener, int position) {
        this.onSelectorColorChangedListener = onSelectorColorChangedListener;
        this.position = position;
    }

    public boolean hasEnabled() {
        return this.hasEnabled;
    }

    public boolean hasClickable() {
        return this.hasClickable;
    }

    private void setDrawableAttrs() {
        if (this.hasDrawable) {
            this.imageView.setImageResource(this.drawable);
            if (this.hasDrawableTint) {
                this.imageView.setColorFilter(this.drawableTint);
            }
            if (this.hasDrawableWidth) {
                this.setDrawableWidth(this.drawableWidth);
            }
            if (this.hasDrawableHeight) {
                this.setDrawableHeight(this.drawableHeight);
            }
        } else {
            this.imageView.setVisibility(8);
        }
    }

    private void setDrawableGravity() {
        if (!this.hasDrawable) {
            return;
        }
        if (this.drawableGravity == DrawableGravity.LEFT || this.drawableGravity == DrawableGravity.TOP) {
            if (this.getChildAt(0) instanceof AppCompatTextView) {
                this.removeViewAt(0);
                this.addView((View)this.textView, 1);
                if (this.textFillSpace) {
                    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.textView.getLayoutParams();
                    params.weight = 0.0f;
                    params.width = -2;
                }
            }
        } else if (this.getChildAt(0) instanceof AppCompatImageView) {
            this.removeViewAt(0);
            this.addView((View)this.imageView, 1);
            if (this.textFillSpace) {
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.textView.getLayoutParams();
                params.weight = 1.0f;
                params.width = 0;
            }
        }
        if (this.hasText && this.hasDrawable) {
            if (this.drawableGravity == DrawableGravity.TOP || this.drawableGravity == DrawableGravity.BOTTOM) {
                this.setOrientation(1);
            } else {
                this.setOrientation(0);
            }
        }
    }

    private void setTextAttrs() {
        this.defaultTypeface = this.textView.getTypeface();
        this.textView.setText((CharSequence)this.text);
        int gravity = this.textGravity == 2 ? 0x800005 : (this.textGravity == 1 ? 17 : 0x800003);
        this.textView.setGravity(gravity);
        if (this.hasTextColor) {
            this.textView.setTextColor(this.textColor);
        }
        if (this.hasTextSize) {
            this.setTextSizePX(this.textSize);
        }
        if (this.hasTextTypefacePath) {
            this.setTypeface(this.textTypefacePath);
        } else if (null != this.textTypeface) {
            this.setTypeface(this.textTypeface);
        }
        if (this.hasTextStyle) {
            this.setTextStyle(this.textStyle);
        }
    }

    private void setPaddingAttrs() {
        if (this.hasPaddingBottom || this.hasPaddingTop || this.hasPaddingLeft || this.hasPaddingRight) {
            this.setPaddings(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        } else {
            this.setPaddings(this.padding, this.padding, this.padding, this.padding);
        }
    }

    void colorTransitionDrawable(boolean hasAnimateDrawablesTint, int colorFrom, int colorTo, int duration, boolean hasAnimation, boolean onEnter) {
        int c2;
        int c1;
        if (this.hasDrawableTintTo) {
            c1 = this.drawableTint;
            c2 = this.drawableTintTo;
        } else if (hasAnimateDrawablesTint) {
            c1 = colorFrom;
            c2 = colorTo;
        } else {
            return;
        }
        if (!onEnter) {
            int c = c1;
            c1 = c2;
            c2 = c;
        }
        if (hasAnimation) {
            this.colorTransition((View)this.imageView, c1, c2, duration);
        } else {
            this.setDrawableTint(c2);
        }
    }

    void colorTransitionText(boolean hasAnimateTextsColor, int colorFrom, int colorTo, int duration, boolean hasAnimation, boolean onEnter) {
        int c2;
        int c1;
        if (this.hasTextColorTo) {
            c1 = this.textColor;
            c2 = this.textColorTo;
        } else if (hasAnimateTextsColor) {
            c1 = colorFrom;
            c2 = colorTo;
        } else {
            return;
        }
        if (!onEnter) {
            int c = c1;
            c1 = c2;
            c2 = c;
        }
        if (hasAnimation) {
            this.colorTransition((View)this.textView, c1, c2, duration);
        } else {
            this.setTextColor(c2);
        }
    }

    private void colorTransition(final View v, int colorFrom, int colorTo, int duration) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)duration);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                if (v instanceof ImageView) {
                    ((ImageView)v).setColorFilter(((Integer)animator.getAnimatedValue()).intValue());
                } else {
                    ((TextView)v).setTextColor(((Integer)animator.getAnimatedValue()).intValue());
                }
            }
        });
        colorAnimation.start();
    }

    void bounceDrawable(float scale, int duration, Interpolator interpolator, boolean hasAnimation) {
        if (hasAnimation) {
            this.bounce((View)this.imageView, scale, duration, interpolator);
        } else {
            this.bounceDrawable(scale);
        }
    }

    void bounceText(float scale, int duration, Interpolator interpolator, boolean hasAnimation) {
        if (hasAnimation) {
            this.bounce((View)this.textView, scale, duration, interpolator);
        } else {
            this.bounceText(scale);
        }
    }

    private void bounce(View view, float scale, int duration, Interpolator interpolator) {
        if (Build.VERSION.SDK_INT >= 12) {
            view.animate().setDuration((long)duration).setInterpolator((TimeInterpolator)interpolator).scaleX(scale).scaleY(scale);
        } else {
            this.bounce(view, scale);
        }
    }

    void bounceDrawable(float scale) {
        this.bounce((View)this.imageView, scale);
    }

    void bounceText(float scale) {
        this.bounce((View)this.textView, scale);
    }

    private void bounce(View view, float scale) {
        view.setScaleX(scale);
        view.setScaleY(scale);
    }

    public AppCompatTextView getTextView() {
        return this.textView;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.textView.setTextColor(textColor);
    }

    void setCheckedTextColor(int color) {
        this.textView.setTextColor(color);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textView.setText((CharSequence)text);
    }

    public void setTextSizePX(int size) {
        this.textView.setTextSize(0, (float)size);
    }

    public void setTextSizeSP(float size) {
        this.textView.setTextSize(2, size);
    }

    public int getTextSize() {
        return this.textSize;
    }

    public int getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(int typeface) {
        this.textView.setTypeface(this.textView.getTypeface(), typeface);
    }

    public void restoreTypeface() {
        this.textView.setTypeface(this.defaultTypeface);
    }

    public String getTypefacePath() {
        return this.textTypefacePath;
    }

    public void setTypeface(Typeface typeface) {
        this.textView.setTypeface(typeface);
    }

    public void setTypeface(String location) {
        if (null != location && !location.equals("")) {
            Typeface typeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)location);
            this.textView.setTypeface(typeface);
        }
    }

    public Typeface getDefaultTypeface() {
        return this.defaultTypeface;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPaddings(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.paddingLeft = paddingLeft;
        this.paddingTop = paddingTop;
        this.paddingRight = paddingRight;
        this.paddingBottom = paddingBottom;
        this.updatePaddings();
    }

    private void updatePaddings() {
        if (this.hasText) {
            this.updatePadding((View)this.textView, this.hasDrawable);
        }
        if (this.hasDrawable) {
            this.updatePadding((View)this.imageView, this.hasText);
        }
    }

    private void updatePadding(View view, boolean hasOtherView) {
        if (null == view) {
            return;
        }
        int[] paddings = new int[]{this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom};
        if (hasOtherView) {
            int g = this.drawableGravity.getIntValue();
            if (view instanceof AppCompatImageView) {
                g = g > 1 ? g - 2 : g + 2;
            }
            paddings[g] = this.drawablePadding / 2;
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        params.setMargins(paddings[0], paddings[1], paddings[2], paddings[3]);
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public boolean hasPaddingLeft() {
        return this.hasPaddingLeft;
    }

    public boolean hasPaddingRight() {
        return this.hasPaddingRight;
    }

    public boolean hasPaddingTop() {
        return this.hasPaddingTop;
    }

    public boolean hasPaddingBottom() {
        return this.hasPaddingBottom;
    }

    public AppCompatImageView getImageView() {
        return this.imageView;
    }

    public int getDrawable() {
        return this.drawable;
    }

    public void setDrawable(Drawable drawable) {
        this.imageView.setImageDrawable(drawable);
    }

    public void setDrawable(int drawable) {
        this.drawable = drawable;
        this.imageView.setImageResource(drawable);
    }

    public int getDrawableTint() {
        return this.drawableTint;
    }

    public void setDrawableTint(int color) {
        this.drawableTint = color;
        this.imageView.setColorFilter(color);
    }

    void setCheckedDrawableTint(int color) {
        this.imageView.setColorFilter(color);
    }

    public boolean hasDrawableTint() {
        return this.hasDrawableTint;
    }

    public void setDrawableTint(boolean hasColor) {
        this.hasDrawableTint = hasColor;
        if (hasColor) {
            this.imageView.setColorFilter(this.drawableTint);
        } else {
            this.imageView.clearColorFilter();
        }
    }

    public int getDrawableWidth() {
        return this.drawableWidth;
    }

    public void setDrawableWidth(int drawableWidth) {
        this.drawableWidth = drawableWidth;
        ViewGroup.LayoutParams params = this.imageView.getLayoutParams();
        if (null != params) {
            params.width = drawableWidth;
        }
    }

    public int getDrawableHeight() {
        return this.drawableHeight;
    }

    public void setDrawableHeight(int drawableHeight) {
        this.drawableHeight = drawableHeight;
        ViewGroup.LayoutParams params = this.imageView.getLayoutParams();
        if (null != params) {
            params.height = drawableHeight;
        }
    }

    public void setDrawableSizeByPx(int width, int height) {
        this.drawableWidth = width;
        this.drawableHeight = height;
        ViewGroup.LayoutParams params = this.imageView.getLayoutParams();
        if (null != params) {
            params.width = width;
            params.height = height;
        }
    }

    public void setDrawableSizeByDp(int width, int height) {
        width = ConversionHelper.dpToPx(this.getContext(), width);
        height = ConversionHelper.dpToPx(this.getContext(), height);
        this.setDrawableSizeByPx(width, height);
    }

    public DrawableGravity getDrawableGravity() {
        return this.drawableGravity;
    }

    public void setDrawableGravity(DrawableGravity gravity) {
        this.drawableGravity = gravity;
        this.setDrawableGravity();
        this.setPaddingAttrs();
    }

    public int getDrawablePadding() {
        return this.drawablePadding;
    }

    public void setDrawablePadding(int drawablePadding) {
        this.drawablePadding = drawablePadding;
        this.updatePaddings();
    }

    public int getRippleColor() {
        return this.rippleColor;
    }

    public void setRippleColor(int rippleColor) {
        this.rippleColor = rippleColor;
        this.setRippleColor(true);
    }

    public void setRippleColor(boolean state) {
        this.hasRippleColor = state;
        this.setRippleBackground(this.hasRippleColor);
    }

    public void setRipple(boolean state) {
        this.hasRipple = state;
        this.setRippleBackground(this.hasRipple);
    }

    private void setRippleBackground(boolean state) {
        if (state) {
            if (this.hasRippleColor) {
                RippleHelper.setRipple((View)this, this.rippleColor, this.backgroundColor);
            } else if (this.hasRipple) {
                RippleHelper.setSelectableItemBackground(this.getContext(), (View)this);
            }
        } else {
            this.setBackgroundColor(this.backgroundColor);
        }
    }

    private void setEnabledAlpha(boolean enabled) {
        float alpha = 1.0f;
        if (!enabled) {
            alpha = 0.5f;
        }
        this.setAlpha(alpha);
    }

    public void setEnabled(boolean enabled) {
        super.setClickable(enabled);
        this.enabled = enabled;
        this.setEnabledAlpha(enabled);
        this.setRippleBackground(enabled);
    }

    public void setClickable(boolean clickable) {
        super.setClickable(clickable);
        this.clickable = clickable;
        this.setRippleBackground(clickable);
    }

    private void setState() {
        if (this.hasEnabled) {
            this.setEnabled(this.enabled);
        } else {
            this.setClickable(this.clickable);
        }
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public static enum DrawableGravity {
        LEFT(0),
        TOP(1),
        RIGHT(2),
        BOTTOM(3);

        private int intValue;

        private DrawableGravity(int intValue) {
            this.intValue = intValue;
        }

        private int getIntValue() {
            return this.intValue;
        }

        public static DrawableGravity getById(int id) {
            for (DrawableGravity e : DrawableGravity.values()) {
                if (e.intValue != id) continue;
                return e;
            }
            return null;
        }

        public boolean isHorizontal() {
            return this.intValue == 0 || this.intValue == 2;
        }
    }

    static interface OnSelectorColorChangedListener {
        public void onSelectorColorChanged(int var1, int var2);
    }
}

