/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.views.imagezoom.utils;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.os.Environment;
import android.util.Log;
import android.view.Display;
import android.view.View;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";
    public static final long MAX_SZIE = 524288L;

    public static int getOrientation(String imagePath) {
        int rotate = 0;
        try {
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    public static BitmapSize getBitmapSize(String filePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        return new BitmapSize(options.outWidth, options.outHeight);
    }

    public static BitmapSize getScaledSize(int originalWidth, int originalHeight, int numPixels) {
        float ratio = (float)originalWidth / (float)originalHeight;
        int scaledHeight = (int)Math.sqrt((float)numPixels / ratio);
        int scaledWidth = (int)((double)ratio * Math.sqrt((float)numPixels / ratio));
        return new BitmapSize(scaledWidth, scaledHeight);
    }

    public static byte[] bitmapTobytes(Bitmap bitmap) {
        ByteArrayOutputStream a = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 30, (OutputStream)a);
        return a.toByteArray();
    }

    public static byte[] bitmapTobytesNoCompress(Bitmap bitmap) {
        ByteArrayOutputStream a = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)a);
        return a.toByteArray();
    }

    public static Bitmap genRotateBitmap(byte[] data) {
        Bitmap bMap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        Matrix matrix = new Matrix();
        matrix.reset();
        matrix.postRotate(90.0f);
        Bitmap bMapRotate = Bitmap.createBitmap((Bitmap)bMap, (int)0, (int)0, (int)bMap.getWidth(), (int)bMap.getHeight(), (Matrix)matrix, (boolean)true);
        bMap.recycle();
        bMap = null;
        System.gc();
        return bMapRotate;
    }

    public static Bitmap byteToBitmap(byte[] data) {
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
    }

    public static Bitmap getBitmapFromView(View view) {
        Bitmap returnedBitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(returnedBitmap);
        Drawable bgDrawable = view.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        view.draw(canvas);
        return returnedBitmap;
    }

    public static Bitmap getImageCompress(String srcPath) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = 800.0f;
        float ww = 480.0f;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        return BitmapUtils.compressImage(bitmap);
    }

    public static Bitmap compress(Bitmap image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        if (baos.toByteArray().length / 1024 > 1024) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)baos);
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = 800.0f;
        float ww = 480.0f;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        isBm = new ByteArrayInputStream(baos.toByteArray());
        bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, (BitmapFactory.Options)newOpts);
        return BitmapUtils.compressImage(bitmap);
    }

    private static Bitmap compressImage(Bitmap image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while (baos.toByteArray().length / 1024 > 100) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            options -= 10;
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        return bitmap;
    }

    public void printscreen_share(View v, Activity context) {
        View view1 = context.getWindow().getDecorView();
        Display display = context.getWindowManager().getDefaultDisplay();
        view1.layout(0, 0, display.getWidth(), display.getHeight());
        view1.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view1.getDrawingCache());
    }

    public static boolean saveBitmap2file(Bitmap bmp, String filepath) {
        Bitmap.CompressFormat format = Bitmap.CompressFormat.PNG;
        int quality = 100;
        FileOutputStream stream = null;
        try {
            if (!"mounted".equals(Environment.getExternalStorageState())) {
                return false;
            }
            File SDCardRoot = Environment.getExternalStorageDirectory();
            if (SDCardRoot.getFreeSpace() < 10000L) {
                Log.e((String)"Utils", (String)"\u5b58\u50a8\u7a7a\u95f4\u4e0d\u591f");
                return false;
            }
            File bitmapFile = new File(SDCardRoot.getPath() + filepath);
            bitmapFile.getParentFile().mkdirs();
            stream = new FileOutputStream(SDCardRoot.getPath() + filepath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return bmp.compress(format, quality, stream);
    }

    public static Bitmap getScreenViewBitmap(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }

    public static Bitmap getViewBitmap(View view) {
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }

    public static Bitmap resizeBitmap(Bitmap input, int destWidth, int destHeight, int rotation) throws OutOfMemoryError {
        int dstWidth = destWidth;
        int dstHeight = destHeight;
        int srcWidth = input.getWidth();
        int srcHeight = input.getHeight();
        if (rotation == 90 || rotation == 270) {
            dstWidth = destHeight;
            dstHeight = destWidth;
        }
        boolean needsResize = false;
        if (srcWidth > dstWidth || srcHeight > dstHeight) {
            needsResize = true;
            if (srcWidth > srcHeight && srcWidth > dstWidth) {
                float p = (float)dstWidth / (float)srcWidth;
                dstHeight = (int)((float)srcHeight * p);
            } else {
                float p = (float)dstHeight / (float)srcHeight;
                dstWidth = (int)((float)srcWidth * p);
            }
        } else {
            dstWidth = srcWidth;
            dstHeight = srcHeight;
        }
        if (needsResize || rotation != 0) {
            Bitmap output;
            if (rotation == 0) {
                output = Bitmap.createScaledBitmap((Bitmap)input, (int)dstWidth, (int)dstHeight, (boolean)true);
            } else {
                Matrix matrix = new Matrix();
                matrix.postScale((float)dstWidth / (float)srcWidth, (float)dstHeight / (float)srcHeight);
                matrix.postRotate((float)rotation);
                output = Bitmap.createBitmap((Bitmap)input, (int)0, (int)0, (int)srcWidth, (int)srcHeight, (Matrix)matrix, (boolean)true);
            }
            return output;
        }
        return input;
    }

    public static Bitmap resizeBitmap(Bitmap input, int destWidth, int destHeight) throws OutOfMemoryError {
        return BitmapUtils.resizeBitmap(input, destWidth, destHeight, 0);
    }

    public static Bitmap getSampledBitmap(String filePath, int reqWidth, int reqHeight) {
        int inSampleSize;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = inSampleSize = BitmapUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static boolean saveBitmap(Bitmap bm, String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            f.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            bm.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)out);
            out.flush();
            out.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class BitmapSize {
        public int width;
        public int height;

        public BitmapSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

