/*
 * Decompiled with CFR 0.152.
 */
package com.papsign.ktor.openapigen.modules.handlers;

import com.papsign.ktor.openapigen.OpenAPIGen;
import com.papsign.ktor.openapigen.UtilKt;
import com.papsign.ktor.openapigen.annotations.Response;
import com.papsign.ktor.openapigen.content.type.ContentTypeProvider;
import com.papsign.ktor.openapigen.content.type.ResponseSerializer;
import com.papsign.ktor.openapigen.content.type.SelectedSerializer;
import com.papsign.ktor.openapigen.model.operation.MediaTypeModel;
import com.papsign.ktor.openapigen.model.operation.OperationModel;
import com.papsign.ktor.openapigen.model.operation.StatusResponseModel;
import com.papsign.ktor.openapigen.modules.ModuleProvider;
import com.papsign.ktor.openapigen.modules.OpenAPIModule;
import com.papsign.ktor.openapigen.modules.openapi.OperationModule;
import com.papsign.ktor.openapigen.modules.providers.StatusProvider;
import io.ktor.http.ContentType;
import io.ktor.http.HttpStatusCode;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0016B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/papsign/ktor/openapigen/modules/handlers/ResponseHandlerModule;", "T", "Lcom/papsign/ktor/openapigen/modules/openapi/OperationModule;", "responseType", "Lkotlin/reflect/KType;", "responseExample", "(Lkotlin/reflect/KType;Ljava/lang/Object;)V", "log", "Lorg/slf4j/Logger;", "getResponseExample", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getResponseType", "()Lkotlin/reflect/KType;", "configure", "", "apiGen", "Lcom/papsign/ktor/openapigen/OpenAPIGen;", "provider", "Lcom/papsign/ktor/openapigen/modules/ModuleProvider;", "operation", "Lcom/papsign/ktor/openapigen/model/operation/OperationModel;", "Companion", "com.papsign.ktor.openapigen"})
public final class ResponseHandlerModule<T>
implements OperationModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KType responseType;
    @Nullable
    private final T responseExample;
    @NotNull
    private final Logger log;

    public ResponseHandlerModule(@NotNull KType responseType, @Nullable T responseExample) {
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        this.responseType = responseType;
        this.responseExample = responseExample;
        this.log = UtilKt.classLogger(this);
    }

    public /* synthetic */ ResponseHandlerModule(KType kType, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object = null;
        }
        this(kType, object);
    }

    @NotNull
    public final KType getResponseType() {
        return this.responseType;
    }

    @Nullable
    public final T getResponseExample() {
        return this.responseExample;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configure(@NotNull OpenAPIGen apiGen, @NotNull ModuleProvider<?> provider, @NotNull OperationModel operation) {
        StatusResponseModel statusResponseModel;
        void $this$associateTo$iv$iv;
        Object it;
        Object destination$iv$iv;
        Object object;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object2;
        KAnnotatedElement $this$findAnnotation$iv;
        Response response;
        KAnnotatedElement kAnnotatedElement;
        Intrinsics.checkNotNullParameter((Object)apiGen, (String)"apiGen");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        KClassifier kClassifier = this.responseType.getClassifier();
        KAnnotatedElement kAnnotatedElement2 = kAnnotatedElement = kClassifier instanceof KAnnotatedElement ? (KAnnotatedElement)kClassifier : null;
        if (kAnnotatedElement == null) {
            response = null;
        } else {
            Object v2;
            block18: {
                $this$findAnnotation$iv = kAnnotatedElement;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof Response)) continue;
                    v2 = element$iv$iv;
                    break block18;
                }
                v2 = null;
            }
            response = (Response)((Annotation)v2);
        }
        Response responseMeta = response;
        Object $this$ofType$iv = provider;
        int $i$f$ofType = 0;
        int $i$f$getKType = 0;
        StatusProvider $i$f$findAnnotation = (StatusProvider)CollectionsKt.lastOrNull((Iterable)$this$ofType$iv.ofType(Reflection.typeOf(StatusProvider.class)));
        HttpStatusCode httpStatusCode = $this$findAnnotation$iv = $i$f$findAnnotation == null ? null : $i$f$findAnnotation.getStatusForType(this.responseType);
        if ($this$findAnnotation$iv == null) {
            HttpStatusCode httpStatusCode2;
            $this$ofType$iv = responseMeta;
            if ($this$ofType$iv == null) {
                httpStatusCode2 = null;
            } else {
                $i$f$getKType = $i$f$ofType = $this$ofType$iv.statusCode();
                boolean element$iv$iv = false;
                boolean it$iv = false;
                int it2 = $i$f$getKType;
                boolean bl = false;
                httpStatusCode2 = HttpStatusCode.Companion.fromValue(it2);
            }
            $i$f$findAnnotation = httpStatusCode2;
            object2 = $i$f$findAnnotation == null ? HttpStatusCode.Companion.getOK() : $i$f$findAnnotation;
        } else {
            object2 = $this$findAnnotation$iv;
        }
        KAnnotatedElement statusCode = object2;
        String status = String.valueOf(statusCode.getValue());
        $this$ofType$iv = provider;
        $i$f$ofType = 0;
        $i$f$getKType = 0;
        $this$ofType$iv = $this$ofType$iv.ofType(Reflection.typeOf(ResponseSerializer.class));
        boolean $i$f$mapNotNull = false;
        void $i$f$getKType2 = $this$mapNotNull$iv;
        Iterable<List> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            List list;
            Object element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            ResponseSerializer it3 = (ResponseSerializer)element$iv$iv;
            boolean bl2 = false;
            object = it3.getMediaType(this.getResponseType(), apiGen, provider, this.getResponseExample(), ContentTypeProvider.Usage.SERIALIZE);
            if (object == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$registerModule$iv;
                Map<ContentType, MediaTypeModel<T>> mediaType = object;
                object = provider;
                OpenAPIModule module$iv = new SelectedSerializer(it3);
                boolean $i$f$registerModule22 = false;
                boolean $i$f$getKType3 = false;
                $this$registerModule$iv.registerModule(module$iv, Reflection.typeOf(SelectedSerializer.class));
                Map<ContentType, MediaTypeModel<T>> $this$map$iv = mediaType;
                boolean $i$f$map = false;
                Map<ContentType, MediaTypeModel<T>> $i$f$registerModule22 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var27_51 = $this$mapTo$iv$iv;
                boolean bl3 = false;
                Iterator iterator = var27_51.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    Pair pair = new Pair((Object)((ContentType)it.getKey()).toString(), it.getValue());
                    collection.add(pair);
                }
                list = (List)destination$iv$iv;
            }
            if (list == null) continue;
            List list2 = list;
            boolean bl5 = false;
            boolean bl6 = false;
            List it$iv$iv = list2;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Iterable $this$associate$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Object element$iv$iv$iv;
            element$iv$iv$iv = destination$iv$iv3;
            Pair it4 = (Pair)element$iv$iv;
            boolean bl = false;
            bl = false;
            element$iv$iv$iv.put((Object)it4.getFirst(), (Object)it4.getSecond());
        }
        Map map = destination$iv$iv3;
        Object object3 = responseMeta;
        Object object4 = object3 == null ? null : object3.description();
        String descstr = object4 == null ? statusCode.getDescription() : object4;
        object4 = operation.getResponses();
        StatusResponseModel statusResponseModel2 = operation.getResponses().get(status);
        if (statusResponseModel2 == null) {
            statusResponseModel = null;
        } else {
            Object object5;
            StatusResponseModel statusResponseModel3 = statusResponseModel2;
            boolean bl = false;
            boolean bl8 = false;
            StatusResponseModel $this$configure_u24lambda_u2d6 = statusResponseModel3;
            boolean bl9 = false;
            Map $this$forEach$iv = map;
            boolean $i$f$forEach2 = false;
            Map map2 = $this$forEach$iv;
            boolean bl10 = false;
            object = map2.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = object.next();
                boolean bl11 = false;
                destination$iv$iv = $dstr$key$value;
                boolean bl12 = false;
                String key = (String)destination$iv$iv.getKey();
                Object object6 = $dstr$key$value;
                boolean bl13 = false;
                MediaTypeModel value = (MediaTypeModel)object6.getValue();
                object6 = $this$configure_u24lambda_u2d6.getContent().putIfAbsent(key, value);
                if (object6 == null) continue;
                Object object7 = object6;
                boolean bl14 = false;
                boolean bl15 = false;
                it = object7;
                boolean bl16 = false;
                if (Intrinsics.areEqual((Object)value, (Object)it)) continue;
                this.log.warn("ContentType of " + this.getResponseType() + " response " + key + " already registered, ignoring " + value);
            }
            if (!Intrinsics.areEqual((Object)$this$configure_u24lambda_u2d6.getDescription(), (Object)statusCode.getDescription())) {
                object5 = responseMeta;
                if ((object5 == null ? null : object5.description()) != null) {
                    this.log.warn("ContentType description of " + this.getResponseType() + " response already registered, ignoring");
                }
            } else {
                Response response2 = responseMeta;
                object5 = response2 == null ? null : response2.description();
                $this$configure_u24lambda_u2d6.setDescription((String)(object5 == null ? statusCode.getDescription() : object5));
            }
            statusResponseModel = statusResponseModel3;
        }
        object3 = statusResponseModel;
        object3 = object3 == null ? new StatusResponseModel(descstr, null, MapsKt.toMutableMap((Map)map), 2, null) : object3;
        boolean bl = false;
        object4.put(status, object3);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/papsign/ktor/openapigen/modules/handlers/ResponseHandlerModule$Companion;", "", "()V", "create", "Lcom/papsign/ktor/openapigen/modules/handlers/ResponseHandlerModule;", "T", "tType", "Lkotlin/reflect/KType;", "responseExample", "(Lkotlin/reflect/KType;Ljava/lang/Object;)Lcom/papsign/ktor/openapigen/modules/handlers/ResponseHandlerModule;", "com.papsign.ktor.openapigen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> ResponseHandlerModule<T> create(@NotNull KType tType, @Nullable T responseExample) {
            Intrinsics.checkNotNullParameter((Object)tType, (String)"tType");
            return new ResponseHandlerModule<T>(tType, responseExample);
        }

        public static /* synthetic */ ResponseHandlerModule create$default(Companion companion, KType kType, Object object, int n, Object object2) {
            if ((n & 2) != 0) {
                object = null;
            }
            return companion.create(kType, object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

