/*
 * Decompiled with CFR 0.152.
 */
package com.papsign.ktor.openapigen.annotations.type.string.length;

import com.papsign.ktor.openapigen.annotations.type.common.ConstraintViolation;
import com.papsign.ktor.openapigen.annotations.type.string.length.LengthConstraint;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/papsign/ktor/openapigen/annotations/type/string/length/LengthConstraintViolation;", "Lcom/papsign/ktor/openapigen/annotations/type/common/ConstraintViolation;", "actual", "", "constraint", "Lcom/papsign/ktor/openapigen/annotations/type/string/length/LengthConstraint;", "(Ljava/lang/Number;Lcom/papsign/ktor/openapigen/annotations/type/string/length/LengthConstraint;)V", "getActual", "()Ljava/lang/Number;", "getConstraint", "()Lcom/papsign/ktor/openapigen/annotations/type/string/length/LengthConstraint;", "com.papsign.ktor.openapigen"})
public final class LengthConstraintViolation
extends ConstraintViolation {
    @Nullable
    private final Number actual;
    @NotNull
    private final LengthConstraint constraint;

    public LengthConstraintViolation(@Nullable Number actual, final @NotNull LengthConstraint constraint) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        super("Constraint violation: the length of the string should be " + (String)new Function0<String>(){

            @NotNull
            public final String invoke() {
                String min = String.valueOf(constraint.getMin());
                String max = String.valueOf(constraint.getMax());
                return constraint.getMin() != null && constraint.getMax() != null ? "between " + min + " and " + max : (constraint.getMin() != null ? Intrinsics.stringPlus((String)"at least ", (Object)min) : (constraint.getMax() != null ? Intrinsics.stringPlus((String)"at most ", (Object)max) : "anything"));
            }
        }.invoke() + ", but it is " + actual, constraint.getErrorMessage(), null, 4, null);
        this.actual = actual;
        this.constraint = constraint;
    }

    @Nullable
    public final Number getActual() {
        return this.actual;
    }

    @NotNull
    public final LengthConstraint getConstraint() {
        return this.constraint;
    }
}

