/*
 * Decompiled with CFR 0.152.
 */
package com.papsign.ktor.openapigen.annotations.type.number;

import com.papsign.ktor.openapigen.UtilKt;
import com.papsign.ktor.openapigen.annotations.type.number.NotANumberViolationViolation;
import com.papsign.ktor.openapigen.annotations.type.number.NumberConstraint;
import com.papsign.ktor.openapigen.annotations.type.number.NumberConstraintViolation;
import com.papsign.ktor.openapigen.model.schema.SchemaModel;
import com.papsign.ktor.openapigen.schema.processor.SchemaProcessor;
import com.papsign.ktor.openapigen.validation.Validator;
import com.papsign.ktor.openapigen.validation.ValidatorBuilder;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\u001eB\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0012\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/papsign/ktor/openapigen/annotations/type/number/NumberConstraintProcessor;", "A", "", "Lcom/papsign/ktor/openapigen/schema/processor/SchemaProcessor;", "Lcom/papsign/ktor/openapigen/validation/ValidatorBuilder;", "allowedTypes", "", "Lkotlin/reflect/KType;", "(Ljava/lang/Iterable;)V", "log", "Lorg/slf4j/Logger;", "types", "", "getTypes", "()Ljava/util/List;", "build", "Lcom/papsign/ktor/openapigen/validation/Validator;", "type", "annotation", "(Lkotlin/reflect/KType;Ljava/lang/annotation/Annotation;)Lcom/papsign/ktor/openapigen/validation/Validator;", "getConstraint", "Lcom/papsign/ktor/openapigen/annotations/type/number/NumberConstraint;", "(Ljava/lang/annotation/Annotation;)Lcom/papsign/ktor/openapigen/annotations/type/number/NumberConstraint;", "process", "Lcom/papsign/ktor/openapigen/model/schema/SchemaModel$SchemaModelLitteral;", "modelLitteral", "(Lcom/papsign/ktor/openapigen/model/schema/SchemaModel$SchemaModelLitteral;Ljava/lang/annotation/Annotation;)Lcom/papsign/ktor/openapigen/model/schema/SchemaModel$SchemaModelLitteral;", "Lcom/papsign/ktor/openapigen/model/schema/SchemaModel;", "model", "(Lcom/papsign/ktor/openapigen/model/schema/SchemaModel;Lkotlin/reflect/KType;Ljava/lang/annotation/Annotation;)Lcom/papsign/ktor/openapigen/model/schema/SchemaModel;", "NumberConstraintValidator", "com.papsign.ktor.openapigen"})
public abstract class NumberConstraintProcessor<A extends Annotation>
implements SchemaProcessor<A>,
ValidatorBuilder<A> {
    @NotNull
    private final Logger log;
    @NotNull
    private final List<KType> types;

    /*
     * WARNING - void declaration
     */
    public NumberConstraintProcessor(@NotNull Iterable<? extends KType> allowedTypes) {
        List list;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(allowedTypes, (String)"allowedTypes");
        this.log = UtilKt.classLogger(this);
        Iterable<? extends KType> iterable = allowedTypes;
        NumberConstraintProcessor numberConstraintProcessor = this;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KType it = (KType)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new KType[]{KTypes.withNullability((KType)it, (boolean)true), KTypes.withNullability((KType)it, (boolean)false)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        numberConstraintProcessor.types = list = (List)destination$iv$iv;
    }

    @NotNull
    public final List<KType> getTypes() {
        return this.types;
    }

    @NotNull
    public abstract SchemaModel.SchemaModelLitteral<?> process(@NotNull SchemaModel.SchemaModelLitteral<?> var1, @NotNull A var2);

    @NotNull
    public abstract NumberConstraint getConstraint(@NotNull A var1);

    @Override
    @NotNull
    public Validator build(@NotNull KType type2, @NotNull A annotation) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        if (!this.types.contains(type2)) {
            String string = Reflection.getOrCreateKotlinClass(annotation.getClass()) + " can only be used on types: " + this.types;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new NumberConstraintValidator(this.getConstraint(annotation));
    }

    @Override
    @NotNull
    public SchemaModel<?> process(@NotNull SchemaModel<?> model, @NotNull KType type2, @NotNull A annotation) {
        SchemaModel<?> schemaModel;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        if (model instanceof SchemaModel.SchemaModelLitteral && this.types.contains(type2)) {
            schemaModel = (SchemaModel<?>)this.process((SchemaModel.SchemaModelLitteral)model, annotation);
        } else {
            this.log.warn(Reflection.getOrCreateKotlinClass(annotation.getClass()) + " can only be used on types: " + this.types);
            schemaModel = model;
        }
        return schemaModel;
    }

    @Override
    @NotNull
    public List<KType> getExceptionTypes() {
        return ValidatorBuilder.DefaultImpls.getExceptionTypes(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u0001H\u0006\"\u0004\b\u0001\u0010\u00062\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0006H\u0016\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/papsign/ktor/openapigen/annotations/type/number/NumberConstraintProcessor$NumberConstraintValidator;", "Lcom/papsign/ktor/openapigen/validation/Validator;", "constraint", "Lcom/papsign/ktor/openapigen/annotations/type/number/NumberConstraint;", "(Lcom/papsign/ktor/openapigen/annotations/type/number/NumberConstraint;)V", "validate", "T", "subject", "(Ljava/lang/Object;)Ljava/lang/Object;", "com.papsign.ktor.openapigen"})
    private static final class NumberConstraintValidator
    implements Validator {
        @NotNull
        private final NumberConstraint constraint;

        public NumberConstraintValidator(@NotNull NumberConstraint constraint) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            this.constraint = constraint;
        }

        @Override
        @Nullable
        public <T> T validate(@Nullable T subject) {
            if (subject instanceof Number) {
                BigDecimal value = new BigDecimal(((Number)subject).toString());
                if (this.constraint.getMin() != null) {
                    if (this.constraint.getMinInclusive() && value.compareTo(this.constraint.getMin()) < 0) {
                        throw new NumberConstraintViolation(value, this.constraint);
                    }
                    if (!this.constraint.getMinInclusive() && value.compareTo(this.constraint.getMin()) <= 0) {
                        throw new NumberConstraintViolation(value, this.constraint);
                    }
                }
                if (this.constraint.getMax() != null) {
                    if (this.constraint.getMaxInclusive() && value.compareTo(this.constraint.getMax()) > 0) {
                        throw new NumberConstraintViolation(value, this.constraint);
                    }
                    if (!this.constraint.getMaxInclusive() && value.compareTo(this.constraint.getMax()) >= 0) {
                        throw new NumberConstraintViolation(value, this.constraint);
                    }
                }
            } else {
                throw new NotANumberViolationViolation(subject);
            }
            return subject;
        }
    }
}

