/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.util.Locale;

public class LayoutUtil {
    public static boolean isRtl(@NonNull Context ctx) {
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                ApplicationInfo info = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                return (info.flags &= 0x400000) != 0;
            }
            catch (PackageManager.NameNotFoundException e) {
                return LayoutUtil.defaultIsRtlBehavior();
            }
        }
        return false;
    }

    @RequiresApi(api=17)
    private static boolean defaultIsRtlBehavior() {
        return TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
    }
}

