/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.content.Context;
import android.graphics.PorterDuff;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ProgressBar;
import com.github.paolorotolo.appintro.IndicatorController;
import com.github.paolorotolo.appintro.R;

public class ProgressIndicatorController
implements IndicatorController {
    public static final int DEFAULT_COLOR = 1;
    private static final int FIRST_PAGE_NUM = 0;
    private ProgressBar mProgressBar;
    int selectedDotColor = 1;
    int unselectedDotColor = 1;

    @Override
    public View newInstance(@NonNull Context context) {
        this.mProgressBar = (ProgressBar)View.inflate((Context)context, (int)R.layout.progress_indicator, null);
        if (this.selectedDotColor != 1) {
            this.mProgressBar.getProgressDrawable().setColorFilter(this.selectedDotColor, PorterDuff.Mode.SRC_IN);
        }
        if (this.unselectedDotColor != 1) {
            this.mProgressBar.getIndeterminateDrawable().setColorFilter(this.unselectedDotColor, PorterDuff.Mode.SRC_IN);
        }
        return this.mProgressBar;
    }

    @Override
    public void initialize(int slideCount) {
        this.mProgressBar.setMax(slideCount);
        this.selectPosition(0);
    }

    @Override
    public void selectPosition(int index) {
        this.mProgressBar.setProgress(index + 1);
    }

    @Override
    public void setSelectedIndicatorColor(int color) {
        this.selectedDotColor = color;
        if (this.mProgressBar != null) {
            this.mProgressBar.getProgressDrawable().setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
    }

    @Override
    public void setUnselectedIndicatorColor(int color) {
        this.unselectedDotColor = color;
        if (this.mProgressBar != null) {
            this.mProgressBar.getIndeterminateDrawable().setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
    }
}

