/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import androidx.core.content.res.ResourcesCompat;
import com.github.appintro.internal.LogHelper;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/appintro/internal/CustomFontCache;", "", "()V", "TAG", "", "cache", "Ljava/util/HashMap;", "Landroid/graphics/Typeface;", "Lkotlin/collections/HashMap;", "getFont", "", "ctx", "Landroid/content/Context;", "path", "fontCallback", "Landroidx/core/content/res/ResourcesCompat$FontCallback;", "appintro_release"})
public final class CustomFontCache {
    @NotNull
    public static final CustomFontCache INSTANCE = new CustomFontCache();
    @NotNull
    private static final String TAG = LogHelper.INSTANCE.makeLogTag(Reflection.getOrCreateKotlinClass(CustomFontCache.class));
    @NotNull
    private static final HashMap<String, Typeface> cache = new HashMap();

    private CustomFontCache() {
    }

    public final void getFont(@NotNull Context ctx, @Nullable String path, @NotNull ResourcesCompat.FontCallback fontCallback) {
        block3: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)fontCallback, (String)"fontCallback");
            CharSequence charSequence = path;
            if (charSequence == null || charSequence.length() == 0) {
                LogHelper.w$default(TAG, "Empty typeface path provided!", null, 4, null);
                return;
            }
            Typeface typeface = cache.get(path);
            if (typeface != null) {
                Typeface it = typeface;
                boolean bl = false;
                fontCallback.onFontRetrieved(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            CustomFontCache $this$getFont_u24lambda_u241 = this;
            boolean bl = false;
            Typeface newTypeface = Typeface.createFromAsset((AssetManager)ctx.getAssets(), (String)path);
            Map map = cache;
            Intrinsics.checkNotNull((Object)newTypeface);
            map.put(path, newTypeface);
            fontCallback.onFontRetrieved(newTypeface);
        }
    }
}

