/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.github.paolorotolo.appintro.AppIntroViewPager;
import com.github.paolorotolo.appintro.DefaultIndicatorController;
import com.github.paolorotolo.appintro.ISlideBackgroundColorHolder;
import com.github.paolorotolo.appintro.ISlidePolicy;
import com.github.paolorotolo.appintro.ISlideSelectionListener;
import com.github.paolorotolo.appintro.IndicatorController;
import com.github.paolorotolo.appintro.PagerAdapter;
import com.github.paolorotolo.appintro.PermissionObject;
import com.github.paolorotolo.appintro.ProgressIndicatorController;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.ViewPageTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class AppIntroBase
extends AppCompatActivity
implements AppIntroViewPager.OnNextPageRequestedListener {
    public static final int DEFAULT_COLOR = 1;
    private static final String TAG = "AppIntroBase";
    private static final int DEFAULT_SCROLL_DURATION_FACTOR = 1;
    private static final int PERMISSIONS_REQUEST_ALL_PERMISSIONS = 1;
    private static final String INSTANCE_DATA_IMMERSIVE_MODE_ENABLED = "com.github.paolorotolo.appintro_immersive_mode_enabled";
    private static final String INSTANCE_DATA_IMMERSIVE_MODE_STICKY = "com.github.paolorotolo.appintro_immersive_mode_sticky";
    private static final String INSTANCE_DATA_COLOR_TRANSITIONS_ENABLED = "com.github.paolorotolo.appintro_color_transitions_enabled";
    protected PagerAdapter mPagerAdapter;
    protected AppIntroViewPager pager;
    protected Vibrator mVibrator;
    protected IndicatorController mController;
    private GestureDetectorCompat gestureDetector;
    protected final List<Fragment> fragments = new Vector<Fragment>();
    protected int slidesNumber;
    protected int vibrateIntensity = 20;
    protected int selectedIndicatorColor = 1;
    protected int unselectedIndicatorColor = 1;
    protected View nextButton;
    protected View doneButton;
    protected View skipButton;
    protected int savedCurrentItem;
    protected ArrayList<PermissionObject> permissionsArray = new ArrayList();
    private final ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    protected boolean isVibrateOn = false;
    protected boolean baseProgressButtonEnabled = true;
    protected boolean progressButtonEnabled = true;
    private boolean isGoBackLockEnabled = false;
    private boolean isImmersiveModeEnabled = false;
    private boolean isImmersiveModeSticky = false;
    private boolean areColorTransitionsEnabled = false;
    protected boolean skipButtonEnabled = true;
    private int currentlySelectedItem = -1;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayoutId());
        this.gestureDetector = new GestureDetectorCompat((Context)this, (GestureDetector.OnGestureListener)new WindowGestureListener());
        this.nextButton = this.findViewById(R.id.next);
        this.doneButton = this.findViewById(R.id.done);
        this.skipButton = this.findViewById(R.id.skip);
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        this.mPagerAdapter = new PagerAdapter(this.getSupportFragmentManager(), this.fragments);
        this.pager = (AppIntroViewPager)this.findViewById(R.id.view_pager);
        this.doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntroBase.this.isVibrateOn) {
                    AppIntroBase.this.mVibrator.vibrate((long)AppIntroBase.this.vibrateIntensity);
                }
                Fragment currentFragment = AppIntroBase.this.mPagerAdapter.getItem(AppIntroBase.this.pager.getCurrentItem());
                boolean isSlideChangingAllowed = AppIntroBase.this.handleBeforeSlideChanged();
                if (isSlideChangingAllowed) {
                    AppIntroBase.this.handleSlideChanged(currentFragment, null);
                    AppIntroBase.this.onDonePressed(currentFragment);
                } else {
                    AppIntroBase.this.handleIllegalSlideChangeAttempt();
                }
            }
        });
        this.skipButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntroBase.this.isVibrateOn) {
                    AppIntroBase.this.mVibrator.vibrate((long)AppIntroBase.this.vibrateIntensity);
                }
                AppIntroBase.this.onSkipPressed(AppIntroBase.this.mPagerAdapter.getItem(AppIntroBase.this.pager.getCurrentItem()));
            }
        });
        this.nextButton.setOnClickListener((View.OnClickListener)new NextButtonOnClickListener());
        this.pager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
        this.pager.addOnPageChangeListener(new PagerOnPageChangeListener());
        this.pager.setOnNextPageRequestedListener(this);
        this.setScrollDurationFactor(1);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        if (this.fragments.size() == 0) {
            this.init(null);
        }
        this.pager.setCurrentItem(this.savedCurrentItem);
        this.pager.post(new Runnable(){

            @Override
            public void run() {
                AppIntroBase.this.handleSlideChanged(null, AppIntroBase.this.mPagerAdapter.getItem(AppIntroBase.this.pager.getCurrentItem()));
            }
        });
        this.slidesNumber = this.fragments.size();
        this.setProgressButtonEnabled(this.progressButtonEnabled);
        this.initController();
    }

    public void onBackPressed() {
        if (!this.isGoBackLockEnabled) {
            super.onBackPressed();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus && this.isImmersiveModeEnabled) {
            this.setImmersiveMode(true, this.isImmersiveModeSticky);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.isImmersiveModeEnabled) {
            this.gestureDetector.onTouchEvent(event);
        }
        return super.dispatchTouchEvent(event);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("baseProgressButtonEnabled", this.baseProgressButtonEnabled);
        outState.putBoolean("progressButtonEnabled", this.progressButtonEnabled);
        outState.putBoolean("nextEnabled", this.pager.isPagingEnabled());
        outState.putBoolean("nextPagingEnabled", this.pager.isNextPagingEnabled());
        outState.putBoolean("skipButtonEnabled", this.skipButtonEnabled);
        outState.putInt("lockPage", this.pager.getLockPage());
        outState.putInt("currentItem", this.pager.getCurrentItem());
        outState.putBoolean(INSTANCE_DATA_IMMERSIVE_MODE_ENABLED, this.isImmersiveModeEnabled);
        outState.putBoolean(INSTANCE_DATA_IMMERSIVE_MODE_STICKY, this.isImmersiveModeSticky);
        outState.putBoolean(INSTANCE_DATA_COLOR_TRANSITIONS_ENABLED, this.areColorTransitionsEnabled);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.baseProgressButtonEnabled = savedInstanceState.getBoolean("baseProgressButtonEnabled");
        this.progressButtonEnabled = savedInstanceState.getBoolean("progressButtonEnabled");
        this.skipButtonEnabled = savedInstanceState.getBoolean("skipButtonEnabled");
        this.savedCurrentItem = savedInstanceState.getInt("currentItem");
        this.pager.setPagingEnabled(savedInstanceState.getBoolean("nextEnabled"));
        this.pager.setNextPagingEnabled(savedInstanceState.getBoolean("nextPagingEnabled"));
        this.pager.setLockPage(savedInstanceState.getInt("lockPage"));
        this.isImmersiveModeEnabled = savedInstanceState.getBoolean(INSTANCE_DATA_IMMERSIVE_MODE_ENABLED);
        this.isImmersiveModeSticky = savedInstanceState.getBoolean(INSTANCE_DATA_IMMERSIVE_MODE_STICKY);
        this.areColorTransitionsEnabled = savedInstanceState.getBoolean(INSTANCE_DATA_COLOR_TRANSITIONS_ENABLED);
    }

    @Override
    public boolean onCanRequestNextPage() {
        return this.handleBeforeSlideChanged();
    }

    @Override
    public void onIllegallyRequestedNextPage() {
        this.handleIllegalSlideChangeAttempt();
    }

    private void initController() {
        if (this.mController == null) {
            this.mController = new DefaultIndicatorController();
        }
        FrameLayout indicatorContainer = (FrameLayout)this.findViewById(R.id.indicator_container);
        indicatorContainer.addView(this.mController.newInstance((Context)this));
        this.mController.initialize(this.slidesNumber);
        if (this.selectedIndicatorColor != 1) {
            this.mController.setSelectedIndicatorColor(this.selectedIndicatorColor);
        }
        if (this.unselectedIndicatorColor != 1) {
            this.mController.setUnselectedIndicatorColor(this.unselectedIndicatorColor);
        }
        this.mController.selectPosition(this.currentlySelectedItem);
    }

    private void handleIllegalSlideChangeAttempt() {
        ISlidePolicy slide;
        Fragment currentFragment = this.mPagerAdapter.getItem(this.pager.getCurrentItem());
        if (currentFragment != null && currentFragment instanceof ISlidePolicy && !(slide = (ISlidePolicy)currentFragment).isPolicyRespected()) {
            slide.onUserIllegallyRequestedNextPage();
        }
    }

    private boolean handleBeforeSlideChanged() {
        Fragment currentFragment = this.mPagerAdapter.getItem(this.pager.getCurrentItem());
        Log.d((String)TAG, (String)String.format("User wants to move away from slide: %s. Checking if this should be allowed...", currentFragment));
        if (currentFragment instanceof ISlidePolicy) {
            ISlidePolicy slide = (ISlidePolicy)currentFragment;
            Log.d((String)TAG, (String)"Current fragment implements ISlidePolicy.");
            if (!slide.isPolicyRespected()) {
                Log.d((String)TAG, (String)"Slide policy not respected, denying change request.");
                return false;
            }
        }
        Log.d((String)TAG, (String)"Change request will be allowed.");
        return true;
    }

    private void handleSlideChanged(Fragment oldFragment, Fragment newFragment) {
        if (oldFragment != null && oldFragment instanceof ISlideSelectionListener) {
            ((ISlideSelectionListener)oldFragment).onSlideDeselected();
        }
        if (newFragment != null && newFragment instanceof ISlideSelectionListener) {
            ((ISlideSelectionListener)newFragment).onSlideSelected();
        }
        this.onSlideChanged(oldFragment, newFragment);
    }

    protected abstract int getLayoutId();

    protected void onPageSelected(int position) {
    }

    public boolean isSkipButtonEnabled() {
        return this.skipButtonEnabled;
    }

    public void onSkipPressed(Fragment currentFragment) {
        this.onSkipPressed();
    }

    protected void setScrollDurationFactor(int factor) {
        this.pager.setScrollDurationFactor(factor);
    }

    protected void setButtonState(View button, boolean show) {
        if (show) {
            button.setVisibility(0);
        } else {
            button.setVisibility(4);
        }
    }

    public AppIntroViewPager getPager() {
        return this.pager;
    }

    @NonNull
    public List<Fragment> getSlides() {
        return this.mPagerAdapter.getFragments();
    }

    public void addSlide(@NonNull Fragment fragment) {
        this.fragments.add(fragment);
        this.mPagerAdapter.notifyDataSetChanged();
    }

    public void setProgressButtonEnabled(boolean progressButtonEnabled) {
        this.progressButtonEnabled = progressButtonEnabled;
        if (progressButtonEnabled) {
            if (this.pager.getCurrentItem() == this.slidesNumber - 1) {
                this.setButtonState(this.nextButton, false);
                this.setButtonState(this.doneButton, true);
                this.setButtonState(this.skipButton, false);
            } else {
                this.setButtonState(this.nextButton, true);
                this.setButtonState(this.doneButton, false);
                this.setButtonState(this.skipButton, this.skipButtonEnabled);
            }
        } else {
            this.setButtonState(this.nextButton, false);
            this.setButtonState(this.doneButton, false);
            this.setButtonState(this.skipButton, false);
        }
    }

    public boolean isProgressButtonEnabled() {
        return this.progressButtonEnabled;
    }

    public void setOffScreenPageLimit(int limit) {
        this.pager.setOffscreenPageLimit(limit);
    }

    public void init(@Nullable Bundle savedInstanceState) {
    }

    public void onNextPressed() {
    }

    public void onDonePressed() {
    }

    public void onSkipPressed() {
    }

    public void onSlideChanged() {
    }

    public void onDonePressed(Fragment currentFragment) {
        this.onDonePressed();
    }

    public void onSlideChanged(@Nullable Fragment oldFragment, @Nullable Fragment newFragment) {
        this.onSlideChanged();
    }

    public boolean onKeyDown(int code, KeyEvent kvent) {
        if (code == 66 || code == 96 || code == 23) {
            ViewPager vp = (ViewPager)this.findViewById(R.id.view_pager);
            if (vp.getCurrentItem() == vp.getAdapter().getCount() - 1) {
                this.onDonePressed(this.fragments.get(vp.getCurrentItem()));
            } else {
                vp.setCurrentItem(vp.getCurrentItem() + 1);
            }
            return false;
        }
        return super.onKeyDown(code, kvent);
    }

    public void setNavBarColor(String Color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setNavigationBarColor(Color.parseColor((String)Color2));
        }
    }

    public void setNavBarColor(@ColorRes int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setNavigationBarColor(ContextCompat.getColor((Context)this, (int)color));
        }
    }

    public void showStatusBar(boolean isVisible) {
        if (!isVisible) {
            this.getWindow().setFlags(1024, 1024);
        } else {
            this.getWindow().clearFlags(1024);
        }
    }

    public void setVibrate(boolean vibrationEnabled) {
        this.isVibrateOn = vibrationEnabled;
    }

    public void setVibrateIntensity(int intensity) {
        this.vibrateIntensity = intensity;
    }

    public void setProgressIndicator() {
        this.mController = new ProgressIndicatorController();
    }

    public void setCustomIndicator(@NonNull IndicatorController controller) {
        this.mController = controller;
    }

    public void setColorTransitionsEnabled(boolean colorTransitionsEnabled) {
        this.areColorTransitionsEnabled = colorTransitionsEnabled;
    }

    public void setFadeAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.FADE));
    }

    public void setZoomAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.ZOOM));
    }

    public void setFlowAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.FLOW));
    }

    public void setSlideOverAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.SLIDE_OVER));
    }

    public void setDepthAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.DEPTH));
    }

    public void setCustomTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.pager.setPageTransformer(true, transformer);
    }

    public void setIndicatorColor(int selectedIndicatorColor, int unselectedIndicatorColor) {
        this.selectedIndicatorColor = selectedIndicatorColor;
        this.unselectedIndicatorColor = unselectedIndicatorColor;
        if (this.mController != null) {
            if (selectedIndicatorColor != 1) {
                this.mController.setSelectedIndicatorColor(selectedIndicatorColor);
            }
            if (unselectedIndicatorColor != 1) {
                this.mController.setUnselectedIndicatorColor(unselectedIndicatorColor);
            }
        }
    }

    public void setNextPageSwipeLock(boolean lockEnable) {
        if (lockEnable) {
            this.baseProgressButtonEnabled = this.progressButtonEnabled;
            this.setProgressButtonEnabled(!lockEnable);
        } else {
            this.setProgressButtonEnabled(this.baseProgressButtonEnabled);
        }
        this.pager.setNextPagingEnabled(!lockEnable);
    }

    public void setSwipeLock(boolean lockEnable) {
        if (lockEnable) {
            this.baseProgressButtonEnabled = this.progressButtonEnabled;
        } else {
            this.setProgressButtonEnabled(this.baseProgressButtonEnabled);
        }
        this.pager.setPagingEnabled(!lockEnable);
    }

    public void setGoBackLock(boolean lockEnabled) {
        this.isGoBackLockEnabled = lockEnabled;
    }

    public void setImmersiveMode(boolean isEnabled) {
        this.setImmersiveMode(isEnabled, false);
    }

    public void setImmersiveMode(boolean isEnabled, boolean isSticky) {
        if (Build.VERSION.SDK_INT >= 19) {
            if (!isEnabled && this.isImmersiveModeEnabled) {
                this.getWindow().getDecorView().setSystemUiVisibility(1792);
                this.isImmersiveModeEnabled = false;
            } else if (isEnabled) {
                int flags = 1798;
                if (isSticky) {
                    flags |= 0x1000;
                    this.isImmersiveModeSticky = true;
                } else {
                    flags |= 0x800;
                    this.isImmersiveModeSticky = false;
                }
                this.getWindow().getDecorView().setSystemUiVisibility(flags);
                this.isImmersiveModeEnabled = true;
            }
        }
    }

    public void askForPermissions(String[] permissions, int slidesNumber) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (slidesNumber == 0) {
                Toast.makeText((Context)this.getBaseContext(), (CharSequence)"Invalid Slide Number", (int)0).show();
            } else {
                PermissionObject permission = new PermissionObject(permissions, slidesNumber);
                this.permissionsArray.add(permission);
                this.setSwipeLock(true);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                this.pager.setCurrentItem(this.pager.getCurrentItem() + 1);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Unexpected request code");
            }
        }
    }

    private final class WindowGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private WindowGestureListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (AppIntroBase.this.isImmersiveModeEnabled && !AppIntroBase.this.isImmersiveModeSticky) {
                AppIntroBase.this.setImmersiveMode(true, AppIntroBase.this.isImmersiveModeSticky);
            }
            return false;
        }
    }

    private final class PagerOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private PagerOnPageChangeListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (AppIntroBase.this.areColorTransitionsEnabled && position < AppIntroBase.this.mPagerAdapter.getCount() - 1) {
                if (AppIntroBase.this.mPagerAdapter.getItem(position) instanceof ISlideBackgroundColorHolder && AppIntroBase.this.mPagerAdapter.getItem(position + 1) instanceof ISlideBackgroundColorHolder) {
                    Fragment currentSlide = AppIntroBase.this.mPagerAdapter.getItem(position);
                    Fragment nextSlide = AppIntroBase.this.mPagerAdapter.getItem(position + 1);
                    ISlideBackgroundColorHolder currentSlideCasted = (ISlideBackgroundColorHolder)currentSlide;
                    ISlideBackgroundColorHolder nextSlideCasted = (ISlideBackgroundColorHolder)nextSlide;
                    if (currentSlide.isAdded() && nextSlide.isAdded()) {
                        int newColor = (Integer)AppIntroBase.this.argbEvaluator.evaluate(positionOffset, (Object)currentSlideCasted.getDefaultBackgroundColor(), (Object)nextSlideCasted.getDefaultBackgroundColor());
                        currentSlideCasted.setBackgroundColor(newColor);
                        nextSlideCasted.setBackgroundColor(newColor);
                    }
                } else {
                    throw new IllegalStateException("Color transitions are only available if all slides implement ISlideBackgroundColorHolder.");
                }
            }
        }

        public void onPageSelected(int position) {
            if (AppIntroBase.this.slidesNumber > 1) {
                AppIntroBase.this.mController.selectPosition(position);
            }
            if (!AppIntroBase.this.pager.isNextPagingEnabled()) {
                if (AppIntroBase.this.pager.getCurrentItem() != AppIntroBase.this.pager.getLockPage()) {
                    AppIntroBase.this.setProgressButtonEnabled(AppIntroBase.this.baseProgressButtonEnabled);
                    AppIntroBase.this.pager.setNextPagingEnabled(true);
                } else {
                    AppIntroBase.this.setProgressButtonEnabled(AppIntroBase.this.progressButtonEnabled);
                }
            } else {
                AppIntroBase.this.setProgressButtonEnabled(AppIntroBase.this.progressButtonEnabled);
            }
            AppIntroBase.this.onPageSelected(position);
            if (AppIntroBase.this.slidesNumber > 0) {
                if (AppIntroBase.this.currentlySelectedItem == -1) {
                    AppIntroBase.this.handleSlideChanged(null, AppIntroBase.this.mPagerAdapter.getItem(position));
                } else {
                    AppIntroBase.this.handleSlideChanged(AppIntroBase.this.mPagerAdapter.getItem(AppIntroBase.this.currentlySelectedItem), AppIntroBase.this.mPagerAdapter.getItem(AppIntroBase.this.pager.getCurrentItem()));
                }
            }
            AppIntroBase.this.currentlySelectedItem = position;
        }

        public void onPageScrollStateChanged(int state) {
        }
    }

    private final class NextButtonOnClickListener
    implements View.OnClickListener {
        private NextButtonOnClickListener() {
        }

        public void onClick(View v) {
            boolean isSlideChangingAllowed;
            if (AppIntroBase.this.isVibrateOn) {
                AppIntroBase.this.mVibrator.vibrate((long)AppIntroBase.this.vibrateIntensity);
            }
            if (isSlideChangingAllowed = AppIntroBase.this.handleBeforeSlideChanged()) {
                boolean requestPermission = false;
                int position = 0;
                int i = 0;
                if (i < AppIntroBase.this.permissionsArray.size()) {
                    requestPermission = AppIntroBase.this.pager.getCurrentItem() + 1 == AppIntroBase.this.permissionsArray.get(i).getPosition();
                    position = i;
                }
                if (requestPermission) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        AppIntroBase.this.requestPermissions(AppIntroBase.this.permissionsArray.get(position).getPermission(), 1);
                        AppIntroBase.this.permissionsArray.remove(position);
                    } else {
                        AppIntroBase.this.pager.setCurrentItem(AppIntroBase.this.pager.getCurrentItem() + 1);
                        AppIntroBase.this.onNextPressed();
                    }
                } else {
                    AppIntroBase.this.pager.setCurrentItem(AppIntroBase.this.pager.getCurrentItem() + 1);
                    AppIntroBase.this.onNextPressed();
                }
            } else {
                AppIntroBase.this.handleIllegalSlideChangeAttempt();
            }
        }
    }
}

