/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.paolorotolo.appintro.FadePageTransformer;
import com.github.paolorotolo.appintro.PagerAdapter;
import com.github.paolorotolo.appintro.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class AppIntro
extends FragmentActivity {
    private PagerAdapter mPagerAdapter;
    private ViewPager pager;
    private List<Fragment> fragments = new Vector<Fragment>();
    private List<ImageView> dots;
    private int slidesNumber;
    private Vibrator mVibrator;
    private boolean isVibrateOn = false;
    private int vibrateIntensity = 20;
    private boolean showSkip = true;
    private static final int FIRST_PAGE_NUM = 0;

    protected final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.intro_layout);
        final TextView skipButton = (TextView)this.findViewById(R.id.skip);
        final ImageView nextButton = (ImageView)this.findViewById(R.id.next);
        final TextView doneButton = (TextView)this.findViewById(R.id.done);
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        skipButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro.this.isVibrateOn) {
                    AppIntro.this.mVibrator.vibrate((long)AppIntro.this.vibrateIntensity);
                }
                AppIntro.this.onSkipPressed();
            }
        });
        nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro.this.isVibrateOn) {
                    AppIntro.this.mVibrator.vibrate((long)AppIntro.this.vibrateIntensity);
                }
                AppIntro.this.pager.setCurrentItem(AppIntro.this.pager.getCurrentItem() + 1);
            }
        });
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro.this.isVibrateOn) {
                    AppIntro.this.mVibrator.vibrate((long)AppIntro.this.vibrateIntensity);
                }
                AppIntro.this.onDonePressed();
            }
        });
        this.mPagerAdapter = new PagerAdapter(super.getSupportFragmentManager(), this.fragments);
        this.pager = (ViewPager)this.findViewById(R.id.view_pager);
        this.pager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
        this.pager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                AppIntro.this.selectDot(position);
                if (position == AppIntro.this.slidesNumber - 1) {
                    skipButton.setVisibility(4);
                    nextButton.setVisibility(8);
                    doneButton.setVisibility(0);
                } else {
                    skipButton.setVisibility(0);
                    doneButton.setVisibility(8);
                    nextButton.setVisibility(0);
                }
                if (!AppIntro.this.showSkip) {
                    skipButton.setVisibility(4);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.init(savedInstanceState);
        this.loadDots();
    }

    private void loadDots() {
        LinearLayout dotLayout = (LinearLayout)this.findViewById(R.id.dotLayout);
        this.dots = new ArrayList<ImageView>();
        this.slidesNumber = this.fragments.size();
        for (int i = 0; i < this.slidesNumber; ++i) {
            ImageView dot = new ImageView((Context)this);
            dot.setImageDrawable(this.getResources().getDrawable(R.drawable.indicator_dot_grey));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            dotLayout.addView((View)dot, (ViewGroup.LayoutParams)params);
            this.dots.add(dot);
        }
        this.selectDot(0);
    }

    public void selectDot(int index) {
        Resources res = this.getResources();
        for (int i = 0; i < this.fragments.size(); ++i) {
            int drawableId = i == index ? R.drawable.indicator_dot_white : R.drawable.indicator_dot_grey;
            Drawable drawable2 = res.getDrawable(drawableId);
            this.dots.get(i).setImageDrawable(drawable2);
        }
    }

    public void addSlide(@NonNull Fragment fragment) {
        this.fragments.add(fragment);
        this.mPagerAdapter.notifyDataSetChanged();
    }

    @NonNull
    public List<Fragment> getSlides() {
        return this.mPagerAdapter.getFragments();
    }

    public void setBarColor(@ColorInt int color) {
        LinearLayout bottomBar = (LinearLayout)this.findViewById(R.id.bottom);
        bottomBar.setBackgroundColor(color);
    }

    public void setSeparatorColor(@ColorInt int color) {
        TextView separator = (TextView)this.findViewById(R.id.bottom_separator);
        separator.setBackgroundColor(color);
    }

    public void setSkipText(@Nullable String text) {
        TextView skipText = (TextView)this.findViewById(R.id.skip);
        skipText.setText((CharSequence)text);
    }

    public void setDoneText(@Nullable String text) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setText((CharSequence)text);
    }

    public void showSkipButton(boolean showButton) {
        this.showSkip = showButton;
        if (!showButton) {
            TextView skip = (TextView)this.findViewById(R.id.skip);
            skip.setVisibility(4);
        }
    }

    public void setVibrate(boolean vibrate) {
        this.isVibrateOn = vibrate;
    }

    public void setVibrateIntensity(int intensity) {
        this.vibrateIntensity = intensity;
    }

    public void setFadeAnimation() {
        this.pager.setPageTransformer(true, (ViewPager.PageTransformer)new FadePageTransformer());
    }

    public void setCustomTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.pager.setPageTransformer(true, transformer);
    }

    public void setOffScreenPageLimit(int limit) {
        this.pager.setOffscreenPageLimit(limit);
    }

    public abstract void init(@Nullable Bundle var1);

    public abstract void onSkipPressed();

    public abstract void onDonePressed();

    public boolean onKeyDown(int code, KeyEvent kvent) {
        if (code == 66 || code == 96) {
            ViewPager vp = (ViewPager)this.findViewById(R.id.view_pager);
            if (vp.getCurrentItem() == vp.getAdapter().getCount() - 1) {
                this.onDonePressed();
            } else {
                vp.setCurrentItem(vp.getCurrentItem() + 1);
            }
            return false;
        }
        return super.onKeyDown(code, kvent);
    }
}

