/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.paolorotolo.appintro.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class AppIntro
extends FragmentActivity {
    private PagerAdapter mPagerAdapter;
    private ViewPager pager;
    private List<Fragment> fragments = new Vector<Fragment>();
    private List<ImageView> dots;
    private int slidesNumber;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.intro_layout);
        final TextView skip = (TextView)this.findViewById(R.id.skip);
        final ImageView next = (ImageView)this.findViewById(R.id.next);
        final TextView done = (TextView)this.findViewById(R.id.done);
        skip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppIntro.this.onSkipPressed();
            }
        });
        next.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppIntro.this.pager.setCurrentItem(AppIntro.this.pager.getCurrentItem() + 1);
            }
        });
        done.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppIntro.this.onDonePressed();
            }
        });
        this.mPagerAdapter = new PagerAdapter(super.getSupportFragmentManager(), this.fragments);
        this.pager = (ViewPager)this.findViewById(R.id.view_pager);
        this.pager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
        this.pager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                AppIntro.this.selectDot(position);
                if (position == AppIntro.this.slidesNumber - 1) {
                    skip.setVisibility(4);
                    next.setVisibility(8);
                    done.setVisibility(0);
                } else {
                    skip.setVisibility(0);
                    done.setVisibility(8);
                    next.setVisibility(0);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.init(savedInstanceState);
        this.loadDots();
        this.selectDot(0);
    }

    private void loadDots() {
        LinearLayout dotLayout = (LinearLayout)this.findViewById(R.id.dotLayout);
        this.dots = new ArrayList<ImageView>();
        this.slidesNumber = this.fragments.size();
        for (int i = 0; i < this.slidesNumber; ++i) {
            ImageView dot = new ImageView((Context)this);
            dot.setImageDrawable(this.getResources().getDrawable(R.drawable.indicator_dot_grey));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            dotLayout.addView((View)dot, (ViewGroup.LayoutParams)params);
            this.dots.add(dot);
        }
    }

    public void selectDot(int idx) {
        Resources res = this.getResources();
        for (int i = 0; i < this.fragments.size(); ++i) {
            int drawableId = i == idx ? R.drawable.indicator_dot_white : R.drawable.indicator_dot_grey;
            Drawable drawable2 = res.getDrawable(drawableId);
            this.dots.get(i).setImageDrawable(drawable2);
        }
    }

    public void addSlide(Fragment fragment, Context context) {
        this.fragments.add(Fragment.instantiate((Context)context, (String)fragment.getClass().getName()));
        this.mPagerAdapter.notifyDataSetChanged();
    }

    public void setBarColor(int color) {
        LinearLayout bottomBar = (LinearLayout)this.findViewById(R.id.bottom);
        bottomBar.setBackgroundColor(color);
    }

    public void setSeparatorColor(int color) {
        TextView separator = (TextView)this.findViewById(R.id.bottom_separator);
        separator.setBackgroundColor(color);
    }

    public abstract void init(Bundle var1);

    public abstract void onSkipPressed();

    public abstract void onDonePressed();

    public class PagerAdapter
    extends FragmentPagerAdapter {
        private List<Fragment> fragments;

        public PagerAdapter(FragmentManager fm, List<Fragment> fragments) {
            super(fm);
            this.fragments = fragments;
        }

        public Fragment getItem(int position) {
            return this.fragments.get(position);
        }

        public int getCount() {
            return this.fragments.size();
        }
    }
}

