/*
 * Decompiled with CFR 0.152.
 */
package com.github.panxiaole.polestar.doc.config;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
@Component
public class SwaggerResourceConfig
implements SwaggerResourcesProvider {
    private static final Logger log = LoggerFactory.getLogger(SwaggerResourceConfig.class);
    @Autowired
    RouteLocator routeLocator;

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        List routes = this.routeLocator.getRoutes();
        log.info("Route Size:{}", (Object)routes.size());
        for (Route route : routes) {
            resources.add(this.swaggerResource(route.getId(), route.getFullPath().replace("**", "v2/api-docs")));
        }
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location) {
        log.info("name:{},location:{}", (Object)name, (Object)location);
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }
}

