/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.tools4a.systemproperties;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Method;

public class SystemPropertiesx {
    private SystemPropertiesx() {
    }

    @NonNull
    public static String get(@NonNull String key) {
        String value = GetStringMethodHolder.get(key);
        return value != null ? value : "";
    }

    @NonNull
    public static String getOr(@NonNull String key, @NonNull String defaultValue) {
        String value = GetStringDefMethodHolder.get(key, defaultValue);
        return value != null ? value : "";
    }

    public static int getIntOr(@NonNull String key, int defaultValue) {
        return GetIntMethodHolder.getInt(key, defaultValue);
    }

    public static long getLongOr(@NonNull String key, long defaultValue) {
        return GetLongMethodHolder.getLong(key, defaultValue);
    }

    public static boolean getBooleanOr(@NonNull String key, boolean defaultValue) {
        return GetBooleanMethodHolder.getBoolean(key, defaultValue);
    }

    public static void set(@NonNull String key, @NonNull String value) {
        SetMethodHolder.set(key, value);
    }

    public static void addChangeCallback(@NonNull Runnable runnable) {
        AddChangedCallbackMethodHolder.addChangeCallback(runnable);
    }

    public static void callChangeCallbacks() {
        CallChangeCallbacksMethodHolder.callChangeCallbacks();
    }

    @SuppressLint(value={"SoonBlockedPrivateApi", "PrivateApi"})
    private static class CallChangeCallbacksMethodHolder {
        @Nullable
        private static final Method METHOD;

        private CallChangeCallbacksMethodHolder() {
        }

        static void callChangeCallbacks() {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("callChangeCallbacks", new Class[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    private static class AddChangedCallbackMethodHolder {
        @Nullable
        private static final Method METHOD;

        private AddChangedCallbackMethodHolder() {
        }

        static void addChangeCallback(@NonNull Runnable runnable) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    method.invoke(null, runnable);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("addChangeCallback", Runnable.class);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    private static class SetMethodHolder {
        @Nullable
        private static final Method METHOD;

        private SetMethodHolder() {
        }

        static void set(@NonNull String key, @NonNull String value) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    method.invoke(null, key, value);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("set", String.class, String.class);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static class GetBooleanMethodHolder {
        @Nullable
        private static final Method METHOD;

        private GetBooleanMethodHolder() {
        }

        static boolean getBoolean(@NonNull String key, boolean defaultValue) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    return (Boolean)method.invoke(null, key, defaultValue);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return defaultValue;
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("getBoolean", String.class, Boolean.TYPE);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static class GetLongMethodHolder {
        @Nullable
        private static final Method METHOD;

        private GetLongMethodHolder() {
        }

        static long getLong(@NonNull String key, long defaultValue) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    return (Long)method.invoke(null, key, defaultValue);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return defaultValue;
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("getLong", String.class, Long.TYPE);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static class GetIntMethodHolder {
        @Nullable
        private static final Method METHOD;

        private GetIntMethodHolder() {
        }

        static int getInt(@NonNull String key, int defaultValue) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    return (Integer)method.invoke(null, key, defaultValue);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return defaultValue;
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("getInt", String.class, Integer.TYPE);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static class GetStringDefMethodHolder {
        @Nullable
        private static final Method METHOD;

        private GetStringDefMethodHolder() {
        }

        @Nullable
        static String get(@NonNull String key, @NonNull String defaultValue) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    return (String)method.invoke(null, key, defaultValue);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return null;
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("get", String.class, String.class);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static class GetStringMethodHolder {
        @Nullable
        private static final Method METHOD;

        private GetStringMethodHolder() {
        }

        @Nullable
        static String get(@NonNull String key) {
            Method method = METHOD;
            if (method != null) {
                method.setAccessible(true);
                try {
                    return (String)method.invoke(null, key);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return null;
        }

        static {
            Method method = null;
            try {
                method = Class.forName("android.os.SystemProperties").getDeclaredMethod("get", String.class);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            METHOD = method;
        }
    }
}

