/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.tools4a.fileprovider;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import java.io.File;

public class FileProviderx {
    private FileProviderx() {
    }

    @NonNull
    public static Uri getShareFileUri(@NonNull Context context, @NonNull File file, @NonNull String authority) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    @NonNull
    public static Uri getShareFileUri(@NonNull Context context, @NonNull File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            ProviderInfo fileProviderInfo = null;
            try {
                fileProviderInfo = FileProviderx.findFileProviderInfo(context);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            if (fileProviderInfo == null) {
                throw new IllegalStateException("Please configure the provider 'androidx.core.content.FileProvider' in the AndroidManifest.xml file");
            }
            return FileProvider.getUriForFile((Context)context, (String)fileProviderInfo.authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    @Nullable
    private static ProviderInfo findFileProviderInfo(@NonNull Context context) throws PackageManager.NameNotFoundException {
        String providerName = FileProvider.class.getName();
        PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 8);
        ProviderInfo[] providerInfos = info.providers;
        if (providerInfos != null) {
            for (ProviderInfo providerInfo : providerInfos) {
                String providerInfoName = providerInfo.name;
                if (providerInfoName == null || !providerInfoName.equals(providerName)) continue;
                return providerInfo;
            }
        }
        return null;
    }
}

